/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.22
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIG_NOINCLUDE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define PROTECTFUNC(f) ((VALUE (*)()) f)
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define PROTECTFUNC(f) ((VALUE (*)()) f)
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7+ */
#      define PROTECTFUNC(f) ((VALUE (*)(VALUE)) f)
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypePrettyName  SWIG_Ruby_TypePrettyName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(const char *)     SWIG_TypePrettyName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;
static swig_type_info **swig_type_list_handle = &swig_type_list;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = *swig_type_list_handle;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = *swig_type_list_handle;
  *swig_type_list_handle = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Return the pretty name associated with this type,
   that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME(const char *)
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Compare two type names skipping the space characters, therefore
   "char*" == "char *" and "Class<int>" == "Class<int >", etc.

   Return 0 when the two name types are equivalent, as in
   strncmp, but skipping ' '.
*/
static int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return *f1 - *f2;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
*/
static int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = SWIG_TypeNameComp(nb, ne, tb, te) == 0;
    if (*ne) ++ne;
  }
  return equiv;
}
  

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = *swig_type_list_handle;
  while (ty) {
    if (ty->str && (SWIG_TypeEquiv(ty->str,name))) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = *swig_type_list_handle;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  register unsigned char uu;
  for (; u != eu; ++u) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydec.swg -*- c -*- */
#ifdef __cplusplus
extern "C" {
#endif

SWIGIMPORT(void)   SWIG_Ruby_InitRuntime(void);
SWIGIMPORT(void)   SWIG_Ruby_define_class(swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPointerObj(void *, swig_type_info *, int);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewClassInstance(VALUE, swig_type_info *);
SWIGIMPORT(char *) SWIG_Ruby_MangleStr(VALUE);
SWIGIMPORT(int)    SWIG_Ruby_ConvertPtr(VALUE, void**, swig_type_info *, int);
SWIGIMPORT(void *) SWIG_Ruby_MustGetPtr(VALUE, swig_type_info *, int, int);
SWIGIMPORT(int)    SWIG_Ruby_CheckConvert(VALUE, swig_type_info *);
SWIGIMPORT(VALUE)  SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type);
SWIGIMPORT(void)   SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags);

#ifdef __cplusplus
}
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_FXDC swig_types[0] 
#define  SWIGTYPE_p_FXObject swig_types[1] 
#define  SWIGTYPE_p_FXScrollArea swig_types[2] 
#define  SWIGTYPE_p_FXWindow swig_types[3] 
#define  SWIGTYPE_p_FXComposite swig_types[4] 
#define  SWIGTYPE_p_FXId swig_types[5] 
#define  SWIGTYPE_p_FXFont swig_types[6] 
#define  SWIGTYPE_p_FXTable swig_types[7] 
#define  SWIGTYPE_p_FXStream swig_types[8] 
#define  SWIGTYPE_p_FXDrawable swig_types[9] 
#define  SWIGTYPE_p_FXTableRange swig_types[10] 
#define  SWIGTYPE_p_FXIcon swig_types[11] 
#define  SWIGTYPE_p_FXHeader swig_types[12] 
#define  SWIGTYPE_p_FXTableItem swig_types[13] 
#define  SWIGTYPE_p_FXTablePos swig_types[14] 
static swig_type_info *swig_types[16];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_table
#define SWIG_name    "Table"


static void SWIG_AsVal(VALUE obj, int *val)
{
    *val = (int) NUM2INT(obj);
}


#include "FXRbCommon.h"


inline FXColor to_FXColor(VALUE obj){
  if(TYPE(obj)==T_STRING){
    return fxcolorfromname(StringValuePtr(obj));
    }
  else if(TYPE(obj)==T_SYMBOL){
    return fxcolorfromname(rb_id2name(SYM2ID(obj)));
    }
  else{
    return NUM2ULONG(obj);
    }
  }


inline FXString to_FXString(VALUE obj){
  if(!NIL_P(obj)){
    Check_Type(obj,T_STRING);
    return FXString(STR2CSTR(obj));
    }
  else{
    return FXString::null;
    }
  }


inline FXbool to_FXbool(VALUE obj){
  if (obj == Qtrue || obj == Qfalse){
    return (obj == Qtrue) ? TRUE : FALSE;
    }
  else{
    return static_cast<FXbool>(NUM2UINT(obj));
    }
  }


static swig_type_info* FXEventTypeInfo=0;

inline void* to_FXEvent(VALUE obj){
  void* ptr;
  if(!FXEventTypeInfo){
    FXEventTypeInfo=SWIG_TypeQuery("FXEvent *");
    FXASSERT(FXEventTypeInfo!=0);
    }
  SWIG_ConvertPtr(obj,&ptr,FXEventTypeInfo,1);
  return ptr;
  }


swig_class cFXTablePos;
static void free_FXTablePos(FXTablePos *);

swig_class cFXTableRange;
static void free_FXTableRange(FXTableRange *);
FXTableItem *new_FXTableItem(FXString const &text,FXIcon *ic,void *ptr){
      return new FXRbTableItem(text,ic,ptr);
      }
void FXTableItem_setData(FXTableItem *self,VALUE ptr){
      self->setData(reinterpret_cast<void*>(ptr));
      }
VALUE FXTableItem_getData(FXTableItem const *self){
      return self->getData() ? reinterpret_cast<VALUE>(self->getData()) : Qnil;
      }

swig_class cFXTableItem;
static void free_FXTableItem(FXTableItem *);
FXTable *new_FXTable(FXComposite *p,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb){
      return new FXRbTable(p,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
      }
void FXTable_setItem(FXTable *self,FXint row,FXint col,FXTableItem *item,FXbool notify){
      if(item!=0 && item->isMemberOf(FXMETACLASS(FXRbTableItem))){
        dynamic_cast<FXRbTableItem*>(item)->owned=1;
        }
      self->setItem(row,col,item,notify);
      }
FXint FXTable_getColumnX(FXTable const *self,FXint colEdge){
      if(colEdge<0 || self->getColumnHeader()->getNumItems()<=colEdge){
        rb_raise(rb_eIndexError,"table column out of bounds");
        }
      return self->getColumnX(colEdge);
      }
FXint FXTable_getRowY(FXTable const *self,FXint rowEdge){
      if(rowEdge<0 || self->getRowHeader()->getNumItems()<=rowEdge){
        rb_raise(rb_eIndexError,"table row out of bounds");
        }
      return self->getRowY(rowEdge);
      }
void FXTable_setItemText(FXTable *self,FXint r,FXint c,FXString const &text){
      FXRbTableItem* item;
      self->setItemText(r,c,text);
      item=dynamic_cast<FXRbTableItem*>(self->getItem(r,c));
      if(item!=0){
        item->owned=1;
        }
      }
void FXTable_setItemIcon(FXTable *self,FXint r,FXint c,FXIcon *icon){
      FXRbTableItem* item;
      self->setItemIcon(r,c,icon);
      item=dynamic_cast<FXRbTableItem*>(self->getItem(r,c));
      if(item!=0){
        item->owned=1;
        }
      }
void FXTable_setItemData(FXTable *self,FXint r,FXint c,VALUE ptr){
      FXRbTableItem* item;
      self->setItemData(r,c,reinterpret_cast<void*>(ptr));
      item=dynamic_cast<FXRbTableItem*>(self->getItem(r,c));
      if(item!=0){
        item->owned=1;
        }
      }
VALUE FXTable_getItemData(FXTable const *self,FXint r,FXint c){
      void* ptr=self->getItemData(r,c);
      return (ptr!=0) ? reinterpret_cast<VALUE>(ptr) : Qnil;
      }
VALUE FXTable_extractText(FXTable const *self,FXint startrow,FXint endrow,FXint startcol,FXint endcol,FXchar cs,FXchar rs){
      FXchar* text;
      FXint size;
      VALUE result;
      if(startrow<0 || startcol<0 || self->getNumRows()<=endrow || self->getNumColumns()<=endcol) rb_raise(rb_eIndexError,"index out of bounds");
      self->extractText(text,size,startrow,endrow,startcol,endcol,cs,rs);
      result=rb_str_new2(text);
      FXFREE(&text);
      return result;
      }
void FXTable_overlayText(FXTable *self,FXint startrow,FXint endrow,FXint startcol,FXint endcol,VALUE str,FXchar cs,FXchar rs){
      if(startrow<0 || startcol<0 || self->getNumRows()<=endrow || self->getNumColumns()<=endcol) rb_raise(rb_eIndexError,"index out of bounds");
      const FXchar* text=reinterpret_cast<FXchar*>(STR2CSTR(str));
      FXint size=RSTRING(str)->len;
      self->overlayText(startrow,endrow,startcol,endcol,text,size,cs,rs);
      }
void FXTable_updateRange(FXTable const *self,FXint sr,FXint er,FXint sc,FXint ec){
      if(sr<0 || sc<0 || self->getNumRows()<=er || self->getNumColumns()<=ec) rb_raise(rb_eIndexError,"index out of bounds");
      self->updateRange(sr,er,sc,ec);
      }
VALUE FXTable_position__SWIG_1(FXTable const *self){
    FXint x, y;
    self->getPosition(x, y);
    VALUE pos = rb_ary_new();
    rb_ary_push(pos, INT2NUM(x));
    rb_ary_push(pos, INT2NUM(y));
    return pos;
  }

swig_class cFXTable;
static void free_FXTable(FXTable *);
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTablePos_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTablePos_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTablePos);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTablePos(int argc, VALUE *argv, VALUE self) { FXTablePos *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXTablePos *)new FXTablePos();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXTablePos_row_set(int argc, VALUE *argv, VALUE self) { FXTablePos *arg1 = (FXTablePos *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTablePos, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->row = arg2;
    return Qnil; }
static VALUE _wrap_FXTablePos_row_get(int argc, VALUE *argv, VALUE self) { FXTablePos *arg1 = (FXTablePos *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTablePos, 1); result = (FXint) ((arg1)->row); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTablePos_col_set(int argc, VALUE *argv, VALUE self) { FXTablePos *arg1 = (FXTablePos *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTablePos, 1); arg2 = NUM2INT(argv[0]); if (arg1) (arg1)->col = arg2;
    return Qnil; }
static VALUE _wrap_FXTablePos_col_get(int argc, VALUE *argv, VALUE self) { FXTablePos *arg1 = (FXTablePos *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTablePos, 1); result = (FXint) ((arg1)->col); vresult = INT2NUM(result);
    return vresult; }
static void
free_FXTablePos(FXTablePos *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTableRange_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTableRange_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTableRange);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTableRange(int argc, VALUE *argv, VALUE self) { FXTableRange *result; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc); result = (FXTableRange *)new FXTableRange();
    DATA_PTR(self) = result; return self; }
static VALUE _wrap_FXTableRange_fm_set(int argc, VALUE *argv, VALUE self) { FXTableRange *arg1 = (FXTableRange *) 0 ;
    FXTablePos *arg2 = (FXTablePos *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableRange, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTablePos, 1); if (arg1) (arg1)->fm = *arg2; return Qnil; }
static VALUE _wrap_FXTableRange_fm_get(int argc, VALUE *argv, VALUE self) { FXTableRange *arg1 = (FXTableRange *) 0 ;
    FXTablePos *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableRange, 1); result = (FXTablePos *)& ((arg1)->fm);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXTablePos,0); return vresult; }
static VALUE _wrap_FXTableRange_to_set(int argc, VALUE *argv, VALUE self) { FXTableRange *arg1 = (FXTableRange *) 0 ;
    FXTablePos *arg2 = (FXTablePos *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableRange, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTablePos, 1); if (arg1) (arg1)->to = *arg2; return Qnil; }
static VALUE _wrap_FXTableRange_to_get(int argc, VALUE *argv, VALUE self) { FXTableRange *arg1 = (FXTableRange *) 0 ;
    FXTablePos *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableRange, 1); result = (FXTablePos *)& ((arg1)->to);
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_FXTablePos,0); return vresult; }
static void
free_FXTableRange(FXTableRange *arg1) {
    delete arg1;
}
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTableItem_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTableItem_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTableItem);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTableItem(int argc, VALUE *argv, VALUE self) { FXString *arg1 = 0 ; FXIcon *arg2 = (FXIcon *) 0 ;
    void *arg3 = (void *) 0 ; FXTableItem *result; SwigValueWrapper<FXString > p1 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc); p1 = to_FXString(argv[0]); arg1 = &p1; if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); }  if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg3, 0, 1); }  {
        result = (FXTableItem *)new_FXTableItem((FXString const &)*arg1,arg2,arg3);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTableItem_getText(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXString *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); {
        FXString const &_result_ref = ((FXTableItem const *)arg1)->getText(); result = (FXString *) &_result_ref; } 
    vresult = rb_str_new2(result->text()); return vresult; }
static VALUE _wrap_FXTableItem_getIcon(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXIcon *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXIcon *)((FXTableItem const *)arg1)->getIcon(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTableItem_setData(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ; VALUE arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = argv[0]; FXTableItem_setData(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTableItem_getData(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    VALUE result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (VALUE)FXTableItem_getData((FXTableItem const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXTableItem_hasFocus(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); result = (FXbool)((FXTableItem const *)arg1)->hasFocus();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTableItem_isSelected(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXbool)((FXTableItem const *)arg1)->isSelected(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTableItem_isEnabled(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXbool)((FXTableItem const *)arg1)->isEnabled(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTableItem_isDraggable(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXbool)((FXTableItem const *)arg1)->isDraggable(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTableItem_setJustify(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setJustify(arg2);
    return Qnil; }
static VALUE _wrap_FXTableItem_getJustify(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXuint)((FXTableItem const *)arg1)->getJustify(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTableItem_setIconPosition(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setIconPosition(arg2);
    return Qnil; }
static VALUE _wrap_FXTableItem_getIconPosition(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXuint)((FXTableItem const *)arg1)->getIconPosition(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTableItem_setBorders(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setBorders(arg2);
    return Qnil; }
static VALUE _wrap_FXTableItem_getBorders(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXuint)((FXTableItem const *)arg1)->getBorders(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTableItem_setStipple(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    int arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = (int) NUM2INT(argv[0]);
    (arg1)->setStipple((FXStipplePattern )arg2); return Qnil; }
static VALUE _wrap_FXTableItem_getStipple(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    int result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); result = (int)((FXTableItem const *)arg1)->getStipple();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTableItem_isIconOwned(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    result = (FXuint)((FXTableItem const *)arg1)->isIconOwned(); vresult = UINT2NUM(result); return vresult; }
static void
free_FXTableItem(FXTableItem *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTableItem_save(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTableItem_save((FXTableItem const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTableItem_load(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXStream *arg2 = 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTableItem_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTableItem_draw(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXTableItem_draw((FXTableItem const *)arg1,(FXTable const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXTableItem_drawBorders(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXTableItem_drawBorders((FXTableItem const *)arg1,(FXTable const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXTableItem_drawContent(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXTableItem_drawContent((FXTableItem const *)arg1,(FXTable const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXTableItem_drawPattern(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXTableItem_drawPattern((FXTableItem const *)arg1,(FXTable const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXTableItem_drawBackground(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXDC *arg3 = 0 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; FXint arg7 ;
    if ((argc < 6) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXDC, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]); arg7 = NUM2INT(argv[5]);
    FXTableItem_drawBackground((FXTableItem const *)arg1,(FXTable const *)arg2,*arg3,arg4,arg5,arg6,arg7); return Qnil; }
static VALUE _wrap_FXTableItem_setText(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXString *arg2 = 0 ; SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    FXTableItem_setText(arg1,(FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTableItem_setIcon(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXIcon *arg2 = (FXIcon *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXIcon, 1); FXTableItem_setIcon(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTableItem_setFocus(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = to_FXbool(argv[0]);
    FXTableItem_setFocus(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTableItem_setSelected(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = to_FXbool(argv[0]);
    FXTableItem_setSelected(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTableItem_setEnabled(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = to_FXbool(argv[0]);
    FXTableItem_setEnabled(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTableItem_setDraggable(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXbool arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); arg2 = to_FXbool(argv[0]);
    FXTableItem_setDraggable(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTableItem_setIconOwned(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXuint arg2 = (FXuint) 0x00000040 ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    FXTableItem_setIconOwned(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTableItem_getWidth(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    result = (FXint)FXTableItem_getWidth((FXTableItem const *)arg1,(FXTable const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTableItem_getHeight(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    FXTable *arg2 = (FXTable *) 0 ; FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXTable, 1);
    result = (FXint)FXTableItem_getHeight((FXTableItem const *)arg1,(FXTable const *)arg2); vresult = INT2NUM(result);
    return vresult; }
static VALUE _wrap_FXTableItem_create(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); FXTableItem_create(arg1); return Qnil; }
static VALUE _wrap_FXTableItem_detach(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); FXTableItem_detach(arg1); return Qnil; }
static VALUE _wrap_FXTableItem_destroy(int argc, VALUE *argv, VALUE self) { FXTableItem *arg1 = (FXTableItem *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTableItem, 1); FXTableItem_destroy(arg1); return Qnil; }
static VALUE FXTable_csvType_get(VALUE self) { VALUE _val; _val = UINT2NUM(FXTable::csvType);    return _val; }
static VALUE FXTable_csvType_set(VALUE self, VALUE _val) { FXTable::csvType = NUM2UINT(_val); return _val; }
static VALUE FXTable_csvTypeName_get(VALUE self) { VALUE _val; _val = rb_str_new2(FXTable::csvTypeName);    return _val; }
static VALUE _wrap_FXTable_onPaint(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onPaint(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onFocusIn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusIn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onFocusOut(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onFocusOut(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onMotion(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onMotion(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onKeyPress(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onKeyRelease(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onKeyRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onLeftBtnPress(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onLeftBtnRelease(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onLeftBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onRightBtnPress(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnPress(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onRightBtnRelease(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onRightBtnRelease(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onUngrabbed(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onUngrabbed(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onSelectionLost(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onSelectionGained(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onSelectionRequest(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onSelectionRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onClipboardLost(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardLost(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onClipboardGained(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardGained(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onClipboardRequest(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClipboardRequest(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onAutoScroll(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onAutoScroll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCommand(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCommand(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onClicked(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onDoubleClicked(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onDoubleClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onTripleClicked(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = to_FXEvent(argv[2]);
    result = (long)(arg1)->onTripleClicked(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdHorzGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdHorzGrid(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onUpdHorzGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdHorzGrid(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdVertGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdVertGrid(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onUpdVertGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdVertGrid(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdDeleteColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteColumn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onUpdDeleteColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDeleteColumn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdDeleteRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeleteRow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onUpdDeleteRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onUpdDeleteRow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdInsertColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdInsertColumn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdInsertRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdInsertRow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveRight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveRight(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveLeft(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveLeft(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveUp(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveDown(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveHome(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveHome(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveEnd(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveEnd(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveTop(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveTop(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMoveBottom(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMoveBottom(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMovePageDown(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMovePageDown(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMovePageUp(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMovePageUp(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdMark(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdMark(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdExtend(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdExtend(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdSelectCell(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectCell(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdSelectRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectRow(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdSelectColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectColumn(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdSelectRowIndex(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectRowIndex(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdSelectColumnIndex(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectColumnIndex(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdSelectAll(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdSelectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdDeselectAll(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]); arg4 = 0;
    result = (long)(arg1)->onCmdDeselectAll(arg2,arg3,arg4); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdCutSel(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdCutSel(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdCopySel(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdCopySel(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdDeleteSel(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdDeleteSel(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onCmdPasteSel(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onCmdPasteSel(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_onUpdHaveSelection(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 ; void *arg4 = (void *) 0 ; long result; VALUE vresult = Qnil;
    if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXObject, 1); arg3 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1); result = (long)(arg1)->onUpdHaveSelection(arg2,arg3,arg4);
    vresult = INT2NUM(result); return vresult; }
#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE _wrap_FXTable_allocate(VALUE self) {
#else
     static VALUE _wrap_FXTable_allocate(int argc, VALUE *argv, VALUE self) {
#endif
         VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_FXTable);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
         return vresult; }
static VALUE _wrap_new_FXTable(int argc, VALUE *argv, VALUE self) { FXComposite *arg1 = (FXComposite *) 0 ;
    FXObject *arg2 = (FXObject *) 0 ; FXSelector arg3 = (FXSelector) 0 ; FXuint arg4 = (FXuint) 0 ; FXint arg5 = (FXint) 0 ;
    FXint arg6 = (FXint) 0 ; FXint arg7 = (FXint) 0 ; FXint arg8 = (FXint) 0 ; FXint arg9 = (FXint) DEFAULT_MARGIN ;
    FXint arg10 = (FXint) DEFAULT_MARGIN ; FXint arg11 = (FXint) DEFAULT_MARGIN ; FXint arg12 = (FXint) DEFAULT_MARGIN ;
    FXTable *result; if ((argc < 1) || (argc > 12)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_FXComposite, 1); if (argc > 1) {
        SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_FXObject, 1); }  if (argc > 2) { arg3 = NUM2UINT(argv[2]); } 
    if (argc > 3) { arg4 = NUM2UINT(argv[3]); }  if (argc > 4) { arg5 = NUM2INT(argv[4]); }  if (argc > 5) {
        arg6 = NUM2INT(argv[5]); }  if (argc > 6) { arg7 = NUM2INT(argv[6]); }  if (argc > 7) { arg8 = NUM2INT(argv[7]); } 
    if (argc > 8) { arg9 = NUM2INT(argv[8]); }  if (argc > 9) { arg10 = NUM2INT(argv[9]); }  if (argc > 10) {
        arg11 = NUM2INT(argv[10]); }  if (argc > 11) { arg12 = NUM2INT(argv[11]); }  {
        result = (FXTable *)new_FXTable(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
        DATA_PTR(self) = result; FXRbRegisterRubyObj(self, result); if(rb_block_given_p()){ rb_yield(self); }  }  return self; }
static VALUE _wrap_FXTable_getColumnHeader(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXHeader *result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXHeader *)((FXTable const *)arg1)->getColumnHeader(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXHeader, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTable_getRowHeader(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXHeader *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXHeader *)((FXTable const *)arg1)->getRowHeader();
    { swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXHeader, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTable_setVisibleRows(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVisibleRows(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getVisibleRows(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getVisibleRows();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setVisibleColumns(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setVisibleColumns(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getVisibleColumns(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getVisibleColumns();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_showHorzGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->showHorzGrid(arg2); return Qnil; }
static VALUE _wrap_FXTable_isHorzGridShown(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXbool)((FXTable const *)arg1)->isHorzGridShown();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_showVertGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    (arg1)->showVertGrid(arg2); return Qnil; }
static VALUE _wrap_FXTable_isVertGridShown(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXbool)((FXTable const *)arg1)->isVertGridShown();
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_getNumRows(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getNumRows();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getNumColumns(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getNumColumns();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setMarginTop(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginTop(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getMarginTop(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getMarginTop();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setMarginBottom(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginBottom(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getMarginBottom(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getMarginBottom();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setMarginLeft(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginLeft(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getMarginLeft(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getMarginLeft();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setMarginRight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setMarginRight(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getMarginRight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getMarginRight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_rowAtY(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXTable const *)arg1)->rowAtY(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_colAtX(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)((FXTable const *)arg1)->colAtX(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXTableItem *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXTableItem *)((FXTable const *)arg1)->getItem(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTableItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTable_setItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXTableItem *arg4 = (FXTableItem *) 0 ; FXbool arg5 = (FXbool) 0 ; if ((argc < 3) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXTableItem, 1); if (argc > 3) { arg5 = to_FXbool(argv[3]); }  {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    FXTable_setItem(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTable_makePositionVisible(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    (arg1)->makePositionVisible(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_isItemVisible(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isItemVisible(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_setColumnHeaderMode(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_FIX_HEIGHT ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    (arg1)->setColumnHeaderMode(arg2); return Qnil; }
static VALUE _wrap_FXTable_getColumnHeaderMode(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXuint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXuint)((FXTable const *)arg1)->getColumnHeaderMode(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setRowHeaderMode(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXuint arg2 = (FXuint) LAYOUT_FIX_WIDTH ; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = NUM2UINT(argv[0]); } 
    (arg1)->setRowHeaderMode(arg2); return Qnil; }
static VALUE _wrap_FXTable_getRowHeaderMode(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXuint)((FXTable const *)arg1)->getRowHeaderMode();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setColumnHeaderHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXint arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setColumnHeaderHeight(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getColumnHeaderHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXint)((FXTable const *)arg1)->getColumnHeaderHeight(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setRowHeaderWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setRowHeaderWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getRowHeaderWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getRowHeaderWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getColumnWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXint)((FXTable const *)arg1)->getColumnWidth(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getRowHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  } 
    result = (FXint)((FXTable const *)arg1)->getRowHeight(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getColumnX(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTable_getColumnX((FXTable const *)arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getRowY(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTable_getRowY((FXTable const *)arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setDefColumnWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setDefColumnWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getDefColumnWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getDefColumnWidth();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setDefRowHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setDefRowHeight(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getDefRowHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getDefRowHeight();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getMinRowHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  } 
    result = (FXint)((FXTable const *)arg1)->getMinRowHeight(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getMinColumnWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXint)((FXTable const *)arg1)->getMinColumnWidth(arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setColumnText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; (arg1)->setColumnText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXTable_getColumnText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = ((FXTable const *)arg1)->getColumnText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTable_setRowText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXString *arg3 = 0 ; SwigValueWrapper<FXString > p3 ; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    p3 = to_FXString(argv[1]); arg3 = &p3; (arg1)->setRowText(arg2,(FXString const &)*arg3); return Qnil; }
static VALUE _wrap_FXTable_getRowText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXString result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = ((FXTable const *)arg1)->getRowText(arg2); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTable_setItemText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXString *arg4 = 0 ; SwigValueWrapper<FXString > p4 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    p4 = to_FXString(argv[2]); arg4 = &p4; { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    FXTable_setItemText(arg1,arg2,arg3,(FXString const &)*arg4); return Qnil; }
static VALUE _wrap_FXTable_getItemText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXString result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = ((FXTable const *)arg1)->getItemText(arg2,arg3); vresult = rb_str_new2((&result)->text()); return vresult; }
static VALUE _wrap_FXTable_setItemIcon(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXIcon *arg4 = (FXIcon *) 0 ; if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_FXIcon, 1); { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  FXTable_setItemIcon(arg1,arg2,arg3,arg4);
    return Qnil; }
static VALUE _wrap_FXTable_getItemIcon(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXIcon *result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXIcon *)((FXTable const *)arg1)->getItemIcon(arg2,arg3); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXIcon, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTable_setItemData(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; VALUE arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = argv[2]; { if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    FXTable_setItemData(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_getItemData(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; VALUE result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (VALUE)FXTable_getItemData((FXTable const *)arg1,arg2,arg3); vresult = result; return vresult; }
static VALUE _wrap_FXTable_extractText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXchar arg6 = (FXchar) '\t' ; FXchar arg7 = (FXchar) '\n' ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 4) || (argc > 6)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = NUM2CHR(argv[4]); }  if (argc > 5) {
        arg7 = NUM2CHR(argv[5]); }  result = (VALUE)FXTable_extractText((FXTable const *)arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    vresult = result; return vresult; }
static VALUE _wrap_FXTable_overlayText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; VALUE arg6 ; FXchar arg7 = (FXchar) '\t' ; FXchar arg8 = (FXchar) '\n' ;
    if ((argc < 5) || (argc > 7)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = argv[4]; if (argc > 5) { arg7 = NUM2CHR(argv[5]); } 
    if (argc > 6) { arg8 = NUM2CHR(argv[6]); }  FXTable_overlayText(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8); return Qnil; }
static VALUE _wrap_FXTable_isItemSpanning(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isItemSpanning(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_updateRange(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTable_updateRange((FXTable const *)arg1,arg2,arg3,arg4,arg5);
    return Qnil; }
static VALUE _wrap_FXTable_updateItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    ((FXTable const *)arg1)->updateItem(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_enableItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)(arg1)->enableItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_disableItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)(arg1)->disableItem(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_isItemEnabled(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isItemEnabled(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_setItemJustify(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXuint arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2UINT(argv[2]); { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  (arg1)->setItemJustify(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_getItemJustify(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXuint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXuint)((FXTable const *)arg1)->getItemJustify(arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setItemIconPosition(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXuint arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2UINT(argv[2]); { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  (arg1)->setItemIconPosition(arg2,arg3,arg4);
    return Qnil; }
static VALUE _wrap_FXTable_getItemIconPosition(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXuint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXuint)((FXTable const *)arg1)->getItemIconPosition(arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setItemBorders(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXuint arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2UINT(argv[2]); { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  (arg1)->setItemBorders(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_getItemBorders(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXuint result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXuint)((FXTable const *)arg1)->getItemBorders(arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setItemStipple(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; int arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = (int) NUM2INT(argv[2]); { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    (arg1)->setItemStipple(arg2,arg3,(FXStipplePattern )arg4); return Qnil; }
static VALUE _wrap_FXTable_getItemStipple(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; int result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (int)((FXTable const *)arg1)->getItemStipple(arg2,arg3); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getCurrentRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getCurrentRow();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getCurrentColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getCurrentColumn();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_isItemCurrent(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isItemCurrent(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_setAnchorItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    (arg1)->setAnchorItem(arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_getAnchorRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getAnchorRow();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getAnchorColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getAnchorColumn();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getSelStartRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getSelStartRow();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getSelStartColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getSelStartColumn();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getSelEndRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getSelEndRow();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getSelEndColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)((FXTable const *)arg1)->getSelEndColumn();
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_isItemSelected(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 < 0 || arg3 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isItemSelected(arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_isRowSelected(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isRowSelected(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_isColumnSelected(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); {
        if (arg2 < 0 || arg2 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)((FXTable const *)arg1)->isColumnSelected(arg2); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_isAnythingSelected(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXbool)((FXTable const *)arg1)->isAnythingSelected(); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_setFont(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXFont *arg2 = (FXFont *) 0 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXFont, 1); (arg1)->setFont(arg2); return Qnil; }
static VALUE _wrap_FXTable_getFont(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXFont *result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXFont *)((FXTable const *)arg1)->getFont(); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXFont, (void **) &result); vresult = FXRbGetRubyObj(result, ty); }
     return vresult; }
static VALUE _wrap_FXTable_getTextColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getBaseColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getBaseColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getHiliteColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getHiliteColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getShadowColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getShadowColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getBorderColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getBorderColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getSelBackColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getSelBackColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getSelTextColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getSelTextColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getGridColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getGridColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getStippleColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXColor)((FXTable const *)arg1)->getStippleColor();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getCellBorderColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXColor result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXColor)((FXTable const *)arg1)->getCellBorderColor(); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setTextColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setBaseColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBaseColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setHiliteColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setHiliteColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setShadowColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setShadowColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setBorderColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setSelBackColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelBackColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setSelTextColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setSelTextColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setGridColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setGridColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setStippleColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setStippleColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setCellBorderColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXColor arg2 ; if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); (arg1)->setCellBorderColor(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setCellColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXColor arg4 ; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = to_FXColor(argv[2]); { if (arg2 != 0 && arg2 != 1) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  {
        if (arg3 != 0 && arg3 != 1) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    (arg1)->setCellColor(arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_getCellColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXColor result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 != 0 && arg2 != 1) { rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 != 0 && arg3 != 1) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXColor)((FXTable const *)arg1)->getCellColor(arg2,arg3); vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setCellBorderWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); (arg1)->setCellBorderWidth(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getCellBorderWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXint)((FXTable const *)arg1)->getCellBorderWidth(); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getTableStyle(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXuint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXuint)((FXTable const *)arg1)->getTableStyle();
    vresult = UINT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_setTableStyle(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXuint arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2UINT(argv[0]); (arg1)->setTableStyle(arg2);
    return Qnil; }
static VALUE _wrap_FXTable_setHelpText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXString *arg2 = 0 ;
    SwigValueWrapper<FXString > p2 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    (arg1)->setHelpText((FXString const &)*arg2); return Qnil; }
static VALUE _wrap_FXTable_getHelpText(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXString result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = ((FXTable const *)arg1)->getHelpText();
    vresult = rb_str_new2((&result)->text()); return vresult; }
static void
free_FXTable(FXTable *arg1) {
    delete arg1;
}
static VALUE _wrap_FXTable_save(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTable_save((FXTable const *)arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTable_load(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXStream *arg2 = 0 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXStream, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    FXTable_load(arg1,*arg2); return Qnil; }
static VALUE _wrap_FXTable_create(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_create(arg1); return Qnil; }
static VALUE _wrap_FXTable_detach(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_detach(arg1); return Qnil; }
static VALUE _wrap_FXTable_destroy(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_destroy(arg1); return Qnil; }
static VALUE _wrap_FXTable_resize(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTable_resize(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_getDefaultWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)FXTable_getDefaultWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getDefaultHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)FXTable_getDefaultHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getWidthForHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTable_getWidthForHeight(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getHeightForWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]);
    result = (FXint)FXTable_getHeightForWidth(arg1,arg2); vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_canFocus(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXbool)FXTable_canFocus((FXTable const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_setFocus(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_setFocus(arg1); return Qnil; }
static VALUE _wrap_FXTable_killFocus(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_killFocus(arg1); return Qnil; }
static VALUE _wrap_FXTable_setDefault(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXbool arg2 = (FXbool) 1 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTable_setDefault(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTable_enable(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_enable(arg1); return Qnil; }
static VALUE _wrap_FXTable_disable(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_disable(arg1); return Qnil; }
static VALUE _wrap_FXTable_raiseWindow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_raise(arg1); return Qnil; }
static VALUE _wrap_FXTable_lower(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_lower(arg1); return Qnil; }
static VALUE _wrap_FXTable_move(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ; FXint arg3 ;
    if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTable_move(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_position__SWIG_0(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); FXTable_position(arg1,arg2,arg3,arg4,arg5); return Qnil; }
static VALUE _wrap_FXTable_layout(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_layout(arg1); return Qnil; }
static VALUE _wrap_FXTable_recalc(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_recalc(arg1); return Qnil; }
static VALUE _wrap_FXTable_reparent(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXComposite *arg2 = (FXComposite *) 0 ; if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXComposite, 1); FXTable_reparent(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTable_show(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_show(arg1); return Qnil; }
static VALUE _wrap_FXTable_hide(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); FXTable_hide(arg1); return Qnil; }
static VALUE _wrap_FXTable_isComposite(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXbool)FXTable_isComposite((FXTable const *)arg1);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_contains(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    result = (FXbool)FXTable_contains((FXTable const *)arg1,arg2,arg3); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_doesSaveUnder(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXbool result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (FXbool)FXTable_doesSaveUnder((FXTable const *)arg1); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_setBackColor(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXColor arg2 ;
    if ((argc < 1) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = to_FXColor(argv[0]); FXTable_setBackColor(arg1,arg2);
    return Qnil; }
static VALUE _wrap_FXTable_getViewportHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)FXTable_getViewportHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getViewportWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)FXTable_getViewportWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getContentHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)FXTable_getContentHeight(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_getContentWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); result = (FXint)FXTable_getContentWidth(arg1);
    vresult = INT2NUM(result); return vresult; }
static VALUE _wrap_FXTable_position__SWIG_1(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; VALUE result;
    VALUE vresult = Qnil; if ((argc < 0) || (argc > 0)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    result = (VALUE)FXTable_position__SWIG_1((FXTable const *)arg1); vresult = result; return vresult; }
static VALUE _wrap_FXTable_position(int nargs, VALUE *args, VALUE self) { int argc; VALUE argv[6]; int ii; argc = nargs + 1;
    argv[0] = self; for (ii = 1; (ii < argc) && (ii < 5); ii++) { argv[ii] = args[ii-1]; }  if (argc == 1) { int _v; {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTable, 0) != -1)) ? 1 : 0; }
         if (_v) { return _wrap_FXTable_position__SWIG_1(nargs, args, self);}  }  if (argc == 5) { int _v; { void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_FXTable, 0) != -1)) ? 1 : 0; }
         if (_v) { { _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0; }  if (_v) { {
                            _v = ((TYPE(argv[4]) == T_FIXNUM) || (TYPE(argv[4]) == T_BIGNUM)) ? 1 : 0; }  if (_v) {
                            return _wrap_FXTable_position__SWIG_0(nargs, args, self);}  }  }  }  }  } 
    rb_raise(rb_eArgError, "No matching function for overloaded 'FXTable_position'"); return Qnil; }
static VALUE _wrap_FXTable_drawCell(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXDC *arg2 = 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDC, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    FXTable_drawCell(arg1,*arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXTable_drawRange(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXDC *arg2 = 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDC, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    FXTable_drawRange(arg1,*arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXTable_drawHGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXDC *arg2 = 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDC, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    FXTable_drawHGrid(arg1,*arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXTable_drawVGrid(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXDC *arg2 = 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDC, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    FXTable_drawVGrid(arg1,*arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXTable_drawContents(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXDC *arg2 = 0 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXint arg6 ; if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_FXDC, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    arg3 = NUM2INT(argv[1]); arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); arg6 = NUM2INT(argv[4]);
    FXTable_drawContents(arg1,*arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXTable_createItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXString *arg2 = 0 ;
    FXIcon *arg3 = (FXIcon *) 0 ; void *arg4 = (void *) 0 ; FXTableItem *result; SwigValueWrapper<FXString > p2 ;
    VALUE vresult = Qnil; if ((argc < 3) || (argc > 3)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); p2 = to_FXString(argv[0]); arg2 = &p2;
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_FXIcon, 1); SWIG_ConvertPtr(argv[2], (void **) &arg4, 0, 1);
    result = (FXTableItem *)FXTable_createItem(arg1,(FXString const &)*arg2,arg3,arg4); {
        swig_type_info *ty = SWIG_TypeDynamicCast(SWIGTYPE_p_FXTableItem, (void **) &result);
        vresult = FXRbGetRubyObj(result, ty); }  return vresult; }
static VALUE _wrap_FXTable_setTableSize(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = to_FXbool(argv[2]); }  FXTable_setTableSize(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_insertRows(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = to_FXbool(argv[2]); }  { if (arg2 < 0 || arg2 > arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  FXTable_insertRows(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_insertColumns(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 > arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    FXTable_insertColumns(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_removeRows(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 + arg3 > arg1->getNumRows()) { rb_raise(rb_eIndexError,"table row out of bounds"); }  } 
    FXTable_removeRows(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_removeColumns(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 = (FXint) 1 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 1) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = NUM2INT(argv[1]); }  if (argc > 2) { arg4 = to_FXbool(argv[2]); }  {
        if (arg2 < 0 || arg2 + arg3 > arg1->getNumColumns()) { rb_raise(rb_eIndexError,"table column out of bounds"); }  } 
    FXTable_removeColumns(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_removeItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = to_FXbool(argv[2]); }  { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  FXTable_removeItem(arg1,arg2,arg3,arg4); return Qnil; }
static VALUE _wrap_FXTable_removeRange(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool arg6 = (FXbool) 0 ; if ((argc < 4) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    FXTable_removeRange(arg1,arg2,arg3,arg4,arg5,arg6); return Qnil; }
static VALUE _wrap_FXTable_clearItems(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXbool arg2 = (FXbool) 0 ; if ((argc < 0) || (argc > 1)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    FXTable_clearItems(arg1,arg2); return Qnil; }
static VALUE _wrap_FXTable_setColumnWidth(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumColumns()) { rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    FXTable_setColumnWidth(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_setRowHeight(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]); {
        if (arg2 < 0 || arg2 >= arg1->getNumRows()) { rb_raise(rb_eIndexError, "table row out of bounds"); }  } 
    FXTable_setRowHeight(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_setColumnX(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTable_setColumnX(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_setRowY(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; if ((argc < 2) || (argc > 2)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    FXTable_setRowY(arg1,arg2,arg3); return Qnil; }
static VALUE _wrap_FXTable_setCurrentItem(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = to_FXbool(argv[2]); }  { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  FXTable_setCurrentItem(arg1,arg2,arg3,arg4);
    return Qnil; }
static VALUE _wrap_FXTable_selectRow(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  result = (FXbool)FXTable_selectRow(arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_selectColumn(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXbool arg3 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 1) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); if (argc > 1) {
        arg3 = to_FXbool(argv[1]); }  { if (arg2 < 0 || arg2 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  }  result = (FXbool)FXTable_selectColumn(arg1,arg2,arg3);
    vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_selectRange(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXint arg4 ; FXint arg5 ; FXbool arg6 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil;
    if ((argc < 4) || (argc > 5)) rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]); arg5 = NUM2INT(argv[3]); if (argc > 4) { arg6 = to_FXbool(argv[4]); } 
    result = (FXbool)FXTable_selectRange(arg1,arg2,arg3,arg4,arg5,arg6); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_extendSelection(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ; FXint arg2 ;
    FXint arg3 ; FXbool arg4 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 2) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); arg2 = NUM2INT(argv[0]); arg3 = NUM2INT(argv[1]);
    if (argc > 2) { arg4 = to_FXbool(argv[2]); }  { if (arg2 < 0 || arg2 >= arg1->getNumRows()) {
            rb_raise(rb_eIndexError, "table row out of bounds"); }  }  { if (arg3 < 0 || arg3 >= arg1->getNumColumns()) {
            rb_raise(rb_eIndexError, "table column out of bounds"); }  } 
    result = (FXbool)FXTable_extendSelection(arg1,arg2,arg3,arg4); vresult = result ? Qtrue : Qfalse; return vresult; }
static VALUE _wrap_FXTable_killSelection(int argc, VALUE *argv, VALUE self) { FXTable *arg1 = (FXTable *) 0 ;
    FXbool arg2 = (FXbool) 0 ; FXbool result; VALUE vresult = Qnil; if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_FXTable, 1); if (argc > 0) { arg2 = to_FXbool(argv[0]); } 
    result = (FXbool)FXTable_killSelection(arg1,arg2); vresult = result ? Qtrue : Qfalse; return vresult; }

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_FXDriveBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXVerticalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXFontTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXFont *) x));
}
static void *_p_FXDirBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXTableTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXTable *) x));
}
static void *_p_FXSwitcherTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXDrawableTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXDrawable *) x));
}
static void *_p_FXCursorTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXProgressBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXVisualTo_p_FXId(void *x) {
    return (void *)((FXId *)  ((FXVisual *) x));
}
static void *_p_FXColorBarTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXId(void *x) {
    return (void *)((FXId *) (FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDocumentTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDocument *) x));
}
static void *_p_FXRegistryTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *)(FXSettings *) ((FXRegistry *) x));
}
static void *_p_FXHeaderItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXHeaderItem *) x));
}
static void *_p_FXShutterItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXColorBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXTableItemTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXTableItem *) x));
}
static void *_p_FXTabBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXSwitcherTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXTextFieldTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXToolBarTabTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXDriveBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXIconDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXIconDict *) x));
}
static void *_p_FXMatrixTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXFileDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXFileDict *) x));
}
static void *_p_FXRecentFilesTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXRecentFiles *) x));
}
static void *_p_FXScrollCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXArrowButtonTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXPopupTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXDrawableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXDrawable *) x));
}
static void *_p_FXAppTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXApp *) x));
}
static void *_p_FXHeaderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FX4SplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXSpringTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXPackerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXTabBookTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXImageFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXIdTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXId *) x));
}
static void *_p_FXProgressBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXShutterTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXTable *) x));
}
static void *_p_FXToolTipTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXCompositeTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXComposite *) x));
}
static void *_p_FXBitmapFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXRealSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSliderTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXSettingsTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXSettings *) x));
}
static void *_p_FXGroupBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXDebugTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDebugTarget *) x));
}
static void *_p_FXDataTargetTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDataTarget *) x));
}
static void *_p_FXTreeListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXCanvasTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXColorWheelTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXVisualTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXVisual *) x));
}
static void *_p_FXScrollBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXToolBarGripTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXFontTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXFont *) x));
}
static void *_p_FXComboBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXFrame *) x));
}
static void *_p_FXStringDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXDict *) ((FXStringDict *) x));
}
static void *_p_FXStatusBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXDelegatorTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDelegator *) x));
}
static void *_p_FXAccelTableTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXAccelTable *) x));
}
static void *_p_FXCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *) ((FXCursor *) x));
}
static void *_p_FXCURCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXCURCursor *) x));
}
static void *_p_FXGIFCursorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXCursor *) ((FXGIFCursor *) x));
}
static void *_p_FXRealSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXStatusLineTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXScrollWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *) ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXDictTo_p_FXObject(void *x) {
    return (void *)((FXObject *)  ((FXDict *) x));
}
static void *_p_FXShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXScrollAreaTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXColorWellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXDragCornerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXRulerTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXDialTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FXImageViewTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXDirSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXToolBarTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDirBoxTo_p_FXObject(void *x) {
    return (void *)((FXObject *) (FXId *)(FXDrawable *)(FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXScrollWindowTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXScrollWindow *) x));
}
static void *_p_FXImageViewTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXImageView *) x));
}
static void *_p_FXTableTo_p_FXScrollArea(void *x) {
    return (void *)((FXScrollArea *)  ((FXTable *) x));
}
static void *_p_FXDriveBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollCorner *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXDragCorner *) x));
}
static void *_p_FXTableTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXTable *) x));
}
static void *_p_FXSwitcherTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *)  ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXWindow(void *x) {
    return (void *)((FXWindow *) (FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDriveBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXToolTipTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTabBookTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXGroupBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXComboBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXSplitter *) x));
}
static void *_p_FXRealSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXSpinnerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXPackerTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *)  ((FXPacker *) x));
}
static void *_p_FXDirBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXTableTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXTable *) x));
}
static void *_p_FXSwitcherTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXColorSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXDirSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXTreeListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXListBoxTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXListBox *) x));
}
static void *_p_FXMatrixTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXShutterItemTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXTabBarTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSpringTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXPacker *) ((FXSpring *) x));
}
static void *_p_FXToolBarShellTo_p_FXComposite(void *x) {
    return (void *)((FXComposite *) (FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXFileStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXFileStream *) x));
}
static void *_p_FXMemoryStreamTo_p_FXStream(void *x) {
    return (void *)((FXStream *)  ((FXMemoryStream *) x));
}
static void *_p_FXDriveBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXListBox *) ((FXDriveBox *) x));
}
static void *_p_FXToolBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXToolBar *) x));
}
static void *_p_FXCompositeTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXComposite *) x));
}
static void *_p_FXToolTipTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXToolTip *) x));
}
static void *_p_FXTextFieldTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXTextField *) x));
}
static void *_p_FXTabBookTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTabBar *) ((FXTabBook *) x));
}
static void *_p_FXArrowButtonTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXArrowButton *) x));
}
static void *_p_FXGroupBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXGroupBox *) x));
}
static void *_p_FXShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXShell *) x));
}
static void *_p_FXStatusBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXHorizontalFrame *) ((FXStatusBar *) x));
}
static void *_p_FXScrollAreaTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXScrollArea *) x));
}
static void *_p_FXPopupTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXPopup *) x));
}
static void *_p_FXScrollWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXScrollWindow *) x));
}
static void *_p_FXWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *)  ((FXWindow *) x));
}
static void *_p_FXRootWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXRootWindow *) x));
}
static void *_p_FXTopWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *) ((FXTopWindow *) x));
}
static void *_p_FXMainWindowTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXMainWindow *) x));
}
static void *_p_FXRulerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRuler *) x));
}
static void *_p_FXCanvasTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXCanvas *) x));
}
static void *_p_FXScrollCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollCorner *) x));
}
static void *_p_FXHorizontalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXHorizontalSeparator *) x));
}
static void *_p_FXSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSeparator *) x));
}
static void *_p_FXVerticalSeparatorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *)(FXSeparator *) ((FXVerticalSeparator *) x));
}
static void *_p_FXStatusLineTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXStatusLine *) x));
}
static void *_p_FXComboBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXComboBox *) x));
}
static void *_p_FXHorizontalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXHorizontalFrame *) x));
}
static void *_p_FXVerticalFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXVerticalFrame *) x));
}
static void *_p_FX4SplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FX4Splitter *) x));
}
static void *_p_FXSplitterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXSplitter *) x));
}
static void *_p_FXPackerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *) ((FXPacker *) x));
}
static void *_p_FXSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpinner *) x));
}
static void *_p_FXRealSpinnerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXRealSpinner *) x));
}
static void *_p_FXScrollBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXScrollBar *) x));
}
static void *_p_FXColorWheelTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWheel *) x));
}
static void *_p_FXBitmapFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXBitmapFrame *) x));
}
static void *_p_FXDirBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXTreeListBox *) ((FXDirBox *) x));
}
static void *_p_FXToolBarGripTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXToolBarGrip *) x));
}
static void *_p_FXImageFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXImageFrame *) x));
}
static void *_p_FXDragCornerTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXDragCorner *) x));
}
static void *_p_FXTableTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXTable *) x));
}
static void *_p_FXSwitcherTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSwitcher *) x));
}
static void *_p_FXDirSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXDirSelector *) x));
}
static void *_p_FXFileSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFileSelector *) x));
}
static void *_p_FXColorSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXColorSelector *) x));
}
static void *_p_FXFontSelectorTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXFontSelector *) x));
}
static void *_p_FXShutterTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutter *) x));
}
static void *_p_FXProgressBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXProgressBar *) x));
}
static void *_p_FXListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXListBox *) x));
}
static void *_p_FXTreeListBoxTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTreeListBox *) x));
}
static void *_p_FXHeaderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXHeader *) x));
}
static void *_p_FXMatrixTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXMatrix *) x));
}
static void *_p_FXColorWellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorWell *) x));
}
static void *_p_FXShutterItemTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *)(FXVerticalFrame *) ((FXShutterItem *) x));
}
static void *_p_FXDialTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXDial *) x));
}
static void *_p_FXToolBarTabTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXToolBarTab *) x));
}
static void *_p_FXFrameTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *) ((FXFrame *) x));
}
static void *_p_FXTabBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXTabBar *) x));
}
static void *_p_FXImageViewTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXScrollArea *) ((FXImageView *) x));
}
static void *_p_FXSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXSlider *) x));
}
static void *_p_FXRealSliderTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXRealSlider *) x));
}
static void *_p_FXSpringTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXPacker *) ((FXSpring *) x));
}
static void *_p_FXColorBarTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXFrame *) ((FXColorBar *) x));
}
static void *_p_FXToolBarShellTo_p_FXDrawable(void *x) {
    return (void *)((FXDrawable *) (FXWindow *)(FXComposite *)(FXShell *)(FXTopWindow *) ((FXToolBarShell *) x));
}
static void *_p_FXDCPrintTo_p_FXDC(void *x) {
    return (void *)((FXDC *)  ((FXDCPrint *) x));
}
static void *_p_FXDCWindowTo_p_FXDC(void *x) {
    return (void *)((FXDC *)  ((FXDCWindow *) x));
}
static swig_type_info _swigt__p_FXDC[] = {{"_p_FXDC", 0, "FXDC *", 0, 0, 0, 0},{"_p_FXDCPrint", _p_FXDCPrintTo_p_FXDC, 0, 0, 0, 0, 0},{"_p_FXDC", 0, 0, 0, 0, 0, 0},{"_p_FXDCWindow", _p_FXDCWindowTo_p_FXDC, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXObject[] = {{"_p_FXObject", 0, "FXObject *", 0, 0, 0, 0},{"_p_FXDocument", _p_FXDocumentTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRegistry", _p_FXRegistryTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeaderItem", _p_FXHeaderItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTableItem", _p_FXTableItemTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXIconDict", _p_FXIconDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileDict", _p_FXFileDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRecentFiles", _p_FXRecentFilesTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXApp", _p_FXAppTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTable", _p_FXTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDict", _p_FXDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSettings", _p_FXSettingsTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDataTarget", _p_FXDataTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDebugTarget", _p_FXDebugTargetTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXId", _p_FXIdTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStringDict", _p_FXStringDictTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDelegator", _p_FXDelegatorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXAccelTable", _p_FXAccelTableTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXObject", 0, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXObject, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXObject, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXScrollArea[] = {{"_p_FXScrollArea", 0, "FXScrollArea *", 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXScrollArea", 0, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXScrollArea, 0, 0, 0, 0, 0},{"_p_FXTable", _p_FXTableTo_p_FXScrollArea, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXWindow[] = {{"_p_FXWindow", 0, "FXWindow *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXWindow", 0, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTable", _p_FXTableTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXWindow, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXWindow, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXComposite[] = {{"_p_FXComposite", 0, "FXComposite *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComposite", 0, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTable", _p_FXTableTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXComposite, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXComposite, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXId[] = {{"_p_FXId", 0, "FXId *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXId", 0, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTable", _p_FXTableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXDrawable", _p_FXDrawableTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCursor", _p_FXCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXCURCursor", _p_FXCURCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXGIFCursor", _p_FXGIFCursorTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXFont", _p_FXFontTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXVisual", _p_FXVisualTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXId, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXId, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXFont[] = {{"_p_FXFont", 0, "FXFont *", 0, 0, 0, 0},{"_p_FXFont", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTable[] = {{"_p_FXTable", 0, "FXTable *", 0, 0, 0, 0},{"_p_FXTable", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXStream[] = {{"_p_FXStream", 0, "FXStream *", 0, 0, 0, 0},{"_p_FXFileStream", _p_FXFileStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXMemoryStream", _p_FXMemoryStreamTo_p_FXStream, 0, 0, 0, 0, 0},{"_p_FXStream", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXDrawable[] = {{"_p_FXDrawable", 0, "FXDrawable *", 0, 0, 0, 0},{"_p_FXDriveBox", _p_FXDriveBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDial", _p_FXDialTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBar", _p_FXToolBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComposite", _p_FXCompositeTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolTip", _p_FXToolTipTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBook", _p_FXTabBookTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTextField", _p_FXTextFieldTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXArrowButton", _p_FXArrowButtonTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXGroupBox", _p_FXGroupBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShell", _p_FXShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusBar", _p_FXStatusBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollArea", _p_FXScrollAreaTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPopup", _p_FXPopupTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMainWindow", _p_FXMainWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTopWindow", _p_FXTopWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRootWindow", _p_FXRootWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollWindow", _p_FXScrollWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollCorner", _p_FXScrollCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXWindow", _p_FXWindowTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRuler", _p_FXRulerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXCanvas", _p_FXCanvasTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXComboBox", _p_FXComboBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSeparator", _p_FXSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalSeparator", _p_FXHorizontalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalSeparator", _p_FXVerticalSeparatorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXStatusLine", _p_FXStatusLineTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHorizontalFrame", _p_FXHorizontalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXVerticalFrame", _p_FXVerticalFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FX4Splitter", _p_FX4SplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSplitter", _p_FXSplitterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSpinner", _p_FXRealSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpinner", _p_FXSpinnerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXPacker", _p_FXPackerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXScrollBar", _p_FXScrollBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWheel", _p_FXColorWheelTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXBitmapFrame", _p_FXBitmapFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirBox", _p_FXDirBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarGrip", _p_FXToolBarGripTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTable", _p_FXTableTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageFrame", _p_FXImageFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDragCorner", _p_FXDragCornerTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSwitcher", _p_FXSwitcherTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorSelector", _p_FXColorSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFileSelector", _p_FXFileSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDirSelector", _p_FXDirSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFontSelector", _p_FXFontSelectorTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutter", _p_FXShutterTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXDrawable", 0, 0, 0, 0, 0, 0},{"_p_FXProgressBar", _p_FXProgressBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXListBox", _p_FXListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTreeListBox", _p_FXTreeListBoxTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXHeader", _p_FXHeaderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXMatrix", _p_FXMatrixTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXShutterItem", _p_FXShutterItemTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorWell", _p_FXColorWellTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarTab", _p_FXToolBarTabTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXTabBar", _p_FXTabBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXFrame", _p_FXFrameTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXImageView", _p_FXImageViewTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSlider", _p_FXSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXRealSlider", _p_FXRealSliderTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXSpring", _p_FXSpringTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXColorBar", _p_FXColorBarTo_p_FXDrawable, 0, 0, 0, 0, 0},{"_p_FXToolBarShell", _p_FXToolBarShellTo_p_FXDrawable, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTableRange[] = {{"_p_FXTableRange", 0, "FXTableRange *", 0, 0, 0, 0},{"_p_FXTableRange", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXIcon[] = {{"_p_FXIcon", 0, "FXIcon *", 0, 0, 0, 0},{"_p_FXIcon", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXHeader[] = {{"_p_FXHeader", 0, "FXHeader *", 0, 0, 0, 0},{"_p_FXHeader", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTableItem[] = {{"_p_FXTableItem", 0, "FXTableItem *", 0, 0, 0, 0},{"_p_FXTableItem", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};
static swig_type_info _swigt__p_FXTablePos[] = {{"_p_FXTablePos", 0, "FXTablePos *", 0, 0, 0, 0},{"_p_FXTablePos", 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_FXDC, 
_swigt__p_FXObject, 
_swigt__p_FXScrollArea, 
_swigt__p_FXWindow, 
_swigt__p_FXComposite, 
_swigt__p_FXId, 
_swigt__p_FXFont, 
_swigt__p_FXTable, 
_swigt__p_FXStream, 
_swigt__p_FXDrawable, 
_swigt__p_FXTableRange, 
_swigt__p_FXIcon, 
_swigt__p_FXHeader, 
_swigt__p_FXTableItem, 
_swigt__p_FXTablePos, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_table(void) {
    int i;
    
    SWIG_InitRuntime();
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_const(mFox,"DEFAULT_MARGIN", INT2NUM(DEFAULT_MARGIN));
    rb_define_const(mFox,"TABLE_COL_SIZABLE", INT2NUM(TABLE_COL_SIZABLE));
    rb_define_const(mFox,"TABLE_ROW_SIZABLE", INT2NUM(TABLE_ROW_SIZABLE));
    rb_define_const(mFox,"TABLE_HEADERS_SIZABLE", INT2NUM(TABLE_HEADERS_SIZABLE));
    rb_define_const(mFox,"TABLE_NO_COLSELECT", INT2NUM(TABLE_NO_COLSELECT));
    rb_define_const(mFox,"TABLE_NO_ROWSELECT", INT2NUM(TABLE_NO_ROWSELECT));
    
    cFXTablePos.klass = rb_define_class_under(mFox, "FXTablePos", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXTablePos, (void *) &cFXTablePos);
    rb_define_alloc_func(cFXTablePos.klass, _wrap_FXTablePos_allocate);
    rb_define_method(cFXTablePos.klass, "initialize", VALUEFUNC(_wrap_new_FXTablePos), -1);
    rb_define_method(cFXTablePos.klass, "row=", VALUEFUNC(_wrap_FXTablePos_row_set), -1);
    rb_define_method(cFXTablePos.klass, "row", VALUEFUNC(_wrap_FXTablePos_row_get), -1);
    rb_define_method(cFXTablePos.klass, "col=", VALUEFUNC(_wrap_FXTablePos_col_set), -1);
    rb_define_method(cFXTablePos.klass, "col", VALUEFUNC(_wrap_FXTablePos_col_get), -1);
    cFXTablePos.mark = 0;
    cFXTablePos.destroy = (void (*)(void *)) free_FXTablePos;
    
    cFXTableRange.klass = rb_define_class_under(mFox, "FXTableRange", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_FXTableRange, (void *) &cFXTableRange);
    rb_define_alloc_func(cFXTableRange.klass, _wrap_FXTableRange_allocate);
    rb_define_method(cFXTableRange.klass, "initialize", VALUEFUNC(_wrap_new_FXTableRange), -1);
    rb_define_method(cFXTableRange.klass, "fm=", VALUEFUNC(_wrap_FXTableRange_fm_set), -1);
    rb_define_method(cFXTableRange.klass, "fm", VALUEFUNC(_wrap_FXTableRange_fm_get), -1);
    rb_define_method(cFXTableRange.klass, "to=", VALUEFUNC(_wrap_FXTableRange_to_set), -1);
    rb_define_method(cFXTableRange.klass, "to", VALUEFUNC(_wrap_FXTableRange_to_get), -1);
    cFXTableRange.mark = 0;
    cFXTableRange.destroy = (void (*)(void *)) free_FXTableRange;
    
    cFXTableItem.klass = rb_define_class_under(mFox, "FXTableItem", ((swig_class *) SWIGTYPE_p_FXObject->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTableItem, (void *) &cFXTableItem);
    rb_define_alloc_func(cFXTableItem.klass, _wrap_FXTableItem_allocate);
    rb_define_method(cFXTableItem.klass, "initialize", VALUEFUNC(_wrap_new_FXTableItem), -1);
    rb_define_const(cFXTableItem.klass,"RIGHT", INT2NUM(FXTableItem::RIGHT));
    rb_define_const(cFXTableItem.klass,"LEFT", INT2NUM(FXTableItem::LEFT));
    rb_define_const(cFXTableItem.klass,"CENTER_X", INT2NUM(FXTableItem::CENTER_X));
    rb_define_const(cFXTableItem.klass,"TOP", INT2NUM(FXTableItem::TOP));
    rb_define_const(cFXTableItem.klass,"BOTTOM", INT2NUM(FXTableItem::BOTTOM));
    rb_define_const(cFXTableItem.klass,"CENTER_Y", INT2NUM(FXTableItem::CENTER_Y));
    rb_define_const(cFXTableItem.klass,"BEFORE", INT2NUM(FXTableItem::BEFORE));
    rb_define_const(cFXTableItem.klass,"AFTER", INT2NUM(FXTableItem::AFTER));
    rb_define_const(cFXTableItem.klass,"ABOVE", INT2NUM(FXTableItem::ABOVE));
    rb_define_const(cFXTableItem.klass,"BELOW", INT2NUM(FXTableItem::BELOW));
    rb_define_const(cFXTableItem.klass,"LBORDER", INT2NUM(FXTableItem::LBORDER));
    rb_define_const(cFXTableItem.klass,"RBORDER", INT2NUM(FXTableItem::RBORDER));
    rb_define_const(cFXTableItem.klass,"TBORDER", INT2NUM(FXTableItem::TBORDER));
    rb_define_const(cFXTableItem.klass,"BBORDER", INT2NUM(FXTableItem::BBORDER));
    rb_define_method(cFXTableItem.klass, "getText", VALUEFUNC(_wrap_FXTableItem_getText), -1);
    rb_define_method(cFXTableItem.klass, "getIcon", VALUEFUNC(_wrap_FXTableItem_getIcon), -1);
    rb_define_method(cFXTableItem.klass, "setData", VALUEFUNC(_wrap_FXTableItem_setData), -1);
    rb_define_method(cFXTableItem.klass, "getData", VALUEFUNC(_wrap_FXTableItem_getData), -1);
    rb_define_method(cFXTableItem.klass, "hasFocus", VALUEFUNC(_wrap_FXTableItem_hasFocus), -1);
    rb_define_method(cFXTableItem.klass, "isSelected", VALUEFUNC(_wrap_FXTableItem_isSelected), -1);
    rb_define_method(cFXTableItem.klass, "isEnabled", VALUEFUNC(_wrap_FXTableItem_isEnabled), -1);
    rb_define_method(cFXTableItem.klass, "isDraggable", VALUEFUNC(_wrap_FXTableItem_isDraggable), -1);
    rb_define_method(cFXTableItem.klass, "setJustify", VALUEFUNC(_wrap_FXTableItem_setJustify), -1);
    rb_define_method(cFXTableItem.klass, "getJustify", VALUEFUNC(_wrap_FXTableItem_getJustify), -1);
    rb_define_method(cFXTableItem.klass, "setIconPosition", VALUEFUNC(_wrap_FXTableItem_setIconPosition), -1);
    rb_define_method(cFXTableItem.klass, "getIconPosition", VALUEFUNC(_wrap_FXTableItem_getIconPosition), -1);
    rb_define_method(cFXTableItem.klass, "setBorders", VALUEFUNC(_wrap_FXTableItem_setBorders), -1);
    rb_define_method(cFXTableItem.klass, "getBorders", VALUEFUNC(_wrap_FXTableItem_getBorders), -1);
    rb_define_method(cFXTableItem.klass, "setStipple", VALUEFUNC(_wrap_FXTableItem_setStipple), -1);
    rb_define_method(cFXTableItem.klass, "getStipple", VALUEFUNC(_wrap_FXTableItem_getStipple), -1);
    rb_define_method(cFXTableItem.klass, "isIconOwned", VALUEFUNC(_wrap_FXTableItem_isIconOwned), -1);
    rb_define_method(cFXTableItem.klass, "save", VALUEFUNC(_wrap_FXTableItem_save), -1);
    rb_define_method(cFXTableItem.klass, "load", VALUEFUNC(_wrap_FXTableItem_load), -1);
    rb_define_method(cFXTableItem.klass, "draw", VALUEFUNC(_wrap_FXTableItem_draw), -1);
    rb_define_method(cFXTableItem.klass, "drawBorders", VALUEFUNC(_wrap_FXTableItem_drawBorders), -1);
    rb_define_method(cFXTableItem.klass, "drawContent", VALUEFUNC(_wrap_FXTableItem_drawContent), -1);
    rb_define_method(cFXTableItem.klass, "drawPattern", VALUEFUNC(_wrap_FXTableItem_drawPattern), -1);
    rb_define_method(cFXTableItem.klass, "drawBackground", VALUEFUNC(_wrap_FXTableItem_drawBackground), -1);
    rb_define_method(cFXTableItem.klass, "setText", VALUEFUNC(_wrap_FXTableItem_setText), -1);
    rb_define_method(cFXTableItem.klass, "setIcon", VALUEFUNC(_wrap_FXTableItem_setIcon), -1);
    rb_define_method(cFXTableItem.klass, "setFocus", VALUEFUNC(_wrap_FXTableItem_setFocus), -1);
    rb_define_method(cFXTableItem.klass, "setSelected", VALUEFUNC(_wrap_FXTableItem_setSelected), -1);
    rb_define_method(cFXTableItem.klass, "setEnabled", VALUEFUNC(_wrap_FXTableItem_setEnabled), -1);
    rb_define_method(cFXTableItem.klass, "setDraggable", VALUEFUNC(_wrap_FXTableItem_setDraggable), -1);
    rb_define_method(cFXTableItem.klass, "setIconOwned", VALUEFUNC(_wrap_FXTableItem_setIconOwned), -1);
    rb_define_method(cFXTableItem.klass, "getWidth", VALUEFUNC(_wrap_FXTableItem_getWidth), -1);
    rb_define_method(cFXTableItem.klass, "getHeight", VALUEFUNC(_wrap_FXTableItem_getHeight), -1);
    rb_define_method(cFXTableItem.klass, "create", VALUEFUNC(_wrap_FXTableItem_create), -1);
    rb_define_method(cFXTableItem.klass, "detach", VALUEFUNC(_wrap_FXTableItem_detach), -1);
    rb_define_method(cFXTableItem.klass, "destroy", VALUEFUNC(_wrap_FXTableItem_destroy), -1);
    cFXTableItem.mark = (void (*)(void *)) FXRbTableItem::markfunc;
    cFXTableItem.destroy = (void (*)(void *)) FXRbTableItem::freefunc;
    
    cFXTable.klass = rb_define_class_under(mFox, "FXTable", ((swig_class *) SWIGTYPE_p_FXScrollArea->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_FXTable, (void *) &cFXTable);
    rb_define_alloc_func(cFXTable.klass, _wrap_FXTable_allocate);
    rb_define_method(cFXTable.klass, "initialize", VALUEFUNC(_wrap_new_FXTable), -1);
    rb_define_singleton_method(cFXTable.klass, "csvType", VALUEFUNC(FXTable_csvType_get), 0);
    rb_define_singleton_method(cFXTable.klass, "csvType=", VALUEFUNC(FXTable_csvType_set), 1);
    rb_define_singleton_method(cFXTable.klass, "csvTypeName", VALUEFUNC(FXTable_csvTypeName_get), 0);
    rb_define_method(cFXTable.klass, "onPaint", VALUEFUNC(_wrap_FXTable_onPaint), -1);
    rb_define_method(cFXTable.klass, "onFocusIn", VALUEFUNC(_wrap_FXTable_onFocusIn), -1);
    rb_define_method(cFXTable.klass, "onFocusOut", VALUEFUNC(_wrap_FXTable_onFocusOut), -1);
    rb_define_method(cFXTable.klass, "onMotion", VALUEFUNC(_wrap_FXTable_onMotion), -1);
    rb_define_method(cFXTable.klass, "onKeyPress", VALUEFUNC(_wrap_FXTable_onKeyPress), -1);
    rb_define_method(cFXTable.klass, "onKeyRelease", VALUEFUNC(_wrap_FXTable_onKeyRelease), -1);
    rb_define_method(cFXTable.klass, "onLeftBtnPress", VALUEFUNC(_wrap_FXTable_onLeftBtnPress), -1);
    rb_define_method(cFXTable.klass, "onLeftBtnRelease", VALUEFUNC(_wrap_FXTable_onLeftBtnRelease), -1);
    rb_define_method(cFXTable.klass, "onRightBtnPress", VALUEFUNC(_wrap_FXTable_onRightBtnPress), -1);
    rb_define_method(cFXTable.klass, "onRightBtnRelease", VALUEFUNC(_wrap_FXTable_onRightBtnRelease), -1);
    rb_define_method(cFXTable.klass, "onUngrabbed", VALUEFUNC(_wrap_FXTable_onUngrabbed), -1);
    rb_define_method(cFXTable.klass, "onSelectionLost", VALUEFUNC(_wrap_FXTable_onSelectionLost), -1);
    rb_define_method(cFXTable.klass, "onSelectionGained", VALUEFUNC(_wrap_FXTable_onSelectionGained), -1);
    rb_define_method(cFXTable.klass, "onSelectionRequest", VALUEFUNC(_wrap_FXTable_onSelectionRequest), -1);
    rb_define_method(cFXTable.klass, "onClipboardLost", VALUEFUNC(_wrap_FXTable_onClipboardLost), -1);
    rb_define_method(cFXTable.klass, "onClipboardGained", VALUEFUNC(_wrap_FXTable_onClipboardGained), -1);
    rb_define_method(cFXTable.klass, "onClipboardRequest", VALUEFUNC(_wrap_FXTable_onClipboardRequest), -1);
    rb_define_method(cFXTable.klass, "onAutoScroll", VALUEFUNC(_wrap_FXTable_onAutoScroll), -1);
    rb_define_method(cFXTable.klass, "onCommand", VALUEFUNC(_wrap_FXTable_onCommand), -1);
    rb_define_method(cFXTable.klass, "onClicked", VALUEFUNC(_wrap_FXTable_onClicked), -1);
    rb_define_method(cFXTable.klass, "onDoubleClicked", VALUEFUNC(_wrap_FXTable_onDoubleClicked), -1);
    rb_define_method(cFXTable.klass, "onTripleClicked", VALUEFUNC(_wrap_FXTable_onTripleClicked), -1);
    rb_define_method(cFXTable.klass, "onCmdHorzGrid", VALUEFUNC(_wrap_FXTable_onCmdHorzGrid), -1);
    rb_define_method(cFXTable.klass, "onUpdHorzGrid", VALUEFUNC(_wrap_FXTable_onUpdHorzGrid), -1);
    rb_define_method(cFXTable.klass, "onCmdVertGrid", VALUEFUNC(_wrap_FXTable_onCmdVertGrid), -1);
    rb_define_method(cFXTable.klass, "onUpdVertGrid", VALUEFUNC(_wrap_FXTable_onUpdVertGrid), -1);
    rb_define_method(cFXTable.klass, "onCmdDeleteColumn", VALUEFUNC(_wrap_FXTable_onCmdDeleteColumn), -1);
    rb_define_method(cFXTable.klass, "onUpdDeleteColumn", VALUEFUNC(_wrap_FXTable_onUpdDeleteColumn), -1);
    rb_define_method(cFXTable.klass, "onCmdDeleteRow", VALUEFUNC(_wrap_FXTable_onCmdDeleteRow), -1);
    rb_define_method(cFXTable.klass, "onUpdDeleteRow", VALUEFUNC(_wrap_FXTable_onUpdDeleteRow), -1);
    rb_define_method(cFXTable.klass, "onCmdInsertColumn", VALUEFUNC(_wrap_FXTable_onCmdInsertColumn), -1);
    rb_define_method(cFXTable.klass, "onCmdInsertRow", VALUEFUNC(_wrap_FXTable_onCmdInsertRow), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveRight", VALUEFUNC(_wrap_FXTable_onCmdMoveRight), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveLeft", VALUEFUNC(_wrap_FXTable_onCmdMoveLeft), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveUp", VALUEFUNC(_wrap_FXTable_onCmdMoveUp), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveDown", VALUEFUNC(_wrap_FXTable_onCmdMoveDown), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveHome", VALUEFUNC(_wrap_FXTable_onCmdMoveHome), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveEnd", VALUEFUNC(_wrap_FXTable_onCmdMoveEnd), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveTop", VALUEFUNC(_wrap_FXTable_onCmdMoveTop), -1);
    rb_define_method(cFXTable.klass, "onCmdMoveBottom", VALUEFUNC(_wrap_FXTable_onCmdMoveBottom), -1);
    rb_define_method(cFXTable.klass, "onCmdMovePageDown", VALUEFUNC(_wrap_FXTable_onCmdMovePageDown), -1);
    rb_define_method(cFXTable.klass, "onCmdMovePageUp", VALUEFUNC(_wrap_FXTable_onCmdMovePageUp), -1);
    rb_define_method(cFXTable.klass, "onCmdMark", VALUEFUNC(_wrap_FXTable_onCmdMark), -1);
    rb_define_method(cFXTable.klass, "onCmdExtend", VALUEFUNC(_wrap_FXTable_onCmdExtend), -1);
    rb_define_method(cFXTable.klass, "onCmdSelectCell", VALUEFUNC(_wrap_FXTable_onCmdSelectCell), -1);
    rb_define_method(cFXTable.klass, "onCmdSelectRow", VALUEFUNC(_wrap_FXTable_onCmdSelectRow), -1);
    rb_define_method(cFXTable.klass, "onCmdSelectColumn", VALUEFUNC(_wrap_FXTable_onCmdSelectColumn), -1);
    rb_define_method(cFXTable.klass, "onCmdSelectRowIndex", VALUEFUNC(_wrap_FXTable_onCmdSelectRowIndex), -1);
    rb_define_method(cFXTable.klass, "onCmdSelectColumnIndex", VALUEFUNC(_wrap_FXTable_onCmdSelectColumnIndex), -1);
    rb_define_method(cFXTable.klass, "onCmdSelectAll", VALUEFUNC(_wrap_FXTable_onCmdSelectAll), -1);
    rb_define_method(cFXTable.klass, "onCmdDeselectAll", VALUEFUNC(_wrap_FXTable_onCmdDeselectAll), -1);
    rb_define_method(cFXTable.klass, "onCmdCutSel", VALUEFUNC(_wrap_FXTable_onCmdCutSel), -1);
    rb_define_method(cFXTable.klass, "onCmdCopySel", VALUEFUNC(_wrap_FXTable_onCmdCopySel), -1);
    rb_define_method(cFXTable.klass, "onCmdDeleteSel", VALUEFUNC(_wrap_FXTable_onCmdDeleteSel), -1);
    rb_define_method(cFXTable.klass, "onCmdPasteSel", VALUEFUNC(_wrap_FXTable_onCmdPasteSel), -1);
    rb_define_method(cFXTable.klass, "onUpdHaveSelection", VALUEFUNC(_wrap_FXTable_onUpdHaveSelection), -1);
    rb_define_const(cFXTable.klass,"ID_HORZ_GRID", INT2NUM(FXTable::ID_HORZ_GRID));
    rb_define_const(cFXTable.klass,"ID_VERT_GRID", INT2NUM(FXTable::ID_VERT_GRID));
    rb_define_const(cFXTable.klass,"ID_DELETE_COLUMN", INT2NUM(FXTable::ID_DELETE_COLUMN));
    rb_define_const(cFXTable.klass,"ID_DELETE_ROW", INT2NUM(FXTable::ID_DELETE_ROW));
    rb_define_const(cFXTable.klass,"ID_INSERT_COLUMN", INT2NUM(FXTable::ID_INSERT_COLUMN));
    rb_define_const(cFXTable.klass,"ID_INSERT_ROW", INT2NUM(FXTable::ID_INSERT_ROW));
    rb_define_const(cFXTable.klass,"ID_SELECT_COLUMN_INDEX", INT2NUM(FXTable::ID_SELECT_COLUMN_INDEX));
    rb_define_const(cFXTable.klass,"ID_SELECT_ROW_INDEX", INT2NUM(FXTable::ID_SELECT_ROW_INDEX));
    rb_define_const(cFXTable.klass,"ID_SELECT_COLUMN", INT2NUM(FXTable::ID_SELECT_COLUMN));
    rb_define_const(cFXTable.klass,"ID_SELECT_ROW", INT2NUM(FXTable::ID_SELECT_ROW));
    rb_define_const(cFXTable.klass,"ID_SELECT_CELL", INT2NUM(FXTable::ID_SELECT_CELL));
    rb_define_const(cFXTable.klass,"ID_SELECT_ALL", INT2NUM(FXTable::ID_SELECT_ALL));
    rb_define_const(cFXTable.klass,"ID_DESELECT_ALL", INT2NUM(FXTable::ID_DESELECT_ALL));
    rb_define_const(cFXTable.klass,"ID_MOVE_LEFT", INT2NUM(FXTable::ID_MOVE_LEFT));
    rb_define_const(cFXTable.klass,"ID_MOVE_RIGHT", INT2NUM(FXTable::ID_MOVE_RIGHT));
    rb_define_const(cFXTable.klass,"ID_MOVE_UP", INT2NUM(FXTable::ID_MOVE_UP));
    rb_define_const(cFXTable.klass,"ID_MOVE_DOWN", INT2NUM(FXTable::ID_MOVE_DOWN));
    rb_define_const(cFXTable.klass,"ID_MOVE_HOME", INT2NUM(FXTable::ID_MOVE_HOME));
    rb_define_const(cFXTable.klass,"ID_MOVE_END", INT2NUM(FXTable::ID_MOVE_END));
    rb_define_const(cFXTable.klass,"ID_MOVE_TOP", INT2NUM(FXTable::ID_MOVE_TOP));
    rb_define_const(cFXTable.klass,"ID_MOVE_BOTTOM", INT2NUM(FXTable::ID_MOVE_BOTTOM));
    rb_define_const(cFXTable.klass,"ID_MOVE_PAGEDOWN", INT2NUM(FXTable::ID_MOVE_PAGEDOWN));
    rb_define_const(cFXTable.klass,"ID_MOVE_PAGEUP", INT2NUM(FXTable::ID_MOVE_PAGEUP));
    rb_define_const(cFXTable.klass,"ID_MARK", INT2NUM(FXTable::ID_MARK));
    rb_define_const(cFXTable.klass,"ID_EXTEND", INT2NUM(FXTable::ID_EXTEND));
    rb_define_const(cFXTable.klass,"ID_CUT_SEL", INT2NUM(FXTable::ID_CUT_SEL));
    rb_define_const(cFXTable.klass,"ID_COPY_SEL", INT2NUM(FXTable::ID_COPY_SEL));
    rb_define_const(cFXTable.klass,"ID_PASTE_SEL", INT2NUM(FXTable::ID_PASTE_SEL));
    rb_define_const(cFXTable.klass,"ID_DELETE_SEL", INT2NUM(FXTable::ID_DELETE_SEL));
    rb_define_const(cFXTable.klass,"ID_LAST", INT2NUM(FXTable::ID_LAST));
    rb_define_method(cFXTable.klass, "getColumnHeader", VALUEFUNC(_wrap_FXTable_getColumnHeader), -1);
    rb_define_method(cFXTable.klass, "getRowHeader", VALUEFUNC(_wrap_FXTable_getRowHeader), -1);
    rb_define_method(cFXTable.klass, "setVisibleRows", VALUEFUNC(_wrap_FXTable_setVisibleRows), -1);
    rb_define_method(cFXTable.klass, "getVisibleRows", VALUEFUNC(_wrap_FXTable_getVisibleRows), -1);
    rb_define_method(cFXTable.klass, "setVisibleColumns", VALUEFUNC(_wrap_FXTable_setVisibleColumns), -1);
    rb_define_method(cFXTable.klass, "getVisibleColumns", VALUEFUNC(_wrap_FXTable_getVisibleColumns), -1);
    rb_define_method(cFXTable.klass, "showHorzGrid", VALUEFUNC(_wrap_FXTable_showHorzGrid), -1);
    rb_define_method(cFXTable.klass, "isHorzGridShown", VALUEFUNC(_wrap_FXTable_isHorzGridShown), -1);
    rb_define_method(cFXTable.klass, "showVertGrid", VALUEFUNC(_wrap_FXTable_showVertGrid), -1);
    rb_define_method(cFXTable.klass, "isVertGridShown", VALUEFUNC(_wrap_FXTable_isVertGridShown), -1);
    rb_define_method(cFXTable.klass, "getNumRows", VALUEFUNC(_wrap_FXTable_getNumRows), -1);
    rb_define_method(cFXTable.klass, "getNumColumns", VALUEFUNC(_wrap_FXTable_getNumColumns), -1);
    rb_define_method(cFXTable.klass, "setMarginTop", VALUEFUNC(_wrap_FXTable_setMarginTop), -1);
    rb_define_method(cFXTable.klass, "getMarginTop", VALUEFUNC(_wrap_FXTable_getMarginTop), -1);
    rb_define_method(cFXTable.klass, "setMarginBottom", VALUEFUNC(_wrap_FXTable_setMarginBottom), -1);
    rb_define_method(cFXTable.klass, "getMarginBottom", VALUEFUNC(_wrap_FXTable_getMarginBottom), -1);
    rb_define_method(cFXTable.klass, "setMarginLeft", VALUEFUNC(_wrap_FXTable_setMarginLeft), -1);
    rb_define_method(cFXTable.klass, "getMarginLeft", VALUEFUNC(_wrap_FXTable_getMarginLeft), -1);
    rb_define_method(cFXTable.klass, "setMarginRight", VALUEFUNC(_wrap_FXTable_setMarginRight), -1);
    rb_define_method(cFXTable.klass, "getMarginRight", VALUEFUNC(_wrap_FXTable_getMarginRight), -1);
    rb_define_method(cFXTable.klass, "rowAtY", VALUEFUNC(_wrap_FXTable_rowAtY), -1);
    rb_define_method(cFXTable.klass, "colAtX", VALUEFUNC(_wrap_FXTable_colAtX), -1);
    rb_define_method(cFXTable.klass, "getItem", VALUEFUNC(_wrap_FXTable_getItem), -1);
    rb_define_method(cFXTable.klass, "setItem", VALUEFUNC(_wrap_FXTable_setItem), -1);
    rb_define_method(cFXTable.klass, "makePositionVisible", VALUEFUNC(_wrap_FXTable_makePositionVisible), -1);
    rb_define_method(cFXTable.klass, "isItemVisible", VALUEFUNC(_wrap_FXTable_isItemVisible), -1);
    rb_define_method(cFXTable.klass, "setColumnHeaderMode", VALUEFUNC(_wrap_FXTable_setColumnHeaderMode), -1);
    rb_define_method(cFXTable.klass, "getColumnHeaderMode", VALUEFUNC(_wrap_FXTable_getColumnHeaderMode), -1);
    rb_define_method(cFXTable.klass, "setRowHeaderMode", VALUEFUNC(_wrap_FXTable_setRowHeaderMode), -1);
    rb_define_method(cFXTable.klass, "getRowHeaderMode", VALUEFUNC(_wrap_FXTable_getRowHeaderMode), -1);
    rb_define_method(cFXTable.klass, "setColumnHeaderHeight", VALUEFUNC(_wrap_FXTable_setColumnHeaderHeight), -1);
    rb_define_method(cFXTable.klass, "getColumnHeaderHeight", VALUEFUNC(_wrap_FXTable_getColumnHeaderHeight), -1);
    rb_define_method(cFXTable.klass, "setRowHeaderWidth", VALUEFUNC(_wrap_FXTable_setRowHeaderWidth), -1);
    rb_define_method(cFXTable.klass, "getRowHeaderWidth", VALUEFUNC(_wrap_FXTable_getRowHeaderWidth), -1);
    rb_define_method(cFXTable.klass, "getColumnWidth", VALUEFUNC(_wrap_FXTable_getColumnWidth), -1);
    rb_define_method(cFXTable.klass, "getRowHeight", VALUEFUNC(_wrap_FXTable_getRowHeight), -1);
    rb_define_method(cFXTable.klass, "getColumnX", VALUEFUNC(_wrap_FXTable_getColumnX), -1);
    rb_define_method(cFXTable.klass, "getRowY", VALUEFUNC(_wrap_FXTable_getRowY), -1);
    rb_define_method(cFXTable.klass, "setDefColumnWidth", VALUEFUNC(_wrap_FXTable_setDefColumnWidth), -1);
    rb_define_method(cFXTable.klass, "getDefColumnWidth", VALUEFUNC(_wrap_FXTable_getDefColumnWidth), -1);
    rb_define_method(cFXTable.klass, "setDefRowHeight", VALUEFUNC(_wrap_FXTable_setDefRowHeight), -1);
    rb_define_method(cFXTable.klass, "getDefRowHeight", VALUEFUNC(_wrap_FXTable_getDefRowHeight), -1);
    rb_define_method(cFXTable.klass, "getMinRowHeight", VALUEFUNC(_wrap_FXTable_getMinRowHeight), -1);
    rb_define_method(cFXTable.klass, "getMinColumnWidth", VALUEFUNC(_wrap_FXTable_getMinColumnWidth), -1);
    rb_define_method(cFXTable.klass, "setColumnText", VALUEFUNC(_wrap_FXTable_setColumnText), -1);
    rb_define_method(cFXTable.klass, "getColumnText", VALUEFUNC(_wrap_FXTable_getColumnText), -1);
    rb_define_method(cFXTable.klass, "setRowText", VALUEFUNC(_wrap_FXTable_setRowText), -1);
    rb_define_method(cFXTable.klass, "getRowText", VALUEFUNC(_wrap_FXTable_getRowText), -1);
    rb_define_method(cFXTable.klass, "setItemText", VALUEFUNC(_wrap_FXTable_setItemText), -1);
    rb_define_method(cFXTable.klass, "getItemText", VALUEFUNC(_wrap_FXTable_getItemText), -1);
    rb_define_method(cFXTable.klass, "setItemIcon", VALUEFUNC(_wrap_FXTable_setItemIcon), -1);
    rb_define_method(cFXTable.klass, "getItemIcon", VALUEFUNC(_wrap_FXTable_getItemIcon), -1);
    rb_define_method(cFXTable.klass, "setItemData", VALUEFUNC(_wrap_FXTable_setItemData), -1);
    rb_define_method(cFXTable.klass, "getItemData", VALUEFUNC(_wrap_FXTable_getItemData), -1);
    rb_define_method(cFXTable.klass, "extractText", VALUEFUNC(_wrap_FXTable_extractText), -1);
    rb_define_method(cFXTable.klass, "overlayText", VALUEFUNC(_wrap_FXTable_overlayText), -1);
    rb_define_method(cFXTable.klass, "isItemSpanning", VALUEFUNC(_wrap_FXTable_isItemSpanning), -1);
    rb_define_method(cFXTable.klass, "updateRange", VALUEFUNC(_wrap_FXTable_updateRange), -1);
    rb_define_method(cFXTable.klass, "updateItem", VALUEFUNC(_wrap_FXTable_updateItem), -1);
    rb_define_method(cFXTable.klass, "enableItem", VALUEFUNC(_wrap_FXTable_enableItem), -1);
    rb_define_method(cFXTable.klass, "disableItem", VALUEFUNC(_wrap_FXTable_disableItem), -1);
    rb_define_method(cFXTable.klass, "isItemEnabled", VALUEFUNC(_wrap_FXTable_isItemEnabled), -1);
    rb_define_method(cFXTable.klass, "setItemJustify", VALUEFUNC(_wrap_FXTable_setItemJustify), -1);
    rb_define_method(cFXTable.klass, "getItemJustify", VALUEFUNC(_wrap_FXTable_getItemJustify), -1);
    rb_define_method(cFXTable.klass, "setItemIconPosition", VALUEFUNC(_wrap_FXTable_setItemIconPosition), -1);
    rb_define_method(cFXTable.klass, "getItemIconPosition", VALUEFUNC(_wrap_FXTable_getItemIconPosition), -1);
    rb_define_method(cFXTable.klass, "setItemBorders", VALUEFUNC(_wrap_FXTable_setItemBorders), -1);
    rb_define_method(cFXTable.klass, "getItemBorders", VALUEFUNC(_wrap_FXTable_getItemBorders), -1);
    rb_define_method(cFXTable.klass, "setItemStipple", VALUEFUNC(_wrap_FXTable_setItemStipple), -1);
    rb_define_method(cFXTable.klass, "getItemStipple", VALUEFUNC(_wrap_FXTable_getItemStipple), -1);
    rb_define_method(cFXTable.klass, "getCurrentRow", VALUEFUNC(_wrap_FXTable_getCurrentRow), -1);
    rb_define_method(cFXTable.klass, "getCurrentColumn", VALUEFUNC(_wrap_FXTable_getCurrentColumn), -1);
    rb_define_method(cFXTable.klass, "isItemCurrent", VALUEFUNC(_wrap_FXTable_isItemCurrent), -1);
    rb_define_method(cFXTable.klass, "setAnchorItem", VALUEFUNC(_wrap_FXTable_setAnchorItem), -1);
    rb_define_method(cFXTable.klass, "getAnchorRow", VALUEFUNC(_wrap_FXTable_getAnchorRow), -1);
    rb_define_method(cFXTable.klass, "getAnchorColumn", VALUEFUNC(_wrap_FXTable_getAnchorColumn), -1);
    rb_define_method(cFXTable.klass, "getSelStartRow", VALUEFUNC(_wrap_FXTable_getSelStartRow), -1);
    rb_define_method(cFXTable.klass, "getSelStartColumn", VALUEFUNC(_wrap_FXTable_getSelStartColumn), -1);
    rb_define_method(cFXTable.klass, "getSelEndRow", VALUEFUNC(_wrap_FXTable_getSelEndRow), -1);
    rb_define_method(cFXTable.klass, "getSelEndColumn", VALUEFUNC(_wrap_FXTable_getSelEndColumn), -1);
    rb_define_method(cFXTable.klass, "isItemSelected", VALUEFUNC(_wrap_FXTable_isItemSelected), -1);
    rb_define_method(cFXTable.klass, "isRowSelected", VALUEFUNC(_wrap_FXTable_isRowSelected), -1);
    rb_define_method(cFXTable.klass, "isColumnSelected", VALUEFUNC(_wrap_FXTable_isColumnSelected), -1);
    rb_define_method(cFXTable.klass, "isAnythingSelected", VALUEFUNC(_wrap_FXTable_isAnythingSelected), -1);
    rb_define_method(cFXTable.klass, "setFont", VALUEFUNC(_wrap_FXTable_setFont), -1);
    rb_define_method(cFXTable.klass, "getFont", VALUEFUNC(_wrap_FXTable_getFont), -1);
    rb_define_method(cFXTable.klass, "getTextColor", VALUEFUNC(_wrap_FXTable_getTextColor), -1);
    rb_define_method(cFXTable.klass, "getBaseColor", VALUEFUNC(_wrap_FXTable_getBaseColor), -1);
    rb_define_method(cFXTable.klass, "getHiliteColor", VALUEFUNC(_wrap_FXTable_getHiliteColor), -1);
    rb_define_method(cFXTable.klass, "getShadowColor", VALUEFUNC(_wrap_FXTable_getShadowColor), -1);
    rb_define_method(cFXTable.klass, "getBorderColor", VALUEFUNC(_wrap_FXTable_getBorderColor), -1);
    rb_define_method(cFXTable.klass, "getSelBackColor", VALUEFUNC(_wrap_FXTable_getSelBackColor), -1);
    rb_define_method(cFXTable.klass, "getSelTextColor", VALUEFUNC(_wrap_FXTable_getSelTextColor), -1);
    rb_define_method(cFXTable.klass, "getGridColor", VALUEFUNC(_wrap_FXTable_getGridColor), -1);
    rb_define_method(cFXTable.klass, "getStippleColor", VALUEFUNC(_wrap_FXTable_getStippleColor), -1);
    rb_define_method(cFXTable.klass, "getCellBorderColor", VALUEFUNC(_wrap_FXTable_getCellBorderColor), -1);
    rb_define_method(cFXTable.klass, "setTextColor", VALUEFUNC(_wrap_FXTable_setTextColor), -1);
    rb_define_method(cFXTable.klass, "setBaseColor", VALUEFUNC(_wrap_FXTable_setBaseColor), -1);
    rb_define_method(cFXTable.klass, "setHiliteColor", VALUEFUNC(_wrap_FXTable_setHiliteColor), -1);
    rb_define_method(cFXTable.klass, "setShadowColor", VALUEFUNC(_wrap_FXTable_setShadowColor), -1);
    rb_define_method(cFXTable.klass, "setBorderColor", VALUEFUNC(_wrap_FXTable_setBorderColor), -1);
    rb_define_method(cFXTable.klass, "setSelBackColor", VALUEFUNC(_wrap_FXTable_setSelBackColor), -1);
    rb_define_method(cFXTable.klass, "setSelTextColor", VALUEFUNC(_wrap_FXTable_setSelTextColor), -1);
    rb_define_method(cFXTable.klass, "setGridColor", VALUEFUNC(_wrap_FXTable_setGridColor), -1);
    rb_define_method(cFXTable.klass, "setStippleColor", VALUEFUNC(_wrap_FXTable_setStippleColor), -1);
    rb_define_method(cFXTable.klass, "setCellBorderColor", VALUEFUNC(_wrap_FXTable_setCellBorderColor), -1);
    rb_define_method(cFXTable.klass, "setCellColor", VALUEFUNC(_wrap_FXTable_setCellColor), -1);
    rb_define_method(cFXTable.klass, "getCellColor", VALUEFUNC(_wrap_FXTable_getCellColor), -1);
    rb_define_method(cFXTable.klass, "setCellBorderWidth", VALUEFUNC(_wrap_FXTable_setCellBorderWidth), -1);
    rb_define_method(cFXTable.klass, "getCellBorderWidth", VALUEFUNC(_wrap_FXTable_getCellBorderWidth), -1);
    rb_define_method(cFXTable.klass, "getTableStyle", VALUEFUNC(_wrap_FXTable_getTableStyle), -1);
    rb_define_method(cFXTable.klass, "setTableStyle", VALUEFUNC(_wrap_FXTable_setTableStyle), -1);
    rb_define_method(cFXTable.klass, "setHelpText", VALUEFUNC(_wrap_FXTable_setHelpText), -1);
    rb_define_method(cFXTable.klass, "getHelpText", VALUEFUNC(_wrap_FXTable_getHelpText), -1);
    rb_define_method(cFXTable.klass, "save", VALUEFUNC(_wrap_FXTable_save), -1);
    rb_define_method(cFXTable.klass, "load", VALUEFUNC(_wrap_FXTable_load), -1);
    rb_define_method(cFXTable.klass, "create", VALUEFUNC(_wrap_FXTable_create), -1);
    rb_define_method(cFXTable.klass, "detach", VALUEFUNC(_wrap_FXTable_detach), -1);
    rb_define_method(cFXTable.klass, "destroy", VALUEFUNC(_wrap_FXTable_destroy), -1);
    rb_define_method(cFXTable.klass, "resize", VALUEFUNC(_wrap_FXTable_resize), -1);
    rb_define_method(cFXTable.klass, "getDefaultWidth", VALUEFUNC(_wrap_FXTable_getDefaultWidth), -1);
    rb_define_method(cFXTable.klass, "getDefaultHeight", VALUEFUNC(_wrap_FXTable_getDefaultHeight), -1);
    rb_define_method(cFXTable.klass, "getWidthForHeight", VALUEFUNC(_wrap_FXTable_getWidthForHeight), -1);
    rb_define_method(cFXTable.klass, "getHeightForWidth", VALUEFUNC(_wrap_FXTable_getHeightForWidth), -1);
    rb_define_method(cFXTable.klass, "canFocus", VALUEFUNC(_wrap_FXTable_canFocus), -1);
    rb_define_method(cFXTable.klass, "setFocus", VALUEFUNC(_wrap_FXTable_setFocus), -1);
    rb_define_method(cFXTable.klass, "killFocus", VALUEFUNC(_wrap_FXTable_killFocus), -1);
    rb_define_method(cFXTable.klass, "setDefault", VALUEFUNC(_wrap_FXTable_setDefault), -1);
    rb_define_method(cFXTable.klass, "enable", VALUEFUNC(_wrap_FXTable_enable), -1);
    rb_define_method(cFXTable.klass, "disable", VALUEFUNC(_wrap_FXTable_disable), -1);
    rb_define_method(cFXTable.klass, "raiseWindow", VALUEFUNC(_wrap_FXTable_raiseWindow), -1);
    rb_define_method(cFXTable.klass, "lower", VALUEFUNC(_wrap_FXTable_lower), -1);
    rb_define_method(cFXTable.klass, "move", VALUEFUNC(_wrap_FXTable_move), -1);
    rb_define_method(cFXTable.klass, "layout", VALUEFUNC(_wrap_FXTable_layout), -1);
    rb_define_method(cFXTable.klass, "recalc", VALUEFUNC(_wrap_FXTable_recalc), -1);
    rb_define_method(cFXTable.klass, "reparent", VALUEFUNC(_wrap_FXTable_reparent), -1);
    rb_define_method(cFXTable.klass, "show", VALUEFUNC(_wrap_FXTable_show), -1);
    rb_define_method(cFXTable.klass, "hide", VALUEFUNC(_wrap_FXTable_hide), -1);
    rb_define_method(cFXTable.klass, "isComposite", VALUEFUNC(_wrap_FXTable_isComposite), -1);
    rb_define_method(cFXTable.klass, "contains", VALUEFUNC(_wrap_FXTable_contains), -1);
    rb_define_method(cFXTable.klass, "doesSaveUnder", VALUEFUNC(_wrap_FXTable_doesSaveUnder), -1);
    rb_define_method(cFXTable.klass, "setBackColor", VALUEFUNC(_wrap_FXTable_setBackColor), -1);
    rb_define_method(cFXTable.klass, "getViewportHeight", VALUEFUNC(_wrap_FXTable_getViewportHeight), -1);
    rb_define_method(cFXTable.klass, "getViewportWidth", VALUEFUNC(_wrap_FXTable_getViewportWidth), -1);
    rb_define_method(cFXTable.klass, "getContentHeight", VALUEFUNC(_wrap_FXTable_getContentHeight), -1);
    rb_define_method(cFXTable.klass, "getContentWidth", VALUEFUNC(_wrap_FXTable_getContentWidth), -1);
    rb_define_method(cFXTable.klass, "position", VALUEFUNC(_wrap_FXTable_position), -1);
    rb_define_method(cFXTable.klass, "drawCell", VALUEFUNC(_wrap_FXTable_drawCell), -1);
    rb_define_method(cFXTable.klass, "drawRange", VALUEFUNC(_wrap_FXTable_drawRange), -1);
    rb_define_method(cFXTable.klass, "drawHGrid", VALUEFUNC(_wrap_FXTable_drawHGrid), -1);
    rb_define_method(cFXTable.klass, "drawVGrid", VALUEFUNC(_wrap_FXTable_drawVGrid), -1);
    rb_define_method(cFXTable.klass, "drawContents", VALUEFUNC(_wrap_FXTable_drawContents), -1);
    rb_define_method(cFXTable.klass, "createItem", VALUEFUNC(_wrap_FXTable_createItem), -1);
    rb_define_method(cFXTable.klass, "setTableSize", VALUEFUNC(_wrap_FXTable_setTableSize), -1);
    rb_define_method(cFXTable.klass, "insertRows", VALUEFUNC(_wrap_FXTable_insertRows), -1);
    rb_define_method(cFXTable.klass, "insertColumns", VALUEFUNC(_wrap_FXTable_insertColumns), -1);
    rb_define_method(cFXTable.klass, "removeRows", VALUEFUNC(_wrap_FXTable_removeRows), -1);
    rb_define_method(cFXTable.klass, "removeColumns", VALUEFUNC(_wrap_FXTable_removeColumns), -1);
    rb_define_method(cFXTable.klass, "removeItem", VALUEFUNC(_wrap_FXTable_removeItem), -1);
    rb_define_method(cFXTable.klass, "removeRange", VALUEFUNC(_wrap_FXTable_removeRange), -1);
    rb_define_method(cFXTable.klass, "clearItems", VALUEFUNC(_wrap_FXTable_clearItems), -1);
    rb_define_method(cFXTable.klass, "setColumnWidth", VALUEFUNC(_wrap_FXTable_setColumnWidth), -1);
    rb_define_method(cFXTable.klass, "setRowHeight", VALUEFUNC(_wrap_FXTable_setRowHeight), -1);
    rb_define_method(cFXTable.klass, "setColumnX", VALUEFUNC(_wrap_FXTable_setColumnX), -1);
    rb_define_method(cFXTable.klass, "setRowY", VALUEFUNC(_wrap_FXTable_setRowY), -1);
    rb_define_method(cFXTable.klass, "setCurrentItem", VALUEFUNC(_wrap_FXTable_setCurrentItem), -1);
    rb_define_method(cFXTable.klass, "selectRow", VALUEFUNC(_wrap_FXTable_selectRow), -1);
    rb_define_method(cFXTable.klass, "selectColumn", VALUEFUNC(_wrap_FXTable_selectColumn), -1);
    rb_define_method(cFXTable.klass, "selectRange", VALUEFUNC(_wrap_FXTable_selectRange), -1);
    rb_define_method(cFXTable.klass, "extendSelection", VALUEFUNC(_wrap_FXTable_extendSelection), -1);
    rb_define_method(cFXTable.klass, "killSelection", VALUEFUNC(_wrap_FXTable_killSelection), -1);
    cFXTable.mark = (void (*)(void *)) FXRbTable::markfunc;
    cFXTable.destroy = (void (*)(void *)) FXRbObject::freefunc;
}

