# This file is automatically generated from Scintilla.iface
# DO NOT MODIFY

module Fox
  class FXScintilla
    # 







    # Basics

    INVALID_POSITION = -1
    # Define start of Scintilla messages to be greater than all edit (EM_*) messages
    # as many EM_ messages can be used although that use is deprecated.
    SCI_START = 2000
    SCI_OPTIONAL_START = 3000
    SCI_LEXER_START = 4000

    # Add text to the document.
    def addText(length, text)
      sendMessage(2001, length, text)
    end

    # Add array of cells to document.
    def addStyledText(length, c)
      sendMessage(2002, length, c)
    end

    # Insert string at a position.
    def insertText(pos, text)
      sendMessage(2003, pos, text)
    end

    # Delete all text in the document.
    def clearAll
      sendMessage(2004, 0, 0)
    end

    # Set all style bytes to 0, remove all folding information.
    def clearDocumentStyle
      sendMessage(2005, 0, 0)
    end

    # The number of characters in the document.
    def getLength
      sendMessage(2006, 0, 0)
    end

    # Returns the character byte at the position.
    def getCharAt(pos)
      sendMessage(2007, pos, 0)
    end

    # Returns the position of the caret.
    def getCurrentPos
      sendMessage(2008, 0, 0)
    end

    # Returns the position of the opposite end of the selection to the caret.
    def getAnchor
      sendMessage(2009, 0, 0)
    end

    # Returns the style byte at the position.
    def getStyleAt(pos)
      sendMessage(2010, pos, 0)
    end

    # Redoes the next action on the undo history.
    def redo
      sendMessage(2011, 0, 0)
    end

    # Choose between collecting actions into the undo
    # history and discarding them.
    def setUndoCollection(collectUndo)
      sendMessage(2012, collectUndo, 0)
    end

    # Select all the text in the document.
    def selectAll
      sendMessage(2013, 0, 0)
    end

    # Remember the current position in the undo history as the position
    # at which the document was saved.
    def setSavePoint
      sendMessage(2014, 0, 0)
    end

    # Retrieve a buffer of cells.
    # Returns the number of bytes in the buffer not including terminating nulls.
    def getStyledText(tr)
      sendMessage(2015, 0, tr)
    end

    # Are there any redoable actions in the undo history?
    def canRedo
      sendMessage(2016, 0, 0) == 1 ? true : false
    end

    # Retrieve the line number at which a particular marker is located.
    def markerLineFromHandle(handle)
      sendMessage(2017, handle, 0)
    end

    # Delete a marker.
    def markerDeleteHandle(handle)
      sendMessage(2018, handle, 0)
    end

    # Is undo history being collected?
    def getUndoCollection
      sendMessage(2019, 0, 0) == 1 ? true : false
    end

    SCWS_INVISIBLE = 0
    SCWS_VISIBLEALWAYS = 1
    SCWS_VISIBLEAFTERINDENT = 2

    # Are white space characters currently visible?
    # Returns one of SCWS_* constants.
    def getViewWS
      sendMessage(2020, 0, 0)
    end

    # Make white space characters invisible, always visible or visible outside indentation.
    def setViewWS(viewWS)
      sendMessage(2021, viewWS, 0)
    end

    # Find the position from a point within the window.
    def positionFromPoint(x, y)
      sendMessage(2022, x, y)
    end

    # Find the position from a point within the window but return
    # INVALID_POSITION if not close to text.
    def positionFromPointClose(x, y)
      sendMessage(2023, x, y)
    end

    # Set caret to start of a line and ensure it is visible.
    def gotoLine(line)
      sendMessage(2024, line, 0)
    end

    # Set caret to a position and ensure it is visible.
    def gotoPos(pos)
      sendMessage(2025, pos, 0)
    end

    # Set the selection anchor to a position. The anchor is the opposite
    # end of the selection from the caret.
    def setAnchor(posAnchor)
      sendMessage(2026, posAnchor, 0)
    end

    # Retrieve the text of the line containing the caret.
    # Returns the index of the caret on the line.
    def getCurLine(length)
      buffer = "".ljust(length)
      sendMessage(2027, length, buffer)
      buffer
    end

    # Retrieve the position of the last correctly styled character.
    def getEndStyled
      sendMessage(2028, 0, 0)
    end

    SC_EOL_CRLF = 0
    SC_EOL_CR = 1
    SC_EOL_LF = 2

    # Convert all line endings in the document to one mode.
    def convertEOLs(eolMode)
      sendMessage(2029, eolMode, 0)
    end

    # Retrieve the current end of line mode - one of CRLF, CR, or LF.
    def getEOLMode
      sendMessage(2030, 0, 0)
    end

    # Set the current end of line mode.
    def setEOLMode(eolMode)
      sendMessage(2031, eolMode, 0)
    end

    # Set the current styling position to pos and the styling mask to mask.
    # The styling mask can be used to protect some bits in each styling byte from modification.
    def startStyling(pos, mask)
      sendMessage(2032, pos, mask)
    end

    # Change style from current styling position for length characters to a style
    # and move the current styling position to after this newly styled segment.
    def setStyling(length, style)
      sendMessage(2033, length, style)
    end

    # Is drawing done first into a buffer or direct to the screen?
    def getBufferedDraw
      sendMessage(2034, 0, 0) == 1 ? true : false
    end

    # If drawing is buffered then each line of text is drawn into a bitmap buffer
    # before drawing it to the screen to avoid flicker.
    def setBufferedDraw(buffered)
      sendMessage(2035, buffered, 0)
    end

    # Change the visible size of a tab to be a multiple of the width of a space character.
    def setTabWidth(tabWidth)
      sendMessage(2036, tabWidth, 0)
    end

    # Retrieve the visible size of a tab.
    def getTabWidth
      sendMessage(2121, 0, 0)
    end

    # The SC_CP_UTF8 value can be used to enter Unicode mode.
    # This is the same value as CP_UTF8 in Windows
    SC_CP_UTF8 = 65001

    # The SC_CP_DBCS value can be used to indicate a DBCS mode for GTK+.
    SC_CP_DBCS = 1

    # Set the code page used to interpret the bytes of the document as characters.
    # The SC_CP_UTF8 value can be used to enter Unicode mode.
    def setCodePage(codePage)
      sendMessage(2037, codePage, 0)
    end

    # In palette mode, Scintilla uses the environment's palette calls to display
    # more colours. This may lead to ugly displays.
    def setUsePalette(usePalette)
      sendMessage(2039, usePalette, 0)
    end

    MARKER_MAX = 31
    SC_MARK_CIRCLE = 0
    SC_MARK_ROUNDRECT = 1
    SC_MARK_ARROW = 2
    SC_MARK_SMALLRECT = 3
    SC_MARK_SHORTARROW = 4
    SC_MARK_EMPTY = 5
    SC_MARK_ARROWDOWN = 6
    SC_MARK_MINUS = 7
    SC_MARK_PLUS = 8

    # Shapes used for outlining column.
    SC_MARK_VLINE = 9
    SC_MARK_LCORNER = 10
    SC_MARK_TCORNER = 11
    SC_MARK_BOXPLUS = 12
    SC_MARK_BOXPLUSCONNECTED = 13
    SC_MARK_BOXMINUS = 14
    SC_MARK_BOXMINUSCONNECTED = 15
    SC_MARK_LCORNERCURVE = 16
    SC_MARK_TCORNERCURVE = 17
    SC_MARK_CIRCLEPLUS = 18
    SC_MARK_CIRCLEPLUSCONNECTED = 19
    SC_MARK_CIRCLEMINUS = 20
    SC_MARK_CIRCLEMINUSCONNECTED = 21

    # Invisible mark that only sets the line background color.
    SC_MARK_BACKGROUND = 22
    SC_MARK_DOTDOTDOT = 23
    SC_MARK_ARROWS = 24
    SC_MARK_PIXMAP = 25

    SC_MARK_CHARACTER = 10000

    # Markers used for outlining column.
    SC_MARKNUM_FOLDEREND = 25
    SC_MARKNUM_FOLDEROPENMID = 26
    SC_MARKNUM_FOLDERMIDTAIL = 27
    SC_MARKNUM_FOLDERTAIL = 28
    SC_MARKNUM_FOLDERSUB = 29
    SC_MARKNUM_FOLDER = 30
    SC_MARKNUM_FOLDEROPEN = 31

    SC_MASK_FOLDERS = 0xFE000000

    # Set the symbol used for a particular marker number.
    def markerDefine(markerNumber, markerSymbol)
      sendMessage(2040, markerNumber, markerSymbol)
    end

    # Set the foreground colour used for a particular marker number.
    def markerSetFore(markerNumber, fore)
      sendMessage(2041, markerNumber, fore & 0xffffff)
    end

    # Set the background colour used for a particular marker number.
    def markerSetBack(markerNumber, back)
      sendMessage(2042, markerNumber, back & 0xffffff)
    end

    # Add a marker to a line, returning an ID which can be used to find or delete the marker.
    def markerAdd(line, markerNumber)
      sendMessage(2043, line, markerNumber)
    end

    # Delete a marker from a line.
    def markerDelete(line, markerNumber)
      sendMessage(2044, line, markerNumber)
    end

    # Delete all markers with a particular number from all lines.
    def markerDeleteAll(markerNumber)
      sendMessage(2045, markerNumber, 0)
    end

    # Get a bit mask of all the markers set on a line.
    def markerGet(line)
      sendMessage(2046, line, 0)
    end

    # Find the next line after lineStart that includes a marker in mask.
    def markerNext(lineStart, markerMask)
      sendMessage(2047, lineStart, markerMask)
    end

    # Find the previous line before lineStart that includes a marker in mask.
    def markerPrevious(lineStart, markerMask)
      sendMessage(2048, lineStart, markerMask)
    end

    # Define a marker from a pixmap.
    def markerDefinePixmap(markerNumber, pixmap)
      sendMessage(2049, markerNumber, pixmap)
    end

    SC_MARGIN_SYMBOL = 0
    SC_MARGIN_NUMBER = 1

    # Set a margin to be either numeric or symbolic.
    def setMarginTypeN(margin, marginType)
      sendMessage(2240, margin, marginType)
    end

    # Retrieve the type of a margin.
    def getMarginTypeN(margin)
      sendMessage(2241, margin, 0)
    end

    # Set the width of a margin to a width expressed in pixels.
    def setMarginWidthN(margin, pixelWidth)
      sendMessage(2242, margin, pixelWidth)
    end

    # Retrieve the width of a margin in pixels.
    def getMarginWidthN(margin)
      sendMessage(2243, margin, 0)
    end

    # Set a mask that determines which markers are displayed in a margin.
    def setMarginMaskN(margin, mask)
      sendMessage(2244, margin, mask)
    end

    # Retrieve the marker mask of a margin.
    def getMarginMaskN(margin)
      sendMessage(2245, margin, 0)
    end

    # Make a margin sensitive or insensitive to mouse clicks.
    def setMarginSensitiveN(margin, sensitive)
      sendMessage(2246, margin, sensitive)
    end

    # Retrieve the mouse click sensitivity of a margin.
    def getMarginSensitiveN(margin)
      sendMessage(2247, margin, 0) == 1 ? true : false
    end

    # Styles in range 32..37 are predefined for parts of the UI and are not used as normal styles.
    # Styles 38 and 39 are for future use.
    STYLE_DEFAULT = 32
    STYLE_LINENUMBER = 33
    STYLE_BRACELIGHT = 34
    STYLE_BRACEBAD = 35
    STYLE_CONTROLCHAR = 36
    STYLE_INDENTGUIDE = 37
    STYLE_LASTPREDEFINED = 39
    STYLE_MAX = 127

    # Character set identifiers are used in StyleSetCharacterSet.
    # The values are the same as the Windows *_CHARSET values.
    SC_CHARSET_ANSI = 0
    SC_CHARSET_DEFAULT = 1
    SC_CHARSET_BALTIC = 186
    SC_CHARSET_CHINESEBIG5 = 136
    SC_CHARSET_EASTEUROPE = 238
    SC_CHARSET_GB2312 = 134
    SC_CHARSET_GREEK = 161
    SC_CHARSET_HANGUL = 129
    SC_CHARSET_MAC = 77
    SC_CHARSET_OEM = 255
    SC_CHARSET_RUSSIAN = 204
    SC_CHARSET_SHIFTJIS = 128
    SC_CHARSET_SYMBOL = 2
    SC_CHARSET_TURKISH = 162
    SC_CHARSET_JOHAB = 130
    SC_CHARSET_HEBREW = 177
    SC_CHARSET_ARABIC = 178
    SC_CHARSET_VIETNAMESE = 163
    SC_CHARSET_THAI = 222

    # Clear all the styles and make equivalent to the global default style.
    def styleClearAll
      sendMessage(2050, 0, 0)
    end

    # Set the foreground colour of a style.
    def styleSetFore(style, fore)
      sendMessage(2051, style, fore & 0xffffff)
    end

    # Set the background colour of a style.
    def styleSetBack(style, back)
      sendMessage(2052, style, back & 0xffffff)
    end

    # Set a style to be bold or not.
    def styleSetBold(style, bold)
      sendMessage(2053, style, bold)
    end

    # Set a style to be italic or not.
    def styleSetItalic(style, italic)
      sendMessage(2054, style, italic)
    end

    # Set the size of characters of a style.
    def styleSetSize(style, sizePoints)
      sendMessage(2055, style, sizePoints)
    end

    # Set the font of a style.
    def styleSetFont(style, fontName)
      sendMessage(2056, style, fontName)
    end

    # Set a style to have its end of line filled or not.
    def styleSetEOLFilled(style, filled)
      sendMessage(2057, style, filled)
    end

    # Reset the default style to its state at startup
    def styleResetDefault
      sendMessage(2058, 0, 0)
    end

    # Set a style to be underlined or not.
    def styleSetUnderline(style, underline)
      sendMessage(2059, style, underline)
    end

    SC_CASE_MIXED = 0
    SC_CASE_UPPER = 1
    SC_CASE_LOWER = 2
    # Set a style to be mixed case, or to force upper or lower case.
    def styleSetCase(style, caseForce)
      sendMessage(2060, style, caseForce)
    end

    # Set the character set of the font in a style.
    def styleSetCharacterSet(style, characterSet)
      sendMessage(2066, style, characterSet)
    end

    # Set the foreground colour of the selection and whether to use this setting.
    def setSelFore(useSetting, fore)
      sendMessage(2067, useSetting, fore & 0xffffff)
    end

    # Set the background colour of the selection and whether to use this setting.
    def setSelBack(useSetting, back)
      sendMessage(2068, useSetting, back & 0xffffff)
    end

    # Set the foreground colour of the caret.
    def setCaretFore(fore)
      sendMessage(2069, fore & 0xffffff, 0)
    end

    # When key+modifier combination km is pressed perform msg.
    def assignCmdKey(km, msg)
      sendMessage(2070, km, msg)
    end

    # When key+modifier combination km do nothing.
    def clearCmdKey(km)
      sendMessage(2071, km, 0)
    end

    # Drop all key mappings.
    def clearAllCmdKeys
      sendMessage(2072, 0, 0)
    end

    # Set the styles for a segment of the document.
    def setStylingEx(length, styles)
      sendMessage(2073, length, styles)
    end

    # Set a style to be visible or not.
    def styleSetVisible(style, visible)
      sendMessage(2074, style, visible)
    end

    # Get the time in milliseconds that the caret is on and off.
    def getCaretPeriod
      sendMessage(2075, 0, 0)
    end

    # Get the time in milliseconds that the caret is on and off. 0 = steady on.
    def setCaretPeriod(periodMilliseconds)
      sendMessage(2076, periodMilliseconds, 0)
    end

    # Set the set of characters making up words for when moving or selecting by word.
    def setWordChars(characters)
      sendMessage(2077, 0, characters)
    end

    # Start a sequence of actions that is undone and redone as a unit.
    # May be nested.
    def beginUndoAction
      sendMessage(2078, 0, 0)
    end

    # End a sequence of actions that is undone and redone as a unit.
    def endUndoAction
      sendMessage(2079, 0, 0)
    end

    INDIC_MAX = 7
    INDIC_PLAIN = 0
    INDIC_SQUIGGLE = 1
    INDIC_TT = 2
    INDIC_DIAGONAL = 3
    INDIC_STRIKE = 4
    INDIC0_MASK = 0x20
    INDIC1_MASK = 0x40
    INDIC2_MASK = 0x80
    INDICS_MASK = 0xE0

    # Set an indicator to plain, squiggle or TT.
    def indicSetStyle(indic, style)
      sendMessage(2080, indic, style)
    end

    # Retrieve the style of an indicator.
    def indicGetStyle(indic)
      sendMessage(2081, indic, 0)
    end

    # Set the foreground colour of an indicator.
    def indicSetFore(indic, fore)
      sendMessage(2082, indic, fore & 0xffffff)
    end

    # Retrieve the foreground colour of an indicator.
    def indicGetFore(indic)
      sendMessage(2083, indic, 0)
    end

    # Set the foreground colour of all whitespace and whether to use this setting.
    def setWhitespaceFore(useSetting, fore)
      sendMessage(2084, useSetting, fore & 0xffffff)
    end

    # Set the background colour of all whitespace and whether to use this setting.
    def setWhitespaceBack(useSetting, back)
      sendMessage(2085, useSetting, back & 0xffffff)
    end

    # Divide each styling byte into lexical class bits (default: 5) and indicator
    # bits (default: 3). If a lexer requires more than 32 lexical states, then this
    # is used to expand the possible states.
    def setStyleBits(bits)
      sendMessage(2090, bits, 0)
    end

    # Retrieve number of bits in style bytes used to hold the lexical state.
    def getStyleBits
      sendMessage(2091, 0, 0)
    end

    # Used to hold extra styling information for each line.
    def setLineState(line, state)
      sendMessage(2092, line, state)
    end

    # Retrieve the extra styling information for a line.
    def getLineState(line)
      sendMessage(2093, line, 0)
    end

    # Retrieve the last line number that has line state.
    def getMaxLineState
      sendMessage(2094, 0, 0)
    end

    # Is the background of the line containing the caret in a different colour?
    def getCaretLineVisible
      sendMessage(2095, 0, 0) == 1 ? true : false
    end

    # Display the background of the line containing the caret in a different colour.
    def setCaretLineVisible(show)
      sendMessage(2096, show, 0)
    end

    # Get the colour of the background of the line containing the caret.
    def getCaretLineBack
      sendMessage(2097, 0, 0)
    end

    # Set the colour of the background of the line containing the caret.
    def setCaretLineBack(back)
      sendMessage(2098, back & 0xffffff, 0)
    end

    # Set a style to be changeable or not (read only).
    # Experimental feature, currently buggy.
    def styleSetChangeable(style, changeable)
      sendMessage(2099, style, changeable)
    end

    # Display a auto-completion list.
    # The lenEntered parameter indicates how many characters before
    # the caret should be used to provide context.
    def autoCShow(lenEntered, itemList)
      sendMessage(2100, lenEntered, itemList)
    end

    # Remove the auto-completion list from the screen.
    def autoCCancel
      sendMessage(2101, 0, 0)
    end

    # Is there an auto-completion list visible?
    def autoCActive
      sendMessage(2102, 0, 0) == 1 ? true : false
    end

    # Retrieve the position of the caret when the auto-completion list was displayed.
    def autoCPosStart
      sendMessage(2103, 0, 0)
    end

    # User has selected an item so remove the list and insert the selection.
    def autoCComplete
      sendMessage(2104, 0, 0)
    end

    # Define a set of character that when typed cancel the auto-completion list.
    def autoCStops(characterSet)
      sendMessage(2105, 0, characterSet)
    end

    # Change the separator character in the string setting up an auto-completion list.
    # Default is space but can be changed if items contain space.
    def autoCSetSeparator(separatorCharacter)
      sendMessage(2106, separatorCharacter, 0)
    end

    # Retrieve the auto-completion list separator character.
    def autoCGetSeparator
      sendMessage(2107, 0, 0)
    end

    # Select the item in the auto-completion list that starts with a string.
    def autoCSelect(text)
      sendMessage(2108, 0, text)
    end

    # Should the auto-completion list be cancelled if the user backspaces to a
    # position before where the box was created.
    def autoCSetCancelAtStart(cancel)
      sendMessage(2110, cancel, 0)
    end

    # Retrieve whether auto-completion cancelled by backspacing before start.
    def autoCGetCancelAtStart
      sendMessage(2111, 0, 0) == 1 ? true : false
    end

    # Define a set of characters that when typed will cause the autocompletion to
    # choose the selected item.
    def autoCSetFillUps(characterSet)
      sendMessage(2112, 0, characterSet)
    end

    # Should a single item auto-completion list automatically choose the item.
    def autoCSetChooseSingle(chooseSingle)
      sendMessage(2113, chooseSingle, 0)
    end

    # Retrieve whether a single item auto-completion list automatically choose the item.
    def autoCGetChooseSingle
      sendMessage(2114, 0, 0) == 1 ? true : false
    end

    # Set whether case is significant when performing auto-completion searches.
    def autoCSetIgnoreCase(ignoreCase)
      sendMessage(2115, ignoreCase, 0)
    end

    # Retrieve state of ignore case flag.
    def autoCGetIgnoreCase
      sendMessage(2116, 0, 0) == 1 ? true : false
    end

    # Display a list of strings and send notification when user chooses one.
    def userListShow(listType, itemList)
      sendMessage(2117, listType, itemList)
    end

    # Set whether or not autocompletion is hidden automatically when nothing matches.
    def autoCSetAutoHide(autoHide)
      sendMessage(2118, autoHide, 0)
    end

    # Retrieve whether or not autocompletion is hidden automatically when nothing matches.
    def autoCGetAutoHide
      sendMessage(2119, 0, 0) == 1 ? true : false
    end

    # Set whether or not autocompletion deletes any word characters
    # after the inserted text upon completion.
    def autoCSetDropRestOfWord(dropRestOfWord)
      sendMessage(2270, dropRestOfWord, 0)
    end

    # Retrieve whether or not autocompletion deletes any word characters
    # after the inserted text upon completion.
    def autoCGetDropRestOfWord
      sendMessage(2271, 0, 0) == 1 ? true : false
    end

    # Register an XPM image for use in autocompletion lists.
    def registerImage(type, xpmData)
      sendMessage(2405, type, xpmData)
    end

    # Clear all the registered XPM images.
    def clearRegisteredImages
      sendMessage(2408, 0, 0)
    end

    # Retrieve the auto-completion list type-separator character.
    def autoCGetTypeSeparator
      sendMessage(2285, 0, 0)
    end

    # Change the type-separator character in the string setting up an auto-completion list.
    # Default is '?' but can be changed if items contain '?'.
    def autoCSetTypeSeparator(separatorCharacter)
      sendMessage(2286, separatorCharacter, 0)
    end

    # Set the number of spaces used for one level of indentation.
    def setIndent(indentSize)
      sendMessage(2122, indentSize, 0)
    end

    # Retrieve indentation size.
    def getIndent
      sendMessage(2123, 0, 0)
    end

    # Indentation will only use space characters if useTabs is false, otherwise
    # it will use a combination of tabs and spaces.
    def setUseTabs(useTabs)
      sendMessage(2124, useTabs, 0)
    end

    # Retrieve whether tabs will be used in indentation.
    def getUseTabs
      sendMessage(2125, 0, 0) == 1 ? true : false
    end

    # Change the indentation of a line to a number of columns.
    def setLineIndentation(line, indentSize)
      sendMessage(2126, line, indentSize)
    end

    # Retrieve the number of columns that a line is indented.
    def getLineIndentation(line)
      sendMessage(2127, line, 0)
    end

    # Retrieve the position before the first non indentation character on a line.
    def getLineIndentPosition(line)
      sendMessage(2128, line, 0)
    end

    # Retrieve the column number of a position, taking tab width into account.
    def getColumn(pos)
      sendMessage(2129, pos, 0)
    end

    # Show or hide the horizontal scroll bar.
    def setHScrollBar(show)
      sendMessage(2130, show, 0)
    end

    # Is the horizontal scroll bar visible?
    def getHScrollBar
      sendMessage(2131, 0, 0) == 1 ? true : false
    end

    # Show or hide indentation guides.
    def setIndentationGuides(show)
      sendMessage(2132, show, 0)
    end

    # Are the indentation guides visible?
    def getIndentationGuides
      sendMessage(2133, 0, 0) == 1 ? true : false
    end

    # Set the highlighted indentation guide column.
    # 0 = no highlighted guide.
    def setHighlightGuide(column)
      sendMessage(2134, column, 0)
    end

    # Get the highlighted indentation guide column.
    def getHighlightGuide
      sendMessage(2135, 0, 0)
    end

    # Get the position after the last visible characters on a line.
    def getLineEndPosition(line)
      sendMessage(2136, line, 0)
    end

    # Get the code page used to interpret the bytes of the document as characters.
    def getCodePage
      sendMessage(2137, 0, 0)
    end

    # Get the foreground colour of the caret.
    def getCaretFore
      sendMessage(2138, 0, 0)
    end

    # In palette mode?
    def getUsePalette
      sendMessage(2139, 0, 0) == 1 ? true : false
    end

    # In read-only mode?
    def getReadOnly
      sendMessage(2140, 0, 0) == 1 ? true : false
    end

    # Sets the position of the caret.
    def setCurrentPos(pos)
      sendMessage(2141, pos, 0)
    end

    # Sets the position that starts the selection - this becomes the anchor.
    def setSelectionStart(pos)
      sendMessage(2142, pos, 0)
    end

    # Returns the position at the start of the selection.
    def getSelectionStart
      sendMessage(2143, 0, 0)
    end

    # Sets the position that ends the selection - this becomes the currentPosition.
    def setSelectionEnd(pos)
      sendMessage(2144, pos, 0)
    end

    # Returns the position at the end of the selection.
    def getSelectionEnd
      sendMessage(2145, 0, 0)
    end

    # Sets the print magnification added to the point size of each style for printing.
    def setPrintMagnification(magnification)
      sendMessage(2146, magnification, 0)
    end

    # Returns the print magnification.
    def getPrintMagnification
      sendMessage(2147, 0, 0)
    end

    # PrintColourMode - use same colours as screen.
    SC_PRINT_NORMAL = 0
    # PrintColourMode - invert the light value of each style for printing.
    SC_PRINT_INVERTLIGHT = 1
    # PrintColourMode - force black text on white background for printing.
    SC_PRINT_BLACKONWHITE = 2
    # PrintColourMode - text stays coloured, but all background is forced to be white for printing.
    SC_PRINT_COLOURONWHITE = 3
    # PrintColourMode - only the default-background is forced to be white for printing.
    SC_PRINT_COLOURONWHITEDEFAULTBG = 4

    # Modify colours when printing for clearer printed text.
    def setPrintColourMode(mode)
      sendMessage(2148, mode, 0)
    end

    # Returns the print colour mode.
    def getPrintColourMode
      sendMessage(2149, 0, 0)
    end

    SCFIND_WHOLEWORD = 2
    SCFIND_MATCHCASE = 4
    SCFIND_WORDSTART = 0x00100000
    SCFIND_REGEXP = 0x00200000

    # Find some text in the document.
    def findText(flags, ft)
      sendMessage(2150, flags, ft)
    end

    # On Windows, will draw the document into a display context such as a printer.
    def formatRange(draw, fr)
      sendMessage(2151, draw, fr)
    end

    # Retrieve the display line at the top of the display.
    def getFirstVisibleLine
      sendMessage(2152, 0, 0)
    end

    # Retrieve the contents of a line.
    # Returns the length of the line.
    def getLine(line)
      buffer = "".ljust(line)
      sendMessage(2153, line, buffer)
      buffer
    end

    # Returns the number of lines in the document. There is always at least one.
    def getLineCount
      sendMessage(2154, 0, 0)
    end

    # Sets the size in pixels of the left margin.
    def setMarginLeft(pixelWidth)
      sendMessage(2155, 0, pixelWidth)
    end

    # Returns the size in pixels of the left margin.
    def getMarginLeft
      sendMessage(2156, 0, 0)
    end

    # Sets the size in pixels of the right margin.
    def setMarginRight(pixelWidth)
      sendMessage(2157, 0, pixelWidth)
    end

    # Returns the size in pixels of the right margin.
    def getMarginRight
      sendMessage(2158, 0, 0)
    end

    # Is the document different from when it was last saved?
    def getModify
      sendMessage(2159, 0, 0) == 1 ? true : false
    end

    # Select a range of text.
    def setSel(start, last)
      sendMessage(2160, start, last)
    end

    # Retrieve the selected text.
    # Return the length of the text.
    def getSelText
      sendMessage(2161, 0, text)
    end

    # Retrieve a range of text.
    # Return the length of the text.
    def getTextRange(tr)
      sendMessage(2162, 0, tr)
    end

    # Draw the selection in normal style or with selection highlighted.
    def hideSelection(normal)
      sendMessage(2163, normal, 0)
    end

    # Retrieve the x value of the point in the window where a position is displayed.
    def pointXFromPosition(pos)
      sendMessage(2164, 0, pos)
    end

    # Retrieve the y value of the point in the window where a position is displayed.
    def pointYFromPosition(pos)
      sendMessage(2165, 0, pos)
    end

    # Retrieve the line containing a position.
    def lineFromPosition(pos)
      sendMessage(2166, pos, 0)
    end

    # Retrieve the position at the start of a line.
    def positionFromLine(line)
      sendMessage(2167, line, 0)
    end

    # Scroll horizontally and vertically.
    def lineScroll(columns, lines)
      sendMessage(2168, columns, lines)
    end

    # Ensure the caret is visible.
    def scrollCaret
      sendMessage(2169, 0, 0)
    end

    # Replace the selected text with the argument text.
    def replaceSel(text)
      sendMessage(2170, 0, text)
    end

    # Set to read only or read write.
    def setReadOnly(readOnly)
      sendMessage(2171, readOnly, 0)
    end

    # Null operation.
    def null
      sendMessage(2172, 0, 0)
    end

    # Will a paste succeed?
    def canPaste
      sendMessage(2173, 0, 0) == 1 ? true : false
    end

    # Are there any undoable actions in the undo history?
    def canUndo
      sendMessage(2174, 0, 0) == 1 ? true : false
    end

    # Delete the undo history.
    def emptyUndoBuffer
      sendMessage(2175, 0, 0)
    end

    # Undo one action in the undo history.
    def undo
      sendMessage(2176, 0, 0)
    end

    # Cut the selection to the clipboard.
    def cut
      sendMessage(2177, 0, 0)
    end

    # Copy the selection to the clipboard.
    def copy
      sendMessage(2178, 0, 0)
    end

    # Paste the contents of the clipboard into the document replacing the selection.
    def paste
      sendMessage(2179, 0, 0)
    end

    # Clear the selection.
    def clear
      sendMessage(2180, 0, 0)
    end

    # Replace the contents of the document with the argument text.
    def setText(text)
      sendMessage(2181, 0, text)
    end

    # Retrieve all the text in the document.
    # Returns number of characters retrieved.
    def getText(length)
      buffer = "".ljust(length)
      sendMessage(2182, length, buffer)
      buffer
    end

    # Retrieve the number of characters in the document.
    def getTextLength
      sendMessage(2183, 0, 0)
    end

    # Retrieve a pointer to a function that processes messages for this Scintilla.
    def getDirectFunction
      sendMessage(2184, 0, 0)
    end

    # Retrieve a pointer value to use as the first argument when calling
    # the function returned by GetDirectFunction.
    def getDirectPointer
      sendMessage(2185, 0, 0)
    end

    # Set to overtype (true) or insert mode.
    def setOvertype(overtype)
      sendMessage(2186, overtype, 0)
    end

    # Returns true if overtype mode is active otherwise false is returned.
    def getOvertype
      sendMessage(2187, 0, 0) == 1 ? true : false
    end

    # Set the width of the insert mode caret.
    def setCaretWidth(pixelWidth)
      sendMessage(2188, pixelWidth, 0)
    end

    # Returns the width of the insert mode caret.
    def getCaretWidth
      sendMessage(2189, 0, 0)
    end

    # Sets the position that starts the target which is used for updating the
    # document without affecting the scroll position.
    def setTargetStart(pos)
      sendMessage(2190, pos, 0)
    end

    # Get the position that starts the target.
    def getTargetStart
      sendMessage(2191, 0, 0)
    end

    # Sets the position that ends the target which is used for updating the
    # document without affecting the scroll position.
    def setTargetEnd(pos)
      sendMessage(2192, pos, 0)
    end

    # Get the position that ends the target.
    def getTargetEnd
      sendMessage(2193, 0, 0)
    end

    # Replace the target text with the argument text.
    # Text is counted so it can contain nulls.
    # Returns the length of the replacement text.
    def replaceTarget(length, text)
      sendMessage(2194, length, text)
    end

    # Replace the target text with the argument text after \d processing.
    # Text is counted so it can contain nulls.
    # Looks for \d where d is between 1 and 9 and replaces these with the strings
    # matched in the last search operation which were surrounded by \( and \).
    # Returns the length of the replacement text including any change
    # caused by processing the \d patterns.
    def replaceTargetRE(length, text)
      sendMessage(2195, length, text)
    end

    # Search for a counted string in the target and set the target to the found
    # range. Text is counted so it can contain nulls.
    # Returns length of range or -1 for failure in which case target is not moved.
    def searchInTarget(length, text)
      sendMessage(2197, length, text)
    end

    # Set the search flags used by SearchInTarget.
    def setSearchFlags(flags)
      sendMessage(2198, flags, 0)
    end

    # Get the search flags used by SearchInTarget.
    def getSearchFlags
      sendMessage(2199, 0, 0)
    end

    # Show a call tip containing a definition near position pos.
    def callTipShow(pos, definition)
      sendMessage(2200, pos, definition)
    end

    # Remove the call tip from the screen.
    def callTipCancel
      sendMessage(2201, 0, 0)
    end

    # Is there an active call tip?
    def callTipActive
      sendMessage(2202, 0, 0) == 1 ? true : false
    end

    # Retrieve the position where the caret was before displaying the call tip.
    def callTipPosStart
      sendMessage(2203, 0, 0)
    end

    # Highlight a segment of the definition.
    def callTipSetHlt(start, last)
      sendMessage(2204, start, last)
    end

    # Set the background colour for the call tip.
    def callTipSetBack(back)
      sendMessage(2205, back & 0xffffff, 0)
    end

    # Find the display line of a document line taking hidden lines into account.
    def visibleFromDocLine(line)
      sendMessage(2220, line, 0)
    end

    # Find the document line of a display line taking hidden lines into account.
    def docLineFromVisible(lineDisplay)
      sendMessage(2221, lineDisplay, 0)
    end

    SC_FOLDLEVELBASE = 0x400
    SC_FOLDLEVELWHITEFLAG = 0x1000
    SC_FOLDLEVELHEADERFLAG = 0x2000
    SC_FOLDLEVELBOXHEADERFLAG = 0x4000
    SC_FOLDLEVELBOXFOOTERFLAG = 0x8000
    SC_FOLDLEVELCONTRACTED = 0x10000
    SC_FOLDLEVELUNINDENT = 0x20000
    SC_FOLDLEVELNUMBERMASK = 0x0FFF

    # Set the fold level of a line.
    # This encodes an integer level along with flags indicating whether the
    # line is a header and whether it is effectively white space.
    def setFoldLevel(line, level)
      sendMessage(2222, line, level)
    end

    # Retrieve the fold level of a line.
    def getFoldLevel(line)
      sendMessage(2223, line, 0)
    end

    # Find the last child line of a header line.
    def getLastChild(line, level)
      sendMessage(2224, line, level)
    end

    # Find the parent line of a child line.
    def getFoldParent(line)
      sendMessage(2225, line, 0)
    end

    # Make a range of lines visible.
    def showLines(lineStart, lineEnd)
      sendMessage(2226, lineStart, lineEnd)
    end

    # Make a range of lines invisible.
    def hideLines(lineStart, lineEnd)
      sendMessage(2227, lineStart, lineEnd)
    end

    # Is a line visible?
    def getLineVisible(line)
      sendMessage(2228, line, 0) == 1 ? true : false
    end

    # Show the children of a header line.
    def setFoldExpanded(line, expanded)
      sendMessage(2229, line, expanded)
    end

    # Is a header line expanded?
    def getFoldExpanded(line)
      sendMessage(2230, line, 0) == 1 ? true : false
    end

    # Switch a header line between expanded and contracted.
    def toggleFold(line)
      sendMessage(2231, line, 0)
    end

    # Ensure a particular line is visible by expanding any header line hiding it.
    def ensureVisible(line)
      sendMessage(2232, line, 0)
    end

    SC_FOLDFLAG_LINEBEFORE_EXPANDED = 0x0002
    SC_FOLDFLAG_LINEBEFORE_CONTRACTED = 0x0004
    SC_FOLDFLAG_LINEAFTER_EXPANDED = 0x0008
    SC_FOLDFLAG_LINEAFTER_CONTRACTED = 0x0010
    SC_FOLDFLAG_LEVELNUMBERS = 0x0040
    SC_FOLDFLAG_BOX = 0x0001

    # Set some style options for folding.
    def setFoldFlags(flags)
      sendMessage(2233, flags, 0)
    end

    # Ensure a particular line is visible by expanding any header line hiding it.
    # Use the currently set visibility policy to determine which range to display.
    def ensureVisibleEnforcePolicy(line)
      sendMessage(2234, line, 0)
    end

    # Sets whether a tab pressed when caret is within indentation indents.
    def setTabIndents(tabIndents)
      sendMessage(2260, tabIndents, 0)
    end

    # Does a tab pressed when caret is within indentation indent?
    def getTabIndents
      sendMessage(2261, 0, 0) == 1 ? true : false
    end

    # Sets whether a backspace pressed when caret is within indentation unindents.
    def setBackSpaceUnIndents(bsUnIndents)
      sendMessage(2262, bsUnIndents, 0)
    end

    # Does a backspace pressed when caret is within indentation unindent?
    def getBackSpaceUnIndents
      sendMessage(2263, 0, 0) == 1 ? true : false
    end

    SC_TIME_FOREVER = 10000000

    # Sets the time the mouse must sit still to generate a mouse dwell event.
    def setMouseDwellTime(periodMilliseconds)
      sendMessage(2264, periodMilliseconds, 0)
    end

    # Retrieve the time the mouse must sit still to generate a mouse dwell event.
    def getMouseDwellTime
      sendMessage(2265, 0, 0)
    end

    # Get position of start of word.
    def wordStartPosition(pos, onlyWordCharacters)
      sendMessage(2266, pos, onlyWordCharacters)
    end

    # Get position of end of word.
    def wordEndPosition(pos, onlyWordCharacters)
      sendMessage(2267, pos, onlyWordCharacters)
    end

    SC_WRAP_NONE = 0
    SC_WRAP_WORD = 1

    # Sets whether text is word wrapped.
    def setWrapMode(mode)
      sendMessage(2268, mode, 0)
    end

    # Retrieve whether text is word wrapped.
    def getWrapMode
      sendMessage(2269, 0, 0)
    end

    SC_CACHE_NONE = 0
    SC_CACHE_CARET = 1
    SC_CACHE_PAGE = 2
    SC_CACHE_DOCUMENT = 3

    # Sets the degree of caching of layout information.
    def setLayoutCache(mode)
      sendMessage(2272, mode, 0)
    end

    # Retrieve the degree of caching of layout information.
    def getLayoutCache
      sendMessage(2273, 0, 0)
    end

    # Sets the document width assumed for scrolling.
    def setScrollWidth(pixelWidth)
      sendMessage(2274, pixelWidth, 0)
    end

    # Retrieve the document width assumed for scrolling.
    def getScrollWidth
      sendMessage(2275, 0, 0)
    end

    # Measure the pixel width of some text in a particular style.
    # Nul terminated text argument.
    # Does not handle tab or control characters.
    def textWidth(style, text)
      sendMessage(2276, style, text)
    end

    # Sets the scroll range so that maximum scroll position has
    # the last line at the bottom of the view (default).
    # Setting this to false allows scrolling one page below the last line.
    def setEndAtLastLine(endAtLastLine)
      sendMessage(2277, endAtLastLine, 0)
    end

    # Retrieve whether the maximum scroll position has the last
    # line at the bottom of the view.
    def getEndAtLastLine
      sendMessage(2278, 0, 0)
    end

    # Retrieve the height of a particular line of text in pixels.
    def textHeight(line)
      sendMessage(2279, line, 0)
    end

    # Show or hide the vertical scroll bar.
    def setVScrollBar(show)
      sendMessage(2280, show, 0)
    end

    # Is the vertical scroll bar visible?
    def getVScrollBar
      sendMessage(2281, 0, 0) == 1 ? true : false
    end

    # Append a string to the end of the document without changing the selection.
    def appendText(length, text)
      sendMessage(2282, length, text)
    end

    # Is drawing done in two phases with backgrounds drawn before faoregrounds?
    def getTwoPhaseDraw
      sendMessage(2283, 0, 0) == 1 ? true : false
    end

    # In twoPhaseDraw mode, drawing is performed in two phases, first the background
    # and then the foreground. This avoids chopping off characters that overlap the next run.
    def setTwoPhaseDraw(twoPhase)
      sendMessage(2284, twoPhase, 0)
    end

    # Make the target range start and end be the same as the selection range start and end.
    def targetFromSelection
      sendMessage(2287, 0, 0)
    end

    # Join the lines in the target.
    # This is an experimental feature and may be changed or removed.
    def linesJoin
      sendMessage(2288, 0, 0)
    end

    # Split the lines in the target into lines that are less wide than pixelWidth
    # where possible.
    def linesSplit(pixelWidth)
      sendMessage(2289, pixelWidth, 0)
    end

    # Set the colours used as a chequerboard pattern in the fold margin
    def setFoldMarginColour(useSetting, back)
      sendMessage(2290, useSetting, back & 0xffffff)
    end
    def setFoldMarginHiColour(useSetting, fore)
      sendMessage(2291, useSetting, fore & 0xffffff)
    end


    # Move caret down one line.
    def lineDown
      sendMessage(2300, 0, 0)
    end

    # Move caret down one line extending selection to new caret position.
    def lineDownExtend
      sendMessage(2301, 0, 0)
    end

    # Move caret up one line.
    def lineUp
      sendMessage(2302, 0, 0)
    end

    # Move caret up one line extending selection to new caret position.
    def lineUpExtend
      sendMessage(2303, 0, 0)
    end

    # Move caret left one character.
    def charLeft
      sendMessage(2304, 0, 0)
    end

    # Move caret left one character extending selection to new caret position.
    def charLeftExtend
      sendMessage(2305, 0, 0)
    end

    # Move caret right one character.
    def charRight
      sendMessage(2306, 0, 0)
    end

    # Move caret right one character extending selection to new caret position.
    def charRightExtend
      sendMessage(2307, 0, 0)
    end

    # Move caret left one word.
    def wordLeft
      sendMessage(2308, 0, 0)
    end

    # Move caret left one word extending selection to new caret position.
    def wordLeftExtend
      sendMessage(2309, 0, 0)
    end

    # Move caret right one word.
    def wordRight
      sendMessage(2310, 0, 0)
    end

    # Move caret right one word extending selection to new caret position.
    def wordRightExtend
      sendMessage(2311, 0, 0)
    end

    # Move caret to first position on line.
    def home
      sendMessage(2312, 0, 0)
    end

    # Move caret to first position on line extending selection to new caret position.
    def homeExtend
      sendMessage(2313, 0, 0)
    end

    # Move caret to last position on line.
    def lineEnd
      sendMessage(2314, 0, 0)
    end

    # Move caret to last position on line extending selection to new caret position.
    def lineEndExtend
      sendMessage(2315, 0, 0)
    end

    # Move caret to first position in document.
    def documentStart
      sendMessage(2316, 0, 0)
    end

    # Move caret to first position in document extending selection to new caret position.
    def documentStartExtend
      sendMessage(2317, 0, 0)
    end

    # Move caret to last position in document.
    def documentEnd
      sendMessage(2318, 0, 0)
    end

    # Move caret to last position in document extending selection to new caret position.
    def documentEndExtend
      sendMessage(2319, 0, 0)
    end

    # Move caret one page up.
    def pageUp
      sendMessage(2320, 0, 0)
    end

    # Move caret one page up extending selection to new caret position.
    def pageUpExtend
      sendMessage(2321, 0, 0)
    end

    # Move caret one page down.
    def pageDown
      sendMessage(2322, 0, 0)
    end

    # Move caret one page down extending selection to new caret position.
    def pageDownExtend
      sendMessage(2323, 0, 0)
    end

    # Switch from insert to overtype mode or the reverse.
    def editToggleOvertype
      sendMessage(2324, 0, 0)
    end

    # Cancel any modes such as call tip or auto-completion list display.
    def cancel
      sendMessage(2325, 0, 0)
    end

    # Delete the selection or if no selection, the character before the caret.
    def deleteBack
      sendMessage(2326, 0, 0)
    end

    # If selection is empty or all on one line replace the selection with a tab character.
    # If more than one line selected, indent the lines.
    def tab
      sendMessage(2327, 0, 0)
    end

    # Dedent the selected lines.
    def backTab
      sendMessage(2328, 0, 0)
    end

    # Insert a new line, may use a CRLF, CR or LF depending on EOL mode.
    def newLine
      sendMessage(2329, 0, 0)
    end

    # Insert a Form Feed character.
    def formFeed
      sendMessage(2330, 0, 0)
    end

    # Move caret to before first visible character on line.
    # If already there move to first character on line.
    def vCHome
      sendMessage(2331, 0, 0)
    end

    # Like VCHome but extending selection to new caret position.
    def vCHomeExtend
      sendMessage(2332, 0, 0)
    end

    # Magnify the displayed text by increasing the sizes by 1 point.
    def zoomIn
      sendMessage(2333, 0, 0)
    end

    # Make the displayed text smaller by decreasing the sizes by 1 point.
    def zoomOut
      sendMessage(2334, 0, 0)
    end

    # Delete the word to the left of the caret.
    def delWordLeft
      sendMessage(2335, 0, 0)
    end

    # Delete the word to the right of the caret.
    def delWordRight
      sendMessage(2336, 0, 0)
    end

    # Cut the line containing the caret.
    def lineCut
      sendMessage(2337, 0, 0)
    end

    # Delete the line containing the caret.
    def lineDelete
      sendMessage(2338, 0, 0)
    end

    # Switch the current line with the previous.
    def lineTranspose
      sendMessage(2339, 0, 0)
    end

    # Duplicate the current line.
    def lineDuplicate
      sendMessage(2404, 0, 0)
    end

    # Transform the selection to lower case.
    def lowerCase
      sendMessage(2340, 0, 0)
    end

    # Transform the selection to upper case.
    def upperCase
      sendMessage(2341, 0, 0)
    end

    # Scroll the document down, keeping the caret visible.
    def lineScrollDown
      sendMessage(2342, 0, 0)
    end

    # Scroll the document up, keeping the caret visible.
    def lineScrollUp
      sendMessage(2343, 0, 0)
    end

    # Delete the selection or if no selection, the character before the caret.
    # Will not delete the character before at the start of a line.
    def deleteBackNotLine
      sendMessage(2344, 0, 0)
    end

    # Move caret to first position on display line.
    def homeDisplay
      sendMessage(2345, 0, 0)
    end

    # Move caret to first position on display line extending selection to
    # new caret position.
    def homeDisplayExtend
      sendMessage(2346, 0, 0)
    end

    # Move caret to last position on display line.
    def lineEndDisplay
      sendMessage(2347, 0, 0)
    end

    # Move caret to last position on display line extending selection to new
    # caret position.
    def lineEndDisplayExtend
      sendMessage(2348, 0, 0)
    end

    # Move the caret inside current view if it's not there already.
    def moveCaretInsideView
      sendMessage(2401, 0, 0)
    end

    # How many characters are on a line, not including end of line characters?
    def lineLength(line)
      sendMessage(2350, line, 0)
    end

    # Highlight the characters at two positions.
    def braceHighlight(pos1, pos2)
      sendMessage(2351, pos1, pos2)
    end

    # Highlight the character at a position indicating there is no matching brace.
    def braceBadLight(pos)
      sendMessage(2352, pos, 0)
    end

    # Find the position of a matching brace or INVALID_POSITION if no match.
    def braceMatch(pos)
      sendMessage(2353, pos, 0)
    end

    # Are the end of line characters visible?
    def getViewEOL
      sendMessage(2355, 0, 0) == 1 ? true : false
    end

    # Make the end of line characters visible or invisible.
    def setViewEOL(visible)
      sendMessage(2356, visible, 0)
    end

    # Retrieve a pointer to the document object.
    def getDocPointer
      sendMessage(2357, 0, 0)
    end

    # Change the document object used.
    def setDocPointer(pointer)
      sendMessage(2358, 0, pointer)
    end

    # Set which document modification events are sent to the container.
    def setModEventMask(mask)
      sendMessage(2359, mask, 0)
    end

    EDGE_NONE = 0
    EDGE_LINE = 1
    EDGE_BACKGROUND = 2

    # Retrieve the column number which text should be kept within.
    def getEdgeColumn
      sendMessage(2360, 0, 0)
    end

    # Set the column number of the edge.
    # If text goes past the edge then it is highlighted.
    def setEdgeColumn(column)
      sendMessage(2361, column, 0)
    end

    # Retrieve the edge highlight mode.
    def getEdgeMode
      sendMessage(2362, 0, 0)
    end

    # The edge may be displayed by a line (EDGE_LINE) or by highlighting text that
    # goes beyond it (EDGE_BACKGROUND) or not displayed at all (EDGE_NONE).
    def setEdgeMode(mode)
      sendMessage(2363, mode, 0)
    end

    # Retrieve the colour used in edge indication.
    def getEdgeColour
      sendMessage(2364, 0, 0)
    end

    # Change the colour used in edge indication.
    def setEdgeColour(edgeColour)
      sendMessage(2365, edgeColour & 0xffffff, 0)
    end

    # Sets the current caret position to be the search anchor.
    def searchAnchor
      sendMessage(2366, 0, 0)
    end

    # Find some text starting at the search anchor.
    # Does not ensure the selection is visible.
    def searchNext(flags, text)
      sendMessage(2367, flags, text)
    end

    # Find some text starting at the search anchor and moving backwards.
    # Does not ensure the selection is visible.
    def searchPrev(flags, text)
      sendMessage(2368, flags, text)
    end

    # Retrieves the number of lines completely visible.
    def linesOnScreen
      sendMessage(2370, 0, 0)
    end

    # Set whether a pop up menu is displayed automatically when the user presses
    # the wrong mouse button.
    def usePopUp(allowPopUp)
      sendMessage(2371, allowPopUp, 0)
    end

    # Is the selection rectangular? The alternative is the more common stream selection.
    def selectionIsRectangle
      sendMessage(2372, 0, 0) == 1 ? true : false
    end

    # Set the zoom level. This number of points is added to the size of all fonts.
    # It may be positive to magnify or negative to reduce.
    def setZoom(zoom)
      sendMessage(2373, zoom, 0)
    end
    # Retrieve the zoom level.
    def getZoom
      sendMessage(2374, 0, 0)
    end

    # Create a new document object.
    # Starts with reference count of 1 and not selected into editor.
    def createDocument
      sendMessage(2375, 0, 0)
    end
    # Extend life of document.
    def addRefDocument(doc)
      sendMessage(2376, 0, doc)
    end
    # Release a reference to the document, deleting document if it fades to black.
    def releaseDocument(doc)
      sendMessage(2377, 0, doc)
    end

    # Get which document modification events are sent to the container.
    def getModEventMask
      sendMessage(2378, 0, 0)
    end

    # Change internal focus flag.
    def setFocusFlag(focus)
      sendMessage(2380, focus, 0)
    end
    # Get internal focus flag.
    def getFocus
      sendMessage(2381, 0, 0) == 1 ? true : false
    end

    # Change error status - 0 = OK.
    def setStatus(statusCode)
      sendMessage(2382, statusCode, 0)
    end
    # Get error status.
    def getStatus
      sendMessage(2383, 0, 0)
    end

    # Set whether the mouse is captured when its button is pressed.
    def setMouseDownCaptures(captures)
      sendMessage(2384, captures, 0)
    end
    # Get whether mouse gets captured.
    def getMouseDownCaptures
      sendMessage(2385, 0, 0) == 1 ? true : false
    end

    SC_CURSORNORMAL = -1
    SC_CURSORWAIT = 4
    # Sets the cursor to one of the SC_CURSOR* values.
    def setCursor(cursorType)
      sendMessage(2386, cursorType, 0)
    end
    # Get cursor type.
    def getCursor
      sendMessage(2387, 0, 0)
    end

    # Change the way control characters are displayed:
    # If symbol is < 32, keep the drawn way, else, use the given character.
    def setControlCharSymbol(symbol)
      sendMessage(2388, symbol, 0)
    end
    # Get the way control characters are displayed.
    def getControlCharSymbol
      sendMessage(2389, 0, 0)
    end

    # Move to the previous change in capitalisation.
    def wordPartLeft
      sendMessage(2390, 0, 0)
    end
    # Move to the previous change in capitalisation extending selection
    # to new caret position.
    def wordPartLeftExtend
      sendMessage(2391, 0, 0)
    end
    # Move to the change next in capitalisation.
    def wordPartRight
      sendMessage(2392, 0, 0)
    end
    # Move to the next change in capitalisation extending selection
    # to new caret position.
    def wordPartRightExtend
      sendMessage(2393, 0, 0)
    end

    # Constants for use with SetVisiblePolicy, similar to SetCaretPolicy.
    VISIBLE_SLOP = 0x01
    VISIBLE_STRICT = 0x04
    # Set the way the display area is determined when a particular line
    # is to be moved to by Find, FindNext, GotoLine, etc.
    def setVisiblePolicy(visiblePolicy, visibleSlop)
      sendMessage(2394, visiblePolicy, visibleSlop)
    end

    # Delete back from the current position to the start of the line.
    def delLineLeft
      sendMessage(2395, 0, 0)
    end

    # Delete forwards from the current position to the end of the line.
    def delLineRight
      sendMessage(2396, 0, 0)
    end

    # Get and Set the xOffset (ie, horizonal scroll position).
    def setXOffset(newOffset)
      sendMessage(2397, newOffset, 0)
    end
    def getXOffset
      sendMessage(2398, 0, 0)
    end

    # Set the last x chosen value to be the caret x position
    def chooseCaretX
      sendMessage(2399, 0, 0)
    end

    # Set the focus to this Scintilla widget.
    # GTK+ Specific.
    def grabFocus
      sendMessage(2400, 0, 0)
    end

    # Caret policy, used by SetXCaretPolicy and SetYCaretPolicy.
    # If CARET_SLOP is set, we can define a slop value: caretSlop.
    # This value defines an unwanted zone (UZ) where the caret is... unwanted.
    # This zone is defined as a number of pixels near the vertical margins,
    # and as a number of lines near the horizontal margins.
    # By keeping the caret away from the edges, it is seen within its context,
    # so it is likely that the identifier that the caret is on can be completely seen,
    # and that the current line is seen with some of the lines following it which are
    # often dependent on that line.
    CARET_SLOP = 0x01
    # If CARET_STRICT is set, the policy is enforced... strictly.
    # The caret is centred on the display if slop is not set,
    # and cannot go in the UZ if slop is set.
    CARET_STRICT = 0x04
    # If CARET_JUMPS is set, the display is moved more energetically
    # so the caret can move in the same direction longer before the policy is applied again.
    CARET_JUMPS = 0x10
    # If CARET_EVEN is not set, instead of having symmetrical UZs,
    # the left and bottom UZs are extended up to right and top UZs respectively.
    # This way, we favour the displaying of useful information: the begining of lines,
    # where most code reside, and the lines after the caret, eg. the body of a function.
    CARET_EVEN = 0x08

    # Set the way the caret is kept visible when going sideway.
    # The exclusion zone is given in pixels.
    def setXCaretPolicy(caretPolicy, caretSlop)
      sendMessage(2402, caretPolicy, caretSlop)
    end

    # Set the way the line the caret is on is kept visible.
    # The exclusion zone is given in lines.
    def setYCaretPolicy(caretPolicy, caretSlop)
      sendMessage(2403, caretPolicy, caretSlop)
    end

    # Set printing to line wrapped (SC_WRAP_WORD) or not line wrapped (SC_WRAP_NONE).
    def setPrintWrapMode(mode)
      sendMessage(2406, mode, 0)
    end

    # Is printing line wrapped.
    def getPrintWrapMode
      sendMessage(2407, 0, 0)
    end

    # Start notifying the container of all key presses and commands.
    def startRecord
      sendMessage(3001, 0, 0)
    end

    # Stop notifying the container of all key presses and commands.
    def stopRecord
      sendMessage(3002, 0, 0)
    end

    # Set the lexing language of the document.
    def setLexer(lexer)
      sendMessage(4001, lexer, 0)
    end

    # Retrieve the lexing language of the document.
    def getLexer
      sendMessage(4002, 0, 0)
    end

    # Colourise a segment of the document using the current lexing language.
    def colourise(start, last)
      sendMessage(4003, start, last)
    end

    # Set up a value that may be used by a lexer for some optional feature.
    def setProperty(key, value)
      sendMessage(4004, key, value)
    end

    # Set up the key words used by the lexer.
    def setKeyWords(keywordSet, keyWords)
      sendMessage(4005, keywordSet, keyWords)
    end

    # Set the lexing language of the document based on string name.
    def setLexerLanguage(language)
      sendMessage(4006, 0, language)
    end

    # Notifications
    # Type of modification and the action which caused the modification.
    # These are defined as a bit mask to make it easy to specify which notifications are wanted.
    # One bit is set from each of SC_MOD_* and SC_PERFORMED_*.
    SC_MOD_INSERTTEXT = 0x1
    SC_MOD_DELETETEXT = 0x2
    SC_MOD_CHANGESTYLE = 0x4
    SC_MOD_CHANGEFOLD = 0x8
    SC_PERFORMED_USER = 0x10
    SC_PERFORMED_UNDO = 0x20
    SC_PERFORMED_REDO = 0x40
    SC_LASTSTEPINUNDOREDO = 0x100
    SC_MOD_CHANGEMARKER = 0x200
    SC_MOD_BEFOREINSERT = 0x400
    SC_MOD_BEFOREDELETE = 0x800
    SC_MODEVENTMASKALL = 0xF77

    # For compatibility, these go through the COMMAND notification rather than NOTIFY
    # and should have had exactly the same values as the EN_* constants.
    # Unfortunately the SETFOCUS and KILLFOCUS are flipped over from EN_*
    # As clients depend on these constants, this will not be changed.
    SCEN_CHANGE = 768
    SCEN_SETFOCUS = 512
    SCEN_KILLFOCUS = 256

    # Symbolic key codes and modifier flags.
    # ASCII and other printable characters below 256.
    # Extended keys above 300.

    SCK_DOWN = 300
    SCK_UP = 301
    SCK_LEFT = 302
    SCK_RIGHT = 303
    SCK_HOME = 304
    SCK_END = 305
    SCK_PRIOR = 306
    SCK_NEXT = 307
    SCK_DELETE = 308
    SCK_INSERT = 309
    SCK_ESCAPE = 7
    SCK_BACK = 8
    SCK_TAB = 9
    SCK_RETURN = 13
    SCK_ADD = 310
    SCK_SUBTRACT = 311
    SCK_DIVIDE = 312

    SCMOD_SHIFT = 1
    SCMOD_CTRL = 2
    SCMOD_ALT = 4

    # For SciLexer.h
    SCLEX_CONTAINER = 0
    SCLEX_NULL = 1
    SCLEX_PYTHON = 2
    SCLEX_CPP = 3
    SCLEX_HTML = 4
    SCLEX_XML = 5
    SCLEX_PERL = 6
    SCLEX_SQL = 7
    SCLEX_VB = 8
    SCLEX_PROPERTIES = 9
    SCLEX_ERRORLIST = 10
    SCLEX_MAKEFILE = 11
    SCLEX_BATCH = 12
    SCLEX_XCODE = 13
    SCLEX_LATEX = 14
    SCLEX_LUA = 15
    SCLEX_DIFF = 16
    SCLEX_CONF = 17
    SCLEX_PASCAL = 18
    SCLEX_AVE = 19
    SCLEX_ADA = 20
    SCLEX_LISP = 21
    SCLEX_RUBY = 22
    SCLEX_EIFFEL = 23
    SCLEX_EIFFELKW = 24
    SCLEX_TCL = 25
    SCLEX_NNCRONTAB = 26
    SCLEX_BULLANT = 27
    SCLEX_VBSCRIPT = 28
    SCLEX_ASP = 29
    SCLEX_PHP = 30
    SCLEX_BAAN = 31
    SCLEX_MATLAB = 32
    SCLEX_SCRIPTOL = 33
    SCLEX_ASM = 34
    SCLEX_CPPNOCASE = 35
    SCLEX_FORTRAN = 36
    SCLEX_F77 = 37
    SCLEX_CSS = 38

    # When a lexer specifies its language as SCLEX_AUTOMATIC it receives a
    # value assigned in sequence from SCLEX_AUTOMATIC+1.
    SCLEX_AUTOMATIC = 1000
    # Lexical states for SCLEX_PYTHON
    SCE_P_DEFAULT = 0
    SCE_P_COMMENTLINE = 1
    SCE_P_NUMBER = 2
    SCE_P_STRING = 3
    SCE_P_CHARACTER = 4
    SCE_P_WORD = 5
    SCE_P_TRIPLE = 6
    SCE_P_TRIPLEDOUBLE = 7
    SCE_P_CLASSNAME = 8
    SCE_P_DEFNAME = 9
    SCE_P_OPERATOR = 10
    SCE_P_IDENTIFIER = 11
    SCE_P_COMMENTBLOCK = 12
    SCE_P_STRINGEOL = 13
    # Lexical states for SCLEX_CPP
    SCE_C_DEFAULT = 0
    SCE_C_COMMENT = 1
    SCE_C_COMMENTLINE = 2
    SCE_C_COMMENTDOC = 3
    SCE_C_NUMBER = 4
    SCE_C_WORD = 5
    SCE_C_STRING = 6
    SCE_C_CHARACTER = 7
    SCE_C_UUID = 8
    SCE_C_PREPROCESSOR = 9
    SCE_C_OPERATOR = 10
    SCE_C_IDENTIFIER = 11
    SCE_C_STRINGEOL = 12
    SCE_C_VERBATIM = 13
    SCE_C_REGEX = 14
    SCE_C_COMMENTLINEDOC = 15
    SCE_C_WORD2 = 16
    SCE_C_COMMENTDOCKEYWORD = 17
    SCE_C_COMMENTDOCKEYWORDERROR = 18
    # Lexical states for SCLEX_HTML, SCLEX_XML
    SCE_H_DEFAULT = 0
    SCE_H_TAG = 1
    SCE_H_TAGUNKNOWN = 2
    SCE_H_ATTRIBUTE = 3
    SCE_H_ATTRIBUTEUNKNOWN = 4
    SCE_H_NUMBER = 5
    SCE_H_DOUBLESTRING = 6
    SCE_H_SINGLESTRING = 7
    SCE_H_OTHER = 8
    SCE_H_COMMENT = 9
    SCE_H_ENTITY = 10
    # XML and ASP
    SCE_H_TAGEND = 11
    SCE_H_XMLSTART = 12
    SCE_H_XMLEND = 13
    SCE_H_SCRIPT = 14
    SCE_H_ASP = 15
    SCE_H_ASPAT = 16
    SCE_H_CDATA = 17
    SCE_H_QUESTION = 18
    # More HTML
    SCE_H_VALUE = 19
    # X-Code
    SCE_H_XCCOMMENT = 20
    # SGML
    SCE_H_SGML_DEFAULT = 21
    SCE_H_SGML_COMMAND = 22
    SCE_H_SGML_1ST_PARAM = 23
    SCE_H_SGML_DOUBLESTRING = 24
    SCE_H_SGML_SIMPLESTRING = 25
    SCE_H_SGML_ERROR = 26
    SCE_H_SGML_SPECIAL = 27
    SCE_H_SGML_ENTITY = 28
    SCE_H_SGML_COMMENT = 29
    SCE_H_SGML_1ST_PARAM_COMMENT = 30
    SCE_H_SGML_BLOCK_DEFAULT = 31
    # Embedded Javascript
    SCE_HJ_START = 40
    SCE_HJ_DEFAULT = 41
    SCE_HJ_COMMENT = 42
    SCE_HJ_COMMENTLINE = 43
    SCE_HJ_COMMENTDOC = 44
    SCE_HJ_NUMBER = 45
    SCE_HJ_WORD = 46
    SCE_HJ_KEYWORD = 47
    SCE_HJ_DOUBLESTRING = 48
    SCE_HJ_SINGLESTRING = 49
    SCE_HJ_SYMBOLS = 50
    SCE_HJ_STRINGEOL = 51
    SCE_HJ_REGEX = 52
    # ASP Javascript
    SCE_HJA_START = 55
    SCE_HJA_DEFAULT = 56
    SCE_HJA_COMMENT = 57
    SCE_HJA_COMMENTLINE = 58
    SCE_HJA_COMMENTDOC = 59
    SCE_HJA_NUMBER = 60
    SCE_HJA_WORD = 61
    SCE_HJA_KEYWORD = 62
    SCE_HJA_DOUBLESTRING = 63
    SCE_HJA_SINGLESTRING = 64
    SCE_HJA_SYMBOLS = 65
    SCE_HJA_STRINGEOL = 66
    SCE_HJA_REGEX = 67
    # Embedded VBScript
    SCE_HB_START = 70
    SCE_HB_DEFAULT = 71
    SCE_HB_COMMENTLINE = 72
    SCE_HB_NUMBER = 73
    SCE_HB_WORD = 74
    SCE_HB_STRING = 75
    SCE_HB_IDENTIFIER = 76
    SCE_HB_STRINGEOL = 77
    # ASP VBScript
    SCE_HBA_START = 80
    SCE_HBA_DEFAULT = 81
    SCE_HBA_COMMENTLINE = 82
    SCE_HBA_NUMBER = 83
    SCE_HBA_WORD = 84
    SCE_HBA_STRING = 85
    SCE_HBA_IDENTIFIER = 86
    SCE_HBA_STRINGEOL = 87
    # Embedded Python
    SCE_HP_START = 90
    SCE_HP_DEFAULT = 91
    SCE_HP_COMMENTLINE = 92
    SCE_HP_NUMBER = 93
    SCE_HP_STRING = 94
    SCE_HP_CHARACTER = 95
    SCE_HP_WORD = 96
    SCE_HP_TRIPLE = 97
    SCE_HP_TRIPLEDOUBLE = 98
    SCE_HP_CLASSNAME = 99
    SCE_HP_DEFNAME = 100
    SCE_HP_OPERATOR = 101
    SCE_HP_IDENTIFIER = 102
    # ASP Python
    SCE_HPA_START = 105
    SCE_HPA_DEFAULT = 106
    SCE_HPA_COMMENTLINE = 107
    SCE_HPA_NUMBER = 108
    SCE_HPA_STRING = 109
    SCE_HPA_CHARACTER = 110
    SCE_HPA_WORD = 111
    SCE_HPA_TRIPLE = 112
    SCE_HPA_TRIPLEDOUBLE = 113
    SCE_HPA_CLASSNAME = 114
    SCE_HPA_DEFNAME = 115
    SCE_HPA_OPERATOR = 116
    SCE_HPA_IDENTIFIER = 117
    # PHP
    SCE_HPHP_DEFAULT = 118
    SCE_HPHP_HSTRING = 119
    SCE_HPHP_SIMPLESTRING = 120
    SCE_HPHP_WORD = 121
    SCE_HPHP_NUMBER = 122
    SCE_HPHP_VARIABLE = 123
    SCE_HPHP_COMMENT = 124
    SCE_HPHP_COMMENTLINE = 125
    SCE_HPHP_HSTRING_VARIABLE = 126
    SCE_HPHP_OPERATOR = 127
    # Lexical states for SCLEX_PERL
    SCE_PL_DEFAULT = 0
    SCE_PL_ERROR = 1
    SCE_PL_COMMENTLINE = 2
    SCE_PL_POD = 3
    SCE_PL_NUMBER = 4
    SCE_PL_WORD = 5
    SCE_PL_STRING = 6
    SCE_PL_CHARACTER = 7
    SCE_PL_PUNCTUATION = 8
    SCE_PL_PREPROCESSOR = 9
    SCE_PL_OPERATOR = 10
    SCE_PL_IDENTIFIER = 11
    SCE_PL_SCALAR = 12
    SCE_PL_ARRAY = 13
    SCE_PL_HASH = 14
    SCE_PL_SYMBOLTABLE = 15
    SCE_PL_REGEX = 17
    SCE_PL_REGSUBST = 18
    SCE_PL_LONGQUOTE = 19
    SCE_PL_BACKTICKS = 20
    SCE_PL_DATASECTION = 21
    SCE_PL_HERE_DELIM = 22
    SCE_PL_HERE_Q = 23
    SCE_PL_HERE_QQ = 24
    SCE_PL_HERE_QX = 25
    SCE_PL_STRING_Q = 26
    SCE_PL_STRING_QQ = 27
    SCE_PL_STRING_QX = 28
    SCE_PL_STRING_QR = 29
    SCE_PL_STRING_QW = 30
    # Lexical states for SCLEX_VB, SCLEX_VBSCRIPT
    SCE_B_DEFAULT = 0
    SCE_B_COMMENT = 1
    SCE_B_NUMBER = 2
    SCE_B_KEYWORD = 3
    SCE_B_STRING = 4
    SCE_B_PREPROCESSOR = 5
    SCE_B_OPERATOR = 6
    SCE_B_IDENTIFIER = 7
    SCE_B_DATE = 8
    # Lexical states for SCLEX_PROPERTIES
    SCE_PROPS_DEFAULT = 0
    SCE_PROPS_COMMENT = 1
    SCE_PROPS_SECTION = 2
    SCE_PROPS_ASSIGNMENT = 3
    SCE_PROPS_DEFVAL = 4
    # Lexical states for SCLEX_LATEX
    SCE_L_DEFAULT = 0
    SCE_L_COMMAND = 1
    SCE_L_TAG = 2
    SCE_L_MATH = 3
    SCE_L_COMMENT = 4
    # Lexical states for SCLEX_LUA
    SCE_LUA_DEFAULT = 0
    SCE_LUA_COMMENT = 1
    SCE_LUA_COMMENTLINE = 2
    SCE_LUA_COMMENTDOC = 3
    SCE_LUA_NUMBER = 4
    SCE_LUA_WORD = 5
    SCE_LUA_STRING = 6
    SCE_LUA_CHARACTER = 7
    SCE_LUA_LITERALSTRING = 8
    SCE_LUA_PREPROCESSOR = 9
    SCE_LUA_OPERATOR = 10
    SCE_LUA_IDENTIFIER = 11
    SCE_LUA_STRINGEOL = 12
    SCE_LUA_WORD2 = 13
    SCE_LUA_WORD3 = 14
    SCE_LUA_WORD4 = 15
    SCE_LUA_WORD5 = 16
    SCE_LUA_WORD6 = 17
    # Lexical states for SCLEX_ERRORLIST
    SCE_ERR_DEFAULT = 0
    SCE_ERR_PYTHON = 1
    SCE_ERR_GCC = 2
    SCE_ERR_MS = 3
    SCE_ERR_CMD = 4
    SCE_ERR_BORLAND = 5
    SCE_ERR_PERL = 6
    SCE_ERR_NET = 7
    SCE_ERR_LUA = 8
    SCE_ERR_CTAG = 9
    SCE_ERR_DIFF_CHANGED = 10
    SCE_ERR_DIFF_ADDITION = 11
    SCE_ERR_DIFF_DELETION = 12
    SCE_ERR_DIFF_MESSAGE = 13
    SCE_ERR_PHP = 14
    # Lexical states for SCLEX_BATCH
    SCE_BAT_DEFAULT = 0
    SCE_BAT_COMMENT = 1
    SCE_BAT_WORD = 2
    SCE_BAT_LABEL = 3
    SCE_BAT_HIDE = 4
    SCE_BAT_COMMAND = 5
    SCE_BAT_IDENTIFIER = 6
    SCE_BAT_OPERATOR = 7
    # Lexical states for SCLEX_MAKEFILE
    SCE_MAKE_DEFAULT = 0
    SCE_MAKE_COMMENT = 1
    SCE_MAKE_PREPROCESSOR = 2
    SCE_MAKE_IDENTIFIER = 3
    SCE_MAKE_OPERATOR = 4
    SCE_MAKE_TARGET = 5
    SCE_MAKE_IDEOL = 9
    # Lexical states for SCLEX_DIFF
    SCE_DIFF_DEFAULT = 0
    SCE_DIFF_COMMENT = 1
    SCE_DIFF_COMMAND = 2
    SCE_DIFF_HEADER = 3
    SCE_DIFF_POSITION = 4
    SCE_DIFF_DELETED = 5
    SCE_DIFF_ADDED = 6
    # Lexical states for SCLEX_CONF (Apache Configuration Files Lexer)
    SCE_CONF_DEFAULT = 0
    SCE_CONF_COMMENT = 1
    SCE_CONF_NUMBER = 2
    SCE_CONF_IDENTIFIER = 3
    SCE_CONF_EXTENSION = 4
    SCE_CONF_PARAMETER = 5
    SCE_CONF_STRING = 6
    SCE_CONF_OPERATOR = 7
    SCE_CONF_IP = 8
    SCE_CONF_DIRECTIVE = 9
    # Lexical states for SCLEX_AVE, Avenue
    SCE_AVE_DEFAULT = 0
    SCE_AVE_COMMENT = 1
    SCE_AVE_NUMBER = 2
    SCE_AVE_WORD = 3
    SCE_AVE_STRING = 6
    SCE_AVE_ENUM = 7
    SCE_AVE_STRINGEOL = 8
    SCE_AVE_IDENTIFIER = 9
    SCE_AVE_OPERATOR = 10
    SCE_AVE_WORD1 = 11
    SCE_AVE_WORD2 = 12
    SCE_AVE_WORD3 = 13
    SCE_AVE_WORD4 = 14
    SCE_AVE_WORD5 = 15
    SCE_AVE_WORD6 = 16
    # Lexical states for SCLEX_ADA
    SCE_ADA_DEFAULT = 0
    SCE_ADA_WORD = 1
    SCE_ADA_IDENTIFIER = 2
    SCE_ADA_NUMBER = 3
    SCE_ADA_DELIMITER = 4
    SCE_ADA_CHARACTER = 5
    SCE_ADA_CHARACTEREOL = 6
    SCE_ADA_STRING = 7
    SCE_ADA_STRINGEOL = 8
    SCE_ADA_LABEL = 9
    SCE_ADA_COMMENTLINE = 10
    SCE_ADA_ILLEGAL = 11
    # Lexical states for SCLEX_BAAN
    SCE_BAAN_DEFAULT = 0
    SCE_BAAN_COMMENT = 1
    SCE_BAAN_COMMENTDOC = 2
    SCE_BAAN_NUMBER = 3
    SCE_BAAN_WORD = 4
    SCE_BAAN_STRING = 5
    SCE_BAAN_PREPROCESSOR = 6
    SCE_BAAN_OPERATOR = 7
    SCE_BAAN_IDENTIFIER = 8
    SCE_BAAN_STRINGEOL = 9
    SCE_BAAN_WORD2 = 10
    # Lexical states for SCLEX_LISP
    SCE_LISP_DEFAULT = 0
    SCE_LISP_COMMENT = 1
    SCE_LISP_NUMBER = 2
    SCE_LISP_KEYWORD = 3
    SCE_LISP_STRING = 6
    SCE_LISP_STRINGEOL = 8
    SCE_LISP_IDENTIFIER = 9
    SCE_LISP_OPERATOR = 10
    # Lexical states for SCLEX_EIFFEL and SCLEX_EIFFELKW
    SCE_EIFFEL_DEFAULT = 0
    SCE_EIFFEL_COMMENTLINE = 1
    SCE_EIFFEL_NUMBER = 2
    SCE_EIFFEL_WORD = 3
    SCE_EIFFEL_STRING = 4
    SCE_EIFFEL_CHARACTER = 5
    SCE_EIFFEL_OPERATOR = 6
    SCE_EIFFEL_IDENTIFIER = 7
    SCE_EIFFEL_STRINGEOL = 8
    # Lexical states for SCLEX_NNCRONTAB (nnCron crontab Lexer)
    SCE_NNCRONTAB_DEFAULT = 0
    SCE_NNCRONTAB_COMMENT = 1
    SCE_NNCRONTAB_TASK = 2
    SCE_NNCRONTAB_SECTION = 3
    SCE_NNCRONTAB_KEYWORD = 4
    SCE_NNCRONTAB_MODIFIER = 5
    SCE_NNCRONTAB_ASTERISK = 6
    SCE_NNCRONTAB_NUMBER = 7
    SCE_NNCRONTAB_STRING = 8
    SCE_NNCRONTAB_ENVIRONMENT = 9
    SCE_NNCRONTAB_IDENTIFIER = 10
    # Lexical states for SCLEX_MATLAB
    SCE_MATLAB_DEFAULT = 0
    SCE_MATLAB_COMMENT = 1
    SCE_MATLAB_COMMAND = 2
    SCE_MATLAB_NUMBER = 3
    SCE_MATLAB_KEYWORD = 4
    SCE_MATLAB_STRING = 5
    SCE_MATLAB_OPERATOR = 6
    SCE_MATLAB_IDENTIFIER = 7
    # Lexical states for SCLEX_SCRIPTOL
    SCE_SCRIPTOL_DEFAULT = 0
    SCE_SCRIPTOL_COMMENT = 1
    SCE_SCRIPTOL_COMMENTLINE = 2
    SCE_SCRIPTOL_COMMENTDOC = 3
    SCE_SCRIPTOL_NUMBER = 4
    SCE_SCRIPTOL_WORD = 5
    SCE_SCRIPTOL_STRING = 6
    SCE_SCRIPTOL_CHARACTER = 7
    SCE_SCRIPTOL_UUID = 8
    SCE_SCRIPTOL_PREPROCESSOR = 9
    SCE_SCRIPTOL_OPERATOR = 10
    SCE_SCRIPTOL_IDENTIFIER = 11
    SCE_SCRIPTOL_STRINGEOL = 12
    SCE_SCRIPTOL_VERBATIM = 13
    SCE_SCRIPTOL_REGEX = 14
    SCE_SCRIPTOL_COMMENTLINEDOC = 15
    SCE_SCRIPTOL_WORD2 = 16
    SCE_SCRIPTOL_COMMENTDOCKEYWORD = 17
    SCE_SCRIPTOL_COMMENTDOCKEYWORDERROR = 18
    SCE_SCRIPTOL_COMMENTBASIC = 19
    # Lexical states for SCLEX_ASM
    SCE_ASM_DEFAULT = 0
    SCE_ASM_COMMENT = 1
    SCE_ASM_NUMBER = 2
    SCE_ASM_STRING = 3
    SCE_ASM_OPERATOR = 4
    SCE_ASM_IDENTIFIER = 5
    SCE_ASM_CPUINSTRUCTION = 6
    SCE_ASM_MATHINSTRUCTION = 7
    SCE_ASM_REGISTER = 8
    SCE_ASM_DIRECTIVE = 9
    SCE_ASM_DIRECTIVEOPERAND = 10
    # Lexical states for SCLEX_FORTRAN
    SCE_F_DEFAULT = 0
    SCE_F_COMMENT = 1
    SCE_F_NUMBER = 2
    SCE_F_STRING1 = 3
    SCE_F_STRING2 = 4
    SCE_F_STRINGEOL = 5
    SCE_F_OPERATOR = 6
    SCE_F_IDENTIFIER = 7
    SCE_F_WORD = 8
    SCE_F_WORD2 = 9
    SCE_F_WORD3 = 10
    SCE_F_PREPROCESSOR = 11
    SCE_F_OPERATOR2 = 12
    SCE_F_LABEL = 13
    SCE_F_CONTINUATION = 14
    # Lexical states for SCLEX_CSS
    SCE_CSS_DEFAULT = 0
    SCE_CSS_TAG = 1
    SCE_CSS_CLASS = 2
    SCE_CSS_PSEUDOCLASS = 3
    SCE_CSS_UNKNOWN_PSEUDOCLASS = 4
    SCE_CSS_OPERATOR = 5
    SCE_CSS_IDENTIFIER = 6
    SCE_CSS_UNKNOWN_IDENTIFIER = 7
    SCE_CSS_VALUE = 8
    SCE_CSS_COMMENT = 9
    SCE_CSS_ID = 10
    SCE_CSS_IMPORTANT = 11
    SCE_CSS_DIRECTIVE = 12

    # Events

    SCN_STYLENEEDED = 2000
    SCN_CHARADDED = 2001
    SCN_SAVEPOINTREACHED = 2002
    SCN_SAVEPOINTLEFT = 2003
    SCN_MODIFYATTEMPTRO = 2004
    # GTK+ Specific to work around focus and accelerator problems:
    SCN_KEY = 2005
    SCN_DOUBLECLICK = 2006
    SCN_UPDATEUI = 2007
    SCN_MODIFIED = 2008
    SCN_MACRORECORD = 2009
    SCN_MARGINCLICK = 2010
    SCN_NEEDSHOWN = 2011
    SCN_PAINTED = 2013
    SCN_USERLISTSELECTION = 2014
    SCN_URIDROPPED = 2015
    SCN_DWELLSTART = 2016
    SCN_DWELLEND = 2017
    SCN_ZOOM = 2018

    # Deprecated

    # CARET_POLICY changed in 1.47
    def setCaretPolicy(caretPolicy, caretSlop)
      sendMessage(2369, caretPolicy, caretSlop)
    end
    CARET_CENTER = 0x02
    CARET_XEVEN = 0x08
    CARET_XJUMPS = 0x10

    # The old name for SCN_UPDATEUI
    SCN_CHECKBRACE = 2007
    SCN_POSCHANGED = 2012

  end
end
