/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

class FXDirSelector;


/// Directory selection dialog
class FXDirDialog : public FXDialogBox {
protected:
  FXDirSelector *dirbox;          // Directory selection widget
protected:
  FXDirDialog(){}
public:
  %extend {
    /// Construct Directory Dialog Box
    FXDirDialog(FXWindow* owner,const FXString& name,FXuint opts=0,FXint x=0,FXint y=0,FXint w=400,FXint h=300){
      return new FXRbDirDialog(owner,name,opts,x,y,w,h);
      }
    }

  /// Change directory
  void setDirectory(const FXString& path);
  
  /// Return directory
  FXString getDirectory() const;
  
  /// Change Directory List style
  void setDirBoxStyle(FXuint style);

  /// Return Directory List style
  FXuint getDirBoxStyle() const;

  /// Destructor
  virtual ~FXDirDialog();
  };


DECLARE_FXOBJECT_VIRTUALS(FXDirDialog)
DECLARE_FXID_VIRTUALS(FXDirDialog)
DECLARE_FXDRAWABLE_VIRTUALS(FXDirDialog)
DECLARE_FXWINDOW_VIRTUALS(FXDirDialog)
DECLARE_FXTOPWINDOW_VIRTUALS(FXDirDialog)
DECLARE_FXDIALOGBOX_VIRTUALS(FXDirDialog)

