/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

class FXArrowButton;

/// Scrolling menu pane
class FXScrollPane : public FXMenuPane {
protected:
  FXArrowButton *dn;            // Button to scroll down
  FXArrowButton *up;            // Button to scroll up
  FXint          visible;       // Visible entries
  FXint          top;           // Top visible entry
protected:
  FXScrollPane();
private:
  FXScrollPane(const FXScrollPane&);
  FXScrollPane &operator=(const FXScrollPane&);
public:
  long onUpdIncrement(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdIncrement(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdDecrement(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdDecrement(FXObject*,FXSelector,void* PTR_IGNORE);
public:
  enum {
    ID_SCROLL_DN=FXMenuPane::ID_LAST,
    ID_SCROLL_UP,
    ID_LAST
    };
public:

  %extend {
    /// Construct menu pane
    FXScrollPane(FXWindow* owner,FXint nvis,FXuint opts=0){
      return new FXRbScrollPane(owner,nvis,opts);
      }
  }

  /// Get index of top most menu item
  FXint getTopItem() const { return top; }

  /// Scroll item to top
  void setTopItem(FXint t);

  /// Destroy
  virtual ~FXScrollPane();
  };

DECLARE_FXOBJECT_VIRTUALS(FXScrollPane)
DECLARE_FXID_VIRTUALS(FXScrollPane)
DECLARE_FXDRAWABLE_VIRTUALS(FXScrollPane)
DECLARE_FXWINDOW_VIRTUALS(FXScrollPane)
DECLARE_FXPOPUP_VIRTUALS(FXScrollPane)

