/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001-2003 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/// Separator Options
enum {
  SEPARATOR_NONE       = 0,               /// Nothing visible
  SEPARATOR_GROOVE     = 0x00008000,      /// Etched-in looking groove
  SEPARATOR_RIDGE      = 0x00010000,      /// Embossed looking ridge
  SEPARATOR_LINE       = 0x00020000       /// Simple line
  };


/// Separator widget
class FXSeparator : public FXFrame {
protected:
  FXSeparator(){}
private:
  FXSeparator(const FXSeparator&);
  FXSeparator &operator=(const FXSeparator&);
public:
  long onPaint(FXObject*,FXSelector,void* PTR_EVENT);
public:

  %extend {
    /// Constructor
    FXSeparator(FXComposite* p,FXuint opts=SEPARATOR_GROOVE|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=0,FXint pb=0){
      return new FXRbSeparator(p,opts,x,y,w,h,pl,pr,pt,pb);
      }
  }

  /// Change separator style
  void setSeparatorStyle(FXuint style);

  /// Get separator style
  FXuint getSeparatorStyle() const;

  /// Destructor
  virtual ~FXSeparator();
  };
  

DECLARE_FXOBJECT_VIRTUALS(FXSeparator)
DECLARE_FXID_VIRTUALS(FXSeparator)
DECLARE_FXDRAWABLE_VIRTUALS(FXSeparator)
DECLARE_FXWINDOW_VIRTUALS(FXSeparator)


/// Horizontal separator
class FXHorizontalSeparator : public FXSeparator {
protected:
  FXHorizontalSeparator(){}
public:

  /// Constructor
  %extend {
    FXHorizontalSeparator(FXComposite* p,FXuint opts=SEPARATOR_GROOVE|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=1,FXint pr=1,FXint pt=0,FXint pb=0){
      return new FXRbHorizontalSeparator(p,opts,x,y,w,h,pl,pr,pt,pb);
      }
    }
  
  /// Destructor
  virtual ~FXHorizontalSeparator();
  };


DECLARE_FXOBJECT_VIRTUALS(FXHorizontalSeparator)
DECLARE_FXID_VIRTUALS(FXHorizontalSeparator)
DECLARE_FXDRAWABLE_VIRTUALS(FXHorizontalSeparator)
DECLARE_FXWINDOW_VIRTUALS(FXHorizontalSeparator)


/// Vertical separator
class FXVerticalSeparator : public FXSeparator {
protected:
  FXVerticalSeparator(){}
public:

  /// Constructor
  %extend {
    FXVerticalSeparator(FXComposite* p,FXuint opts=SEPARATOR_GROOVE|LAYOUT_FILL_Y,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=1,FXint pb=1){
      return new FXRbVerticalSeparator(p,opts,x,y,w,h,pl,pr,pt,pb);
      }
    }
  
  /// Destructor
  virtual ~FXVerticalSeparator();
  };


DECLARE_FXOBJECT_VIRTUALS(FXVerticalSeparator)
DECLARE_FXID_VIRTUALS(FXVerticalSeparator)
DECLARE_FXDRAWABLE_VIRTUALS(FXVerticalSeparator)
DECLARE_FXWINDOW_VIRTUALS(FXVerticalSeparator)

