/***********************************************************************
 * FXRuby -- the Ruby language bindings for the FOX GUI toolkit.
 * Copyright (c) 2001 by J. Lyle Johnson. All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For further information please contact the author by e-mail
 * at "lyle@users.sourceforge.net".
 ***********************************************************************/

/**
 * ToolBar control.
 */

class FXToolBar : public FXPacker {
protected:
  FXComposite   *drydock;     // Parent when docked
  FXComposite   *wetdock;     // Parent when floating
  FXRectangle    outline;     // Outline shown while dragging
  FXWindow      *dockafter;   // Dock after this window
  FXuint         dockside;    // Dock on this side
  FXbool         docking;     // Dock it
protected:
  FXToolBar();
public:
  long onCmdUndock(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdUndock(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdDockTop(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdDockTop(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdDockBottom(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdDockBottom(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdDockLeft(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdDockLeft(FXObject*,FXSelector,void* PTR_IGNORE);
  long onCmdDockRight(FXObject*,FXSelector,void* PTR_IGNORE);
  long onUpdDockRight(FXObject*,FXSelector,void* PTR_IGNORE);
  long onBeginDragGrip(FXObject*,FXSelector,void* PTR_EVENT);
  long onEndDragGrip(FXObject*,FXSelector,void* PTR_EVENT);
  long onDraggedGrip(FXObject*,FXSelector,void* PTR_EVENT);
public:
  enum {
    ID_UNDOCK=FXPacker::ID_LAST,  /// Undock the toolbar
    ID_DOCK_TOP,                  /// Dock on the top
    ID_DOCK_BOTTOM,               /// Dock on the bottom
    ID_DOCK_LEFT,                 /// Dock on the left
    ID_DOCK_RIGHT,                /// Dock on the right
    ID_TOOLBARGRIP,               /// Notifications from toolbar grip
    ID_LAST
    };
public:
  %extend {
    /**
     * Construct a floatable toolbar 
     * Normally, the toolbar is docked under window p.
     * When floated, the toolbar can be docked under window q, which is
     * typically an FXToolBarShell window.
     */
    FXToolBar(FXComposite* p,FXComposite* q,FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=3,FXint pr=3,FXint pt=2,FXint pb=2,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING){
      return new FXRbToolBar(p,q,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }

    /**
     * Construct a non-floatable toolbar.
     * The toolbar can not be undocked.
     */
    FXToolBar(FXComposite* p,FXuint opts=LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=2,FXint pr=3,FXint pt=3,FXint pb=2,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING){
      return new FXRbToolBar(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs);
      }
    }

  /**
   * Set parent when docked.
   * If it was docked, reparent under the new docking window.
   */
  void setDryDock(FXComposite* dry);

  /**
   * Set parent when floating.
   * If it was undocked, then reparent under the new floating window.
   */
  void setWetDock(FXComposite* wet);

  /// Return parent when docked
  FXComposite* getDryDock() const;

  /// Return parent when floating
  FXComposite* getWetDock() const;

  /// Return true if toolbar is docked
  FXbool isDocked() const;

  /// Set docking side 
  void setDockingSide(FXuint side=LAYOUT_SIDE_TOP);

  /// Return docking side
  FXuint getDockingSide() const;
  
  /// Destroy
  virtual ~FXToolBar();
  };


DECLARE_FXOBJECT_VIRTUALS(FXToolBar)
DECLARE_FXID_VIRTUALS(FXToolBar)
DECLARE_FXDRAWABLE_VIRTUALS(FXToolBar)
DECLARE_FXWINDOW_VIRTUALS(FXToolBar)
DECLARE_FXTOOLBAR_VIRTUALS(FXToolBar)
