require 'testicmp.rb'

class TestICMPModuleICMP < RUNIT::TestCase

  def setup
    @c = ICMPModule::ICMP_c.new
    @rb = ICMPModule::ICMP_rb.new
    @ip = ICMPModule::IP.new("\x45\x00\x00\x13" +
                             "\x12\x34\x00\x00" +
                             "\xff\x00\x00\x00" +
                             "\x01\x23\x45\x67" +
                             "\x89\xab\xcd\xef" +
                             "01234567")
    [ @rb, @c ].each{|packet|
      packet.icmp_type = ICMPModule::ICMP_UNREACH
      packet.icmp_code = ICMPModule::ICMP_UNREACH_PROTOCOL
      packet.icmp_id = 10
      packet.icmp_seq = 11
      packet.icmp_ip = @ip
      packet.setup
    }
  end

  def test_icmp_type
    assert_equal(@c, @rb)
    assert_equal(ICMPModule::ICMP_UNREACH, @c.icmp_type);
    assert_equal(@c.icmp_type, @rb.icmp_type);
  end

  def test_icmp_code
    assert_equal(ICMPModule::ICMP_UNREACH_PROTOCOL, @c.icmp_code);
    assert_equal(@c.icmp_code, @rb.icmp_code);
  end

  def test_icmp_cksum
    assert_equal(@c, @rb)
    assert_equal(@c.sum, @rb.sum)
    assert_equal(@c.icmp_cksum, @rb.icmp_cksum)
    @c.icmp_cksum = 0x1234
    @rb.icmp_cksum = 0x1234
    assert_equal(@c, @rb)
    assert_equal(@c.sum, @rb.sum)
    assert_equal(@c.icmp_cksum, @rb.icmp_cksum)
  end

  def test_icmp_id
    assert_equal(10, @c.icmp_id);
    assert_equal(@c.icmp_id, @rb.icmp_id);
  end

  def test_icmp_seq
    assert_equal(11, @c.icmp_seq);
    assert_equal(@c.icmp_seq, @rb.icmp_seq);
  end

  def test_icmp_ip
    assert_equal(@ip, @c.icmp_ip);
    assert_equal(@c.icmp_ip, @rb.icmp_ip);
  end
end

TestICMPModule::handleTests(TestICMPModuleICMP) if $0 == __FILE__
