require 'testicmp.rb'

class TestICMPModuleIP < RUNIT::TestCase

  def setup
    s = "\x45\x00\x00\x07" +
        "\x12\x34\x00\x00" +
        "\xff\x00\x00\x00" +
        "\x01\x02\x03\x04" +
        "\x05\x06\x07\x08" +
        "01234567"
    @c = ICMPModule::IP_c.new(s)
    @rb = ICMPModule::IP_rb.new(s)
  end

  def test_ip_v
    assert_equal(4, @c.ip_v);
    assert_equal(@c.ip_v, @rb.ip_v);
  end

  def test_ip_hl
    assert_equal(5, @c.ip_hl);
    assert_equal(@c.ip_hl, @rb.ip_hl);
  end

  def test_ip_len
    assert_equal(7, @c.ip_len);
    assert_equal(@c.ip_len, @rb.ip_len);
  end

  def test_ip_src
    assert_equal("1.2.3.4", @c.ip_src);
    assert_equal(@c.ip_src, @rb.ip_src);
  end

  def test_ip_dst
    assert_equal("5.6.7.8", @c.ip_dst);
    assert_equal(@c.ip_dst, @rb.ip_dst);
  end

  def test_body
    assert_equal("01234567", @c.body);
    assert_equal(@c.body, @rb.body);
  end
end

TestICMPModule::handleTests(TestICMPModuleIP) if $0 == __FILE__
