#!/usr/bin/env ruby
require("gsl")

f = GSL::Function.new { |x|
  if x < 0.5
    0.25
  else
    0.75
  end
}

n = 1000
order = 40
cs = GSL::Cheb.new(order)

cs.init(f, 0, 1)
begin
  ff = File.open("ff.dat", "w")
  fr10 = File.open("fr10.dat", "w")
  fr40 = File.open("fr40.dat", "w")
  for i in 0..n do
    x = i.to_f/n
    r10 = cs.eval_n(10, x)
    r40 = cs.eval(x)
    #  file.printf("%d %e %e %e %e\n", i, x, f.eval(x), r10, r40)
    ff.printf("%e %e\n", x, f.eval(x))
    fr10.printf("%e %e\n", x, r10)
    fr40.printf("%e %e\n", x, r40)
  end
ensure
  ff.close
  fr10.close
  fr40.close
end

system("graph -T X -C -g 3 -x 0 1 -L 'Green: order 10, Blue: order 40' ff.dat fr10.dat fr40.dat")
File.delete("ff.dat")
File.delete("fr10.dat")
File.delete("fr40.dat")
