#!/usr/bin/env ruby
require("gsl")

N = 10000
MAX = 8
rng = Rng.new(2)

hg = Histogram.new(100, [-MAX, MAX])

for i in 0...N do
#  r = rng.gaussian(1.5) + 2
  r = Ran.gaussian(rng, 1.5) + 2
  hg.increment(r)
end

result = hg.fit_gaussian
sigma = result[0]
mean = result[1]
height = result[2]
x = Vector.linspace(-MAX, MAX, 100)
y = height*Ran::gaussian_pdf(x-mean, sigma)
GSL::graph(hg, [x, y], "-T X -C -g 3")
