#!/usr/bin/env ruby
require("gsl")
GSL::Rng.env_setup()

N = 10000
rng = Rng.alloc

h = Histogram.new(20, [0, 20])

for i in 0...N do
  r = rng.poisson(5)
#  r = Ran::poisson(rng, 5)
  h.increment(r)
end

h.normalize!
x = Vector.linspace(0, 20, 100)
y = Ran::poisson_pdf(x, 5)
graph(h, [x, y], "-C -g 3 -L 'Poisson distribution, mu = 5'")


