#!/usr/bin/env ruby
require("gsl")

n = 256
nc = 20

data = Vector.alloc(n)
data.fscanf("ecg.dat")
datasave = data.duplicate

w = GSL::Wavelet.alloc("daubechies", 4)
work = GSL::Wavelet::Workspace.alloc(n)

# Choose whichever you like...
w.transform(data, Wavelet::FORWARD, work)
#data.wavelet_transform(w, Wavelet::FORWARD, work)
#data.wavelet_transform_forward(w, work)
#w.transform(data, work)
#w.transform(data)
#w.transform(data, Wavelet::FORWARD)
#w.transform_forward(data, work)
#w.transform_forward(data)
#Wavelet.transform(w, data, Wavelet::FORWARD, work)
#Wavelet.transform(w, data, Wavelet::FORWARD)
#Wavelet.transform(w, data, work)
#Wavelet.transform(w, data)
#Wavelet.transform_forward(w, data, work)
#Wavelet.transform_forward(w, data)

perm = data.abs.sort_index

i = 0
while (i + nc) < n
  data[perm[i]] = 0.0
  i += 1  
end

# Choose whichever you like...
w.transform(data, Wavelet::BACKWARD, work)
#data.wavelet_transform(w, Wavelet::BACKWARD, work)
#data.wavelet_transform_inverse(w, work)
#w.transform(data, Wavelet::BACKWARD)
#w.transform_inverse(data, work)
#w.transform_inverse(data)
#Wavelet.transform(w, data, Wavelet::BACKWARD, work)
#Wavelet.transform(w, data, Wavelet::BACKWARD)
#Wavelet.transform_inverse(w, data, work)
#Wavelet.transform_inverse(w, data)

graph(nil, datasave, data, "-T X -C -g 3 -x 0 #{data.size} -L 'Red: data, Green: DWT'")

