=begin
= Statistics

== Methods

--- GSL::Stats.mean(data)
--- GSL::Vector#mean
    Arithmetic mean.

    * Ex:
         irb(main):001:0> require("gsl")
         => true
         irb(main):002:0> v = Vector[1..7]
         => GSL::Vector: 
         [ 1.000e+00 2.000e+00 3.000e+00 4.000e+00 5.000e+00 6.000e+00 7.000e+00 ]
         irb(main):003:0> v.mean
         => 4.0
         irb(main):004:0> Stats.mean(v)
         => 4.0

--- GSL::Stats.variance(data)
--- GSL::Vector#variance
    Estimated variance.

--- GSL::Stats.variance_m(data, mean)
--- GSL::Vector#variance_m(mean)
    Variance of ((|data|)) relative to the given value of ((|mean|)).

--- GSL::Stats.sd(v)
--- GSL::Vector#sd
    Standard deviation

The following is a list of other methods defined both as singleton methods of 
the (({GSL::Stats})) module and methods of the (({GSL::Vector})) class. 
See the ((<GSL reference|URL:http://www.gnu.org/software/gsl/manual/gsl-ref_20.html#SEC327>)) for details.

* sd
* sd_m
* variace_with_fixed_mean
* sd_with_fixed_mean
* absdev
* absdev_m
* skew
* skew_m_sd
* kurtosis
* kurtosis_m_sd
* lag1_autocorrelation
* lag1_autocorrelation_m
* max
* min
* minmax
* max_index
* min_index
* minmax_index
* median_from_sorted_data
* uantile_from_sorted_data

These are singleton methods of the (({GSL::Stats})) module.
* covariance
* covariance_m
* wmean
* wmean_m
* wvariance
* wvariance_m
* wsd
* wsd_m
* wvariance_with_fixed_mean
* wsd_with_fixed_mean
* wabsdev
* wabsdev_m
* wskew
* wskew_m_sd
* wkurtosis
* wkurtosis_m_sd

== Example

     #!/usr/bin/env ruby
     require 'gsl'

     ary =  [17.2, 18.1, 16.5, 18.3, 12.6]
     data = Vector.new(ary)
     mean     = data.mean()
     variance = data.stats_variance()
     largest  = data.stats_max()
     smallest = data.stats_min()

     printf("The dataset is %g, %g, %g, %g, %g\n",
            data[0], data[1], data[2], data[3], data[4]);

     printf("The sample mean is %g\n", mean);
     printf("The estimated variance is %g\n", variance);
     printf("The largest value is %g\n", largest);
     printf("The smallest value is %g\n", smallest);

((<prev|URL:randist.html>))
((<next|URL:hist.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))
=end
