#!/usr/bin/env ruby
require("gsl")

n = 630
data = FFT::Complex::PackedArray.new(2*n)

table = FFT::Complex::Wavetable.new(n)
space = FFT::Complex::Workspace.new(n)

data.set_real(0, 1.0)
for i in 1..10 do
  data[i] = [1.0, 0.0]
  data[n-i] = [1.0, 0.0]
end

datasave = data.clone

# Select whichever you like
#data.forward(1, n, table, space)
#data.forward(n, table, space)
#data.forward(table, space)
#data.forward(n, table)
#data.forward(n, space)
#data.forward(n)
#data.forward(table)
#data.forward(space)
#data.forward()
#data.transform(table, space, FFT::Forward)
#data.transform(FFT::Forward)
FFT::Complex.forward(data, table, space)
#FFT::Complex.forward(data)
#FFT::Complex.transform(data, table, space, FFT::Forward)
#FFT::Complex.transform(data, FFT::Forward)
data /= Math::sqrt(n)
graph(nil, datasave.re, data.re, "-C -g 3")
