#!/usr/bin/env ruby
require("gsl")

n = 10
x = Vector[n]
y = Vector[n]
File.open("data0.dat", "w") do |f|
  for i in 0...n do
    a = i.to_f
    x[i] = i + 0.5*Math::sin(a)
    y[i] = i + Math::cos(a*a)
    f.printf("%e %e\n", x[i], y[i])
  end
end

interp = Interp.new("akima", n)
#p interp.class
#p interp.name

interp.init(x, y)

File.open("data1.dat", "w") do |f|
  xi = x[0]
  while xi < x[9]
    yi = interp.eval(x, y, xi)
    f.printf("%e %e\n", xi, yi)
    xi += 0.01
  end
end

system("graph -T X -g 3 -C -L 'GSL::Interp, Akima' -m -1 -S 4 data0.dat -S 1 data1.dat")
File.delete("data0.dat")
File.delete("data1.dat")

