#!/usr/bin/env ruby
require("gsl")
include Math

n = 10
x = Vector[n]
y = Vector[n]
File.open("data0.dat", "w") do |f|
  for i in 0...n do
    a = i.to_f
    x[i] = i + 0.5*sin(a)
    y[i] = i + cos(a*a)
    f.printf("%e %e\n", x[i], y[i])
  end
end

spline = Spline.new(Interp::CSPLINE, n)
spline.init(x, y)

xi = x[0]
File.open("data1.dat", "w") do |f|
  while xi < x[9]
    yi = spline.eval(xi)
    f.printf("%e %e\n", xi, yi)
    xi += 0.01
  end
end

system("graph -T X -g 3 -C -L 'GSL::Spline, CSPLINE' -m -1 -S 4 data0.dat -S 1 data1.dat")
File.delete("data0.dat")
File.delete("data1.dat")

