#!/usr/bin/env ruby
# Ruby/GSL implementation of GSL "qrng/test.c"
require("gsl")
require("./gsl_test2.rb")
include GSL::Test
include Math

GSL::IEEE::env_setup()

def test_sobol()
  v = Vector.new(3)

  status = 0
  g = QRng.new(QRng::SOBOL, 2)
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.25 or v[1] != 0.75) ? 1 : 0
  g.get(v)
  status += (v[0] != 0.375 or v[1] != 0.375) ? 1 : 0
  GSL::Test::test(status, "Sobol d=2")

  status = 0
  g = QRng.new(QRng::SOBOL, 3)
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.25 or v[1] != 0.75) ? 1 : 0
  g.get(v)
  status += (v[0] != 0.375 or v[1] != 0.375) ? 1 : 0
  GSL::Test::test(status, "Sobol d=3")

  status = 0
  g.init
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.25 or v[1] != 0.75) ? 1 : 0
  g.get(v)
  status += (v[0] != 0.375 or v[1] != 0.375) ? 1 : 0
  GSL::Test::test(status, "Sobol d=3 (reinitialized)")
end

def test_nied2()
  v = Vector.new(3)

  status = 0
  g = QRng.new(QRng::NIEDERREITER_2, 2)
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.75 or v[1] != 0.25) ? 1 : 0
  g.get(v)
  status += (v[0] != 0.25 or v[1] != 0.75) ? 1 : 0
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.625 or v[1] != 0.125) ? 1 : 0
  GSL::Test::test(status, "Niederreiter d=2")

  status = 0
  g = QRng.new(QRng::NIEDERREITER_2, 3)
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.75 or v[1] != 0.25) ? 1 : 0
  g.get(v)
  status += (v[0] != 0.25 or v[1] != 0.75) ? 1 : 0
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.625 or v[1] != 0.125) ? 1 : 0
  GSL::Test::test(status, "Niederreiter d=3")

  status = 0
  g.init
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.75 or v[1] != 0.25) ? 1 : 0
  g.get(v)
  status += (v[0] != 0.25 or v[1] != 0.75) ? 1 : 0
  g.get(v)
  g.get(v)
  g.get(v)
  status += (v[0] != 0.625 or v[1] != 0.125) ? 1 : 0
  GSL::Test::test(status, "Niederreiter d=3 (reinitialized)")
end

test_sobol()
test_nied2()
