
class BaseProxy

  include Logging::Log

  #the connector, we are belong to
  attr_accessor :connector
  # Hash of all Callout definitions, that need method-dlegation and/or
  # parametermapping. [local methods name -> calloutdef]
  attr :callouts
  
  # Initialize the base proxy by setting the connector and the base.
  def initialize()
    @connector = nil
    @callouts = nil
  end
  
  # Add Callout definition. This method is called only by
  # the connector.
  def add_callout_definition(calloutdef)
    #lazy initialization -> only if needed
    if (@callouts.nil?)
      @callouts = Hash.new
    end
    #add calloutdef 
    @callouts[calloutdef.source] = calloutdef
  end

  # Get real methodname for given methodname.
  # [method] string of requested method
  # [return] the real methodname
  def method_name(method)
    #is there a callout defined?
    if (!@callouts.nil? and @callouts.has_key?(method))
      #callout defined
      calloutdef = @callouts[method]
      method = calloutdef.sink
    end
    return method
  end

  # This method is called from all expected methods.
  # Expected methods must have a binding, so this method only ensures a
  # valid method definition.
  def handle_expected(roleobject, rolemethod, *params, &block)
    #lower roleobject
    baseobject = @connector.lower(roleobject)
    #get the right methodname
    method = method_name(rolemethod)
    #assert existence of expected method
    #ot_assert(baseobject.class.method_defined?(method), "Unbound expected method: #{rolemethod} => #{method}")
    #debug(self.class, "expected_call: #{roleobject.class.name}.#{rolemethod} => #{baseobject.class.name}.#{method}")
    #lower all parameter
    nparams = @connector.lower(params)
    result = baseobject.send(method, *nparams, &block)
    result = @connector.lift(result)
    return result
  end

  # This method is called, whenever a method is not found.
  # If a role class, want to call a base method (object super)
  # this method is called.
  #def method_missing(method, *params, &block)
  #  handle_callout(method.id2name, *params, &block)
  #end

end


# BaseProxy.rb   April 2002
#
# Copyright (c) 2002 by Matthias Veit <matthias_veit@yahoo.de>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option) 
# any later version.
#  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
# GNU General Public License for more details.
#  
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA.
