

# ExpectedHandler add the new keyword *expected* to the class defnition.
# An expected method is a method, that is expected and can be used, but is
# not implemented. Expected methods are usually used by role-objects, who want
# to callout to the base.
module Kernel

  # Holds an array of methodnames that are expected.
  @@expected = Hash.new
  def get_expected_methods(classdef)
    if (!@@expected.has_key?(classdef))
      @@expected[classdef] = Array.new
    end
    return @@expected[classdef]
  end
    

  # This keyword is class wide available.
  # It includes the Role module and implements all given methods, by pointing
  # to the Methodhandler Role.handle_expected.
  def expected(*methods)
    ot_assert(self.is_a?(Class), "keyword expected only valid inside a classdefinition!")
    #is the Kernel.Role module included?
    if (!self.included_modules.include?(ObjectTeam::Role))
      self.module_eval("include ObjectTeam::Role")
    end
    #remember all expected methods
    expected = get_expected_methods(self)
    #generate delegates for all expected methods
    methods.each { |method|
      self.module_eval(<<-EOM
        def #{method}(*params, &block)
          #assert existing base
          if (@__baseproxy.nil?)
            raise ObjectTeam::TeamException, "Unbound expected method: "+self.class.name+".#{method}", caller
          end
          return @__baseproxy.handle_expected(self, "#{method}", *params, &block)
        end
      EOM
      )
      expected.push(method.id2name)
    }
  end

end


# ExpectedHandler.rb   April 2002
#
# Copyright (c) 2002 by Matthias Veit <matthias_veit@yahoo.de>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option) 
# any later version.
#  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
# GNU General Public License for more details.
#  
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA.
