
class GraphicComposite < Composite

  #Each Graphic shall be a Component
  play_role(Component, Graphic) {
    #operation means: paint
    delegate_to("operation",  "paint")
  }

  #all leaf classes
  play_role(Leaf, Line)
  play_role(Leaf, Square)
  play_role(Leaf, Text)

  #composite classes get a new paint method
  #with composite behaviour.
  play_role(Composite, Group) {
    replace("compositeOperation", "paint")
  }
  play_role(Composite, Figure) {
    replace("compositeOperation", "paint")
  }
end

#connect static -> everytime active
Team.activate_static(GraphicComposite)
