
class DomainConstraintSensing < ConstraintSensing
    # Define constraints for the existing attributes.
    class PersonCheck < ConstraintObject
        def initialize
            super()
            # name:          -is mandatory
            #                -consists only of letters from A to z
            #                -has a minimum length of 3 and a maximum length of 64
            add_constraint("name",          [Mandatory.new, 
                                             RegExp.new(/^[A-z]*$/), 
                                             MinMaxLength.new(3,64)] )
            # first_name:    -is mandatory 
            #                -consists only of letters from A to z
            #                -has a minimum length of 3 and a maximum length of 64
            add_constraint("first_name",    [Mandatory.new,
                                             RegExp.new(/^[A-z]*$/),
                                             MinMaxLength.new(3,64)] )

            # date_of_birth: -is mandatory
            #                -01.01.1900 <= date_of_birth <= Today
            add_constraint("date_of_birth", [Mandatory.new,
                                             MinMaxValue.new(Date.parse("01/01/1900"),Date.today)])
        end
    end

    play_role(PersonCheck, Person) {
        #check each set of a value
        #before really setting the value, check violation
        before(:check_setter, /set_.*/)
    }
end


class DomainConstraintHealing < ConstraintHealing
    class PersonCheck < ConstraintObject
        def initialize
            super()
            stringsolver = StringSolver.new
            datesolver = DateSolver.new
            # -is mandatory
            # -consists only of letters from A to z
            # -has a minimum length of 3 and a maximum length of 64
            m1 = [Mandatory.new, RegExp.new(/^[A-z]*$/), MinMaxLength.new(3,64)]
            # -is mandatory
            # -01.01.1900 <= date_of_birth <= Today
            m2 = [Mandatory.new, MinMaxValue.new(Date.parse("01/01/1900"),Date.today)]
            add_constraint("name", m1, stringsolver)
            add_constraint("first_name", m1, stringsolver)
            add_constraint("date_of_birth", m2, datesolver)
        end
    end

    play_role(PersonCheck, Person) {
        #check each set of a value
        #replace is used to be able to adjust to a valid attribute value.
        replace(:check_setter, /set_.*/)
    }

end


