require "objectteam"
require "flightbooking"
require "bonus"
require "contextual"


# create some flight segments:
bf = Segment.new("Berlin", "Frankfurt", 600, 150, 800)
fb = Segment.new("Frankfurt", "Berlin", 611, 150, 800)
fn = Segment.new("Frankfurt", "New York", 600, 300, 1000)
nf = Segment.new("New York", "Frankfurt", 611, 300, 1000)

# combine segments to a flight:
flight = Flight.new(bf, fn, nf, fb)

# the passenger
samson = Passenger.new("Samson")

# "normal" book 
puts "\n\nBook \"normal\" - no savings ====================================" 
samson.book(flight)

# activate bonus context ===================================================
fb = FlightBonus.new()
samson.setContext(fb)

# book with savings
puts "\n\nBook as frequent flyer ========================================" 
samson.book(flight)
print("   ===> earned credits: #{fb[samson].collectedCredits}\n")

# samson becomes very important ============================================
fbvip = FlightBonusVIP.new()
#transfer credits
fbvip[samson].collectedCredits= fb[samson].collectedCredits
#set new context
samson.setContext(fbvip)

puts "\n\nBook as vip flyer==============================================" 
samson.book(flight)
print("   ===> earned credits: #{fbvip[samson].collectedCredits}\n")


