class Factory < Team

  #Role of Person: a Employee, which can work
  class Employee
    def work
      #Here is the magic: myTeam points everytime to the actual team.
      #                   Here it points to Factory -> Factory::Task.new.doit.
      #                   In Bakery it points to Bakery -> Bakery::Task.new.doit
      # Implicit inheritance ensures the existence of <actualTeam>::Task so it
      # is safe to define this. 
      myTeam::Task.new.doit
    end
  end

  # Abstract role class
  class Task
    expected :doit
  end

  play_role(Employee, Person) {
    replace( :work, :work)
  }
end

class Bakery < Factory
  # This class is automatically a subtype of Factory::Task
  class Task
    def doit
      puts "baking bread...\n"
    end
  end
end

class SteelWork < Factory
  # This class is automatically a subtype of Factory::Task
  class Task
    def doit
      puts "waltzing steel...\n"
    end
  end
end
      
  
