
class ObserverPattern < Team
  
  # the observer role
  class Observer

    def start(observable)
      observable.addObserver(self)
    end

    def stop(observable)
      observable.removeObserver(self)
    end
    
    expected :update 
  end

  # the observable role
  class Observable
    attr :observer

    def initialize()
      @observer = Array.new
    end

    def addObserver(observer)
      @observer.push(observer)
    end

    def removeObserver(observer)
      @observer.delete(observer)
    end

    def notify()
      @observer.each { |o|
        o.update(self)
      }
    end
  end
end
