require "objectteam"
require "lock"
require "bank"
require "deploy"

#create a Bank of bananas.
b = Bank.new("Chiquota", "banana")

#normal behaviour
puts "\n\nnormal behaviour ==============================================="
b.deposit(2)
b.collective_deposit([3,4])

#create connector for simple lock
puts "\n\nsimple lock====================================================="
lock = LockedBank.new
#The simple lock will raise an exception, so we need a block to catch
begin
  #activate connector
  lock.while_active {
    b.deposit(20)   #should work
    b.collective_deposit([3,10,100]) #should fail!! :(
  }
rescue
  puts "Got error: #{$!}\n"
end

#This lock is more advanced
puts "\n\nsafe lock ======================================================"
safelock = SafeLockedBank.new
#activate connector
safelock.while_active {
  b.deposit(71)     #should work
  b.collective_deposit([10,20,30,40,50,60,90])  #should work too!
}

