
class Deploy
  attr :baseclass
  attr_accessor :roleclass
  attr :callins
  attr :callouts

  def initialize(baseclass, roleclass)
    @callins = Array.new
    @callouts = Array.new
    @baseclass = baseclass
    @roleclass = roleclass
  end

  def add_callin(callin)
    @callins.push(callin)
  end
  
  def add_callout(callout)
    @callouts.push(callout)
  end
end

class Mode
  AFTER = 1   #call a weaved method, after the original method
  BEFORE = 2  #call a weaved method, before the original method
  REPLACE = 3 #replace the current method
  CALLIN = 4  #make new method available

  def Mode.to_string(mode)
    case mode
    when AFTER 
      return "AFTER"
    when BEFORE 
      return "BEFORE"
    when REPLACE 
      return "REPLACE"
    when CALLIN 
      return "CALLIN"
    else
      return "_UNDEFINED_ !!!"
    end
  end
end

class CallDefinition
  attr :source #wird aufgerufen
  attr :sink   #wird dorthin gerouted
  attr :parametermapping #falls parameter(reihenfolge) angepasst werden muss
  
  def initialize(source, sink, parametermapping=nil)
    @source = source
    @sink = sink
    @parametermapping = parametermapping
  end
end

class Callin < CallDefinition
  attr :mode   #after|before|replace
  
  def initialize(source, sink, mode, parametermapping=nil)
    super(source, sink, parametermapping)
    @mode = mode
  end
end

class Callout < CallDefinition
end


# Deploy.rb   April 2002
#
# Copyright (c) 2002 by Matthias Veit <matthias_veit@yahoo.de>
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option) 
# any later version.
#  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
# GNU General Public License for more details.
#  
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA.
