
class Composite < Team

  #The abstract Component class.
  class Component

    # Add the given child.
    # [component] the component to add.
    def addChild(component)
      #do nothing
    end

    # Remove the given child
    # [component] the component ro remove.
    def removeChild(component)
      #do nothing
    end

    # Do some operation.
    # This method is abstract and has to be overridden!
    #do some operation
    def compositeOperation
    end

    expected :operation

  end

  
  # End of a Tree.
  class Leaf < Component
    def compositeOperation
      operation()
    end
  end

  # [Sub]Tree.
  class Composite < Component
    attr :components

    def initialize
      @components = Array.new
    end

    def addChild(component)
      @components.push(component)
    end

    def removeChild(component)
      #remove the component in our list
      @components.delete(component)
      #delegate the call to sublists
      @components.each { |comp|
        comp.removeChild(component)
      }
    end

    def compositeOperation()
      #delegate the call to all subitems.
      @components.each { |comp|
        comp.operation()
      }
      #call the base implementation.
      base()
    end
  end
end
