
class Bonus < Team
  
  class Subscriber
    attr_accessor :collectedCredits

    def initialize()
      @collectedCredits = 0
    end

    def collect(bonusitems)
      result = 0
      bonusitems.each { |bonusitem|
        result += bonusitem.bonus
      }
      @collectedCredits += result
    end
  end
  
  class BonusItem
    attr :bonus
    
    def initialize()
      @bonus = 0
    end
    
    def earnCredit()
      @bonus = self.calculateCredit()
    end
    
    expected :calculateCredit
  end
  
end

class FlightBonus < Bonus

  class BonusItem
    def calculateCredit()
      return ((self.getDistance().to_f/1000).ceil*1000)
    end
    expected :getDistance
  end

  playRole( Subscriber, Passenger ) {
    after( :collect, :booked ) { |flight|
      [flight.segments]
    }
  }
  playRole( BonusItem, Segment ) {
    after( :earnCredit, :book )
  }
end

class FlightBonusVIP < FlightBonus
  class BonusItem
    def calculateCredit()
      return super()*2
    end
  end
end
