
class ObserveLibrary < ObserverPattern

  playRole( Observable, BookCopy ) {
    after( :notify, [ :borrow, :returnIt ] )
  }

  playRole( Observer, BookManager ) {
    after( :start, :buy )
    after( :stop, :drop )
    delegateTo( :update, :updateStatus )
  }

end
Team.activate_static(ObserveLibrary)
