
require "objectteam"
require "event"
require "trace"
require "observerpattern"


def info(description)
  puts "\n\n"+ description.ljust(80).gsub(/  /, "==")
end

## create connectors ----------------------------------------------

#the observer pattern
class ButtonObserver < ObserverPattern
  play_role(Observer, Window) {
    # expected: update -> updateWindow
    delegate_to("update", "updateWindow")
  }
  play_role(Observable, Button) {
    after("notify", "pressed")
  }
end

#does logging
class MethodTrace < Tracing
  play_role(Trace, Window) {
    replace(:trace, /.*/)
  }
  play_role(Trace, Button) {
    replace(:trace, /.*/)
  }
end


## create instances ----------------------------------------------

observer = ButtonObserver.new
trace = MethodTrace.new
w = Window.new
b = Button.new("Press me")

## normal behaviour ----------------------------------------------

info("Normal behaviour")
b.pressed

## activate observer-connector -----------------------------------

observer.while_active {
  info("Observer activated")
  b.addObserver(w)
  b.pressed
}

## activate both connectors --------------------------------------

observer.while_active {
  trace.while_active {
    info("Tracer and Observer activated")
    b.pressed
  }
}

## activate trace connector --------------------------------------

trace.while_active {
  info("Tracer activated")
  b.pressed
}
