
class ObserverPattern < Team
  
  # the observer role
  class Observer
    expected :update 
  end

  # the observable role
  class Observable
    attr :observer

    def initialize()
      @observer = Array.new
    end

    def addObserver(observer)
      print "add observer: #{observer.class.name}\n"
      @observer.push(observer)
    end

    def removeObserver(observer)
      @observer.delete(observer)
    end

    def notify()
      @observer.each { |o|
        o.update(self)
      }
    end
  end

end
