class Tracing < Team
  class Trace

    #stack depth (static)
    @@depth=0
    
    def trace()
      #name of intercepted method
      source = JoinPoint.actualJoinPoint.source_method
      #tabulate output
      indent =  "".rjust(@@depth)
      #enter method
      puts indent+"[--> #{source}]\n"
      @@depth+=4
      base()
      @@depth-=4
      #leave method
      puts  indent+"[<-- #{source}]\n"
    end

  end
end
