require "objectteam"
require "../../simple/counter"

#create 3 instances of Simple.
e = Simple.new("earth")
m = Simple.new("mars")
v = Simple.new("venus")

class MyCountHello < CountHello

  # This method gets called, whenever a roleobject must be instantiated
  # and no block is given (block has higher precedence).
  def create_roleobject(base, roleclass)
    #we will count only those hellos, from planets where name includes an "s"
    result = nil
    if (base.name.include?("s"))
      puts "\n----->create role for #{base.to_s}\n"
      result = super(base, roleclass)
    else
      puts "\n----->no counting role for #{base.to_s}\n"
    end
    return result
  end

end

countteam = MyCountHello.new() 

#activate connector
countteam.while_active {
  e.hello
  m.hello
  v.hello
}


