require "objectteam"
require "../../simple/counter"

#create 2 instances of Simple.
e = Simple.new("earth")
m = Simple.new("mars")
#create connector with applied block to see, which role gets created.
countteam = CountHello.new() { |base, roleclass|
  puts "create role for #{base.to_s}\n"
  roleclass.new #return a new roleclass
}

#activate connector
countteam.while_active {

  puts "\nconnectors default: not weak ============\n"
  #the call to hello will create a role object
  e.hello
  
  #make the connector weak.
  #The connector no longer creates new roleobjects. Existing roleobjects can be used anyway.
  countteam.weak = true
  puts "\nconnector is weak =======================\n"

  #this should count the call to hello, because there is already a role applied.
  e.hello

  #this invocation does not reach the role - because the role is not created.
  m.hello

  #make connector "strong".
  countteam.weak = false
  puts "\nconnector is no longer weak =============\n"

  #now a role gets created:
  m.hello
}


