
# This connector extends the deposit method of Bank by a locking mechanism.
# This mechanism is thumb.
class LockedBank < Lockable
  play_role(Lock, Bank) {
    replace( :do_locked, :deposit )
    replace( :do_locked, :collective_deposit )
  }
end

# The more elegant way of a lock, is a safelock.
class SafeLockedBank < Lockable
  play_role(Lock, Bank) {
    replace( :do_safelocked, :deposit )
    replace( :do_safelocked, :collective_deposit )
  }
end

