
# This Team implements a simple mutex-lock.
# The method do_locked will lock, execute and unlock the method. During
# the method call no other invocation is valid, while the lock is active.
class Lockable < Team
  class Lock
    #indicates, if the lock is active.
    attr :locked

    # ctor.
    def initialize
      @locked = false
    end

    # Activate the lock.
    def lock
      raise "already locked" if @locked
      @locked = true
      puts "[lock access...  ]\n"
    end

    # Deactivate the lock.
    def unlock
      raise if not @locked
      @locked = false
      puts "[unlock access...]\n"
    end

    # Callin for methods to become a locked method.
    def do_locked
      lock()
      base()
    ensure
      unlock()
    end

    # Callin for methods to become a safe locked method.
    # This Team gets suspended for the time of the basecall.
    def do_safelocked
      lock()
      #Here is the magic: during the base call this team gets suspended
      get_connector().suspend
      base()
    ensure
      get_connector().resume
      #At this point the team is active again.
      unlock
    end
  end
end

