require "objectteam"
require "../simple/counter"

if (!ROTConfig::WEAKREFERENCE)
  puts "\n\nYou have to change your config to enable weak references!!\n"
  puts "Edit the file ROTConfig.rb and type: WEAKREFERENCE=true\n"
  puts "Test stopped.\n\n"
  exit
end

# create new Team
countteam = CountHello.new() 
NUM = 1000

# create some base objects and roles
baseobjects = Array.new
NUM.times { 
  #create new base object
  simple = Simple.new("earth")
  #remember base object
  baseobjects.push(simple)
  #lift explicitely
  countteam[simple]
}

puts "\n\n\n#{NUM} base objects created and lifted.\n"
puts "Team has #{countteam.compounds.length} roles.\n"

puts "\nRun the garbage collector. This should have no effect,\nbecause all references are still valid.\n"
puts "do garbage collection ...\n"
ObjectSpace.garbage_collect
puts "Team has #{countteam.compounds.length} roles.\n"

puts "\nForget about all baseobjects and run the garbage collector again\n"
baseobjects = nil
puts "do garbage collection ...\n"
ObjectSpace.garbage_collect
puts "Team has #{countteam.compounds.length} roles.\n"


