# $Id: ruby-dict.spec,v 1.5 2003/06/11 05:01:01 ianmacd Exp $
#
Summary: Ruby/DICT library
Name: ruby-dict
Version: 0.9.2
Release: 1
License: GPL
Group: Applications/Ruby
Source: http://www.caliban.org/files/ruby/%{name}-%{version}.tar.gz
URL: http://www.caliban.org/ruby/
Packager: Ian Macdonald <ian@caliban.org>
BuildRoot: /var/tmp/%{name}-%{version}
BuildRequires: ruby
Requires: ruby

%description
Ruby/DICT is an RFC 2229 compliant client-side library implementation of the
DICT protocol, written in the Ruby programming language. It can be used to
write clients that access dictionary definitions from a set of natural
language dictionary databases.

In addition, rdict, a dictionary client built on Ruby/DICT, is included.

%prep
%setup
make config ROOT=$RPM_BUILD_ROOT%{_prefix}
make setup

%clean 
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install ROOT=$RPM_BUILD_ROOT%{_prefix}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man{1,3}
install doc/dict.3 $RPM_BUILD_ROOT%{_mandir}/man3/dict.3
install doc/rdict.1 $RPM_BUILD_ROOT%{_mandir}/man1/rdict.1
gzip -9 $RPM_BUILD_ROOT%{_mandir}/{man1/rdict.1,man3/dict.3}

find $RPM_BUILD_ROOT%{_prefix} -type f -print | \
    ruby -pe 'sub(%r(^'$RPM_BUILD_ROOT'), "")' > %{name}-%{version}-filelist

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
%doc Changelog COPYING doc/dict.html doc/rdict.html doc/rfc2229.txt README TODO

%changelog
* Wed Jun 10 2003 Ian Macdonald <ian@caliban.org>
- 0.9.2
- print a message when a non-default matching strategy is used with rdict
  and no definitions are found
- fix a warning when run with Ruby 1.8

* Thu Jan  2 2003 Ian Macdonald <ian@caliban.org>
- 0.9.1
- allow multiple words to be specified on the command line of rdict

* Fri May 24 2002 Ian Macdonald <ian@caliban.org>
- 0.9.0
