/**
 * Graphics::PNG is PNG library
 *
 * @author DATE Ken (as Itacchi) / ge6537@i.bekkoame.ne.jp
 * @code-name Aoi
 * @see http://www.isc.meiji.ac.jp/~ee77038/ruby/
 * $Id: libpng.h,v 1.1 2000/09/27 17:43:32 date Exp date $
 */

#include "ruby.h"
#include "rubyio.h"
#include "png.h"
#include <time.h>

#ifndef png_jmpbuf
# define png_jmpbuf(png_ptr) ((png_ptr)->jmpbuf)
#endif

/* defined so I can write to a file on gui/windowing platforms */
/*  #define STDERR stderr  */
#define STDERR stdout   /* for DOS */

#define PNG_BYTES_TO_CHECK 4

typedef struct _png_object {
  FILE *fp;
  png_structp obj;
  png_infop info;
  png_infop end_info;
} png_object;

#define GET_PNG_VAL(obj, pobj) Data_Get_Struct(obj, png_object, pobj)

#define IS_COLOR_P(obj) libpng_color_check_type(obj)
#define IS_COLOR_16_P(obj) libpng_color_16_check_type(obj)
#define IS_COLOR_8_P(obj) libpng_color_8_check_type(obj)
#define IS_sPLT_ENTRY_P(obj) libpng_sPLT_entry_check_type(obj)
#define IS_TEXT_P(obj) libpng_text_check_type(obj)
#define IS_UNKNOWN_CHUNK_P(obj) libpng_unknown_chunk_check_type(obj)
#define IS_TIME_P(obj) time_check_type(obj)

/* for keep unknown chunks */
#define HANDLE_CHUNK_AS_DEFAULT   0
#define HANDLE_CHUNK_NEVER        1
#define HANDLE_CHUNK_IF_SAFE      2
#define HANDLE_CHUNK_ALWAYS       3


extern VALUE mGraphics;
extern VALUE mPng;
extern VALUE ePngError;

extern VALUE cPngColor;
extern VALUE cPngColor16;
extern VALUE cPngColor8;
extern VALUE cSuggestedPaletteEntry;
extern VALUE cText;
extern VALUE cUnknownChunk;

extern VALUE cReader;
extern VALUE cWriter;


extern VALUE libpng_color_new2(VALUE, png_colorp);
extern VALUE libpng_color_16_new2(VALUE, png_color_16p);
extern VALUE libpng_color_8_new2(VALUE, png_color_8p);
extern VALUE libpng_sPLT_entry_new2(VALUE, png_sPLT_entryp);
extern VALUE libpng_text_new2(VALUE, png_textp);
extern VALUE libpng_unknown_chunk_new2(VALUE, png_unknown_chunkp);
