#!/usr/local/bin/ruby

require 'libpng'

include Graphics::PNG


#if you will make softwere based on this library, should use libpng copyright below.
#print Graphics::PNG::copyright, "\n"
#print Graphics::PNG::libpng_ver, "\n"

def test
path = "/usr/local/src/png/libpng-1.0.6/contrib/pngsuite/"
#path = "/home/date/local/src/libpng-1.0.6/"
path = "./"
Dir::foreach(path){|f|
  if Graphics::PNG::is_png?(path+f)
    png = Reader.new(path+f)
  else
    next
  end

print "----- print infomation for PNG file -----\n"
print "file name: #{path+f}\n\n"
print "  --- chuck valid ---\n"
print "valid gAMA chunk: #{png.valid? INFO_gAMA}\n"
print "valid sBIT chunk: #{png.valid? INFO_sBIT}\n"
print "valid cHRM chunk: #{png.valid? INFO_cHRM}\n"
print "valid PLTE chunk: #{png.valid? INFO_PLTE}\n"
print "valid tRNS chunk: #{png.valid? INFO_tRNS}\n"
print "valid bKGD chunk: #{png.valid? INFO_bKGD}\n"
print "valid hIST chunk: #{png.valid? INFO_hIST}\n"
print "valid pHYs chunk: #{png.valid? INFO_pHYs}\n"
print "valid oFFs chunk: #{png.valid? INFO_oFFs}\n"
print "valid tIME chunk: #{png.valid? INFO_tIME}\n"
print "valid pCAL chunk: #{png.valid? INFO_pCAL}\n"
print "valid sRGB chunk: #{png.valid? INFO_sRGB}\n"
print "valid iCCP chunk: #{png.valid? INFO_iCCP}\n"
print "valid sPLT chunk: #{png.valid? INFO_sPLT}\n"
print "valid sCAL chunk: #{png.valid? INFO_sCAL}\n"
print "valid IDAT chunk: #{png.valid? INFO_IDAT}\n\n"

print "  --- image info. ---\n"
#print "IHDR :"
#p png.get_IHDR
print "width: #{png.get_image_width}\n"
print "height: #{png.get_image_height}\n"
print "bit depth: #{png.get_bit_depth}\n"
print "color type: #{png.get_color_type}\n"
print "interlace type: #{png.get_interlace_type}\n"
print "compression type: #{png.get_compression_type}\n"
print "filter type: #{png.get_filter_type}\n"

if png.valid? INFO_gAMA
  print "fixed gamma: #{png.get_gAMA_fixed}\n"
  print "gamma: #{png.get_gAMA}\n"
end

print "channels: #{png.get_channels}\n"

if png.valid? INFO_bKGD
  print "background color: "
  p png.get_bKGD
end

if png.valid? INFO_PLTE
  print "palette: "
#  png.get_PLTE.each{|pal| print "RGB: #{pal.red} #{pal.green} #{pal.blue}\n"}
end

print "pixel aspect ratio: #{png.get_pixel_aspect_ratio}\n"
print "pix/m: #{png.get_pixels_per_meter}\n"

if png.valid? INFO_hIST
  print "histogram: "
  p png.get_hIST
end

if png.valid? INFO_tIME
  print "mod-time: #{png.get_tIME}\n"
end

if png.valid? INFO_sBIT
  print "significant_bits:"
  p png.get_sBIT
end

if png.valid? INFO_tRNS
  print "transparency: "
  p png.get_tRNS
end

if png.valid? INFO_cHRM
  print "CIE x,y chromaticities: "
  p png.get_cHRM
  print "CIE x,y chromaticities(fixed): "
  p png.get_cHRM_fixed
end

if png.valid? INFO_iCCP
  print "ICC profile: "
  p png.get_iCCP
end

if png.valid? INFO_pCAL
  print "pixel calibration :"
  p png.get_pCAL
end

if png.valid? INFO_sPLT
  p png.get_sPLT
end

if png.get_texts
  print "text:\n"
  png.get_texts.each{|i| print "#{i.key} #{i.text}\n"}
end
print "\n\n"
}
end
