#!/usr/local/bin/ruby
require 'libpng'

include Graphics::PNG

def png_copy(read_png, write_png)
  rpng = Reader.new read_png
  wpng = Writer.new write_png

  print "Copying #{read_png} to #{write_png} ...\n"

  width, height, bit_depth, color_type,
  interlace_type, compression_type, filter_type = rpng.get_IHDR
  print "set IHDT chunk\n"
  wpng.set_IHDR width, height, bit_depth, color_type,
                interlace_type, compression_type, filter_type


  if chrm = rpng.get_cHRM_fixed
    print "set cHRM chunk\n"
    white_x, white_y, red_x, red_y, green_x, green_y, blue_x, blue_y = chrm
    wpng.set_cHRM_fixed white_x, white_y, red_x, red_y, green_x, green_y, blue_x, blue_y
  else
    print "no cHRM chunk\n"
  end


  if gamma = rpng.get_gAMA_fixed
    print "set gAMA chunk\n"
    wpng.set_gAMA gamma
  else
    print "no gAMA chunk\n"
  end


  if iccp = rpng.get_iCCP
    print "set iCCP chunk\n"
    name ,compression_type, profile = iccp
    wpng.set_iCCP name ,compression_type, profile
  else
    print "no iCCP chunk\n"
  end


  if intent = rpng.get_sRGB
    print "set sRGB chunk\n"
    wpng.set_sRGB intent
  else
    print "no sRGB chunk\n"
  end


  if palette = rpng.get_PLTE
    print "set PLTE chunk\n"
    wpng.set_PLTE palette
  else
    print "no PLTE chunk\n"
  end


  if background = rpng.get_bKGD
    print "set bKGD chunk\n"
    wpng.set_bKGD background
  else
    print "no bKGD chunk\n"
  end


  if hist = rpng.get_hIST
    print "set hIST chunk\n"
    wpng.set_hIST hist
  else
    print "no hIST chunk\n"
  end


  if offs = rpng.get_oFFs
    print "set oFFs chunk\n"
    offset_x, offset_y, unit_type = offs
    wpng.set_oFFs offset_x, offset_y, unit_type
  else
    print "no oFFs chunk\n"
  end


  if pcal = rpng.get_pCAL
    print "set pCAL chunk\n"
    purpose, x0, x1, type, units, params = pcal
    wpng.set_pCAL purpose, x0, x1, type, units, params
  else
    print "no pCAL chunk\n"
  end


  if phys = rpng.get_pHYs
    print "set pHYs chunk\n"
    res_x, res_y, unit_type = phys
    wpng.set_pHYs res_x, res_y, unit_type
  else
    print "no pHYs chunk\n"
  end


  if sig_bit = rpng.get_sBIT
    print "set sBIT chunk\n"
    wpng.set_sBIT sig_bit
  else
    print "no sBIT chunk\n"
  end


  if scal = rpng.get_sCAL
    print "set sCAL chunk\n"
    unit, width, height = scal
    wpng.set_sCAL unit, width, height
  else
    print "no sCAL chunk\n"
  end


  if texts = rpng.get_texts
    wpng.set_text texts
    print "set text chunk(s)\n"
  else
    print "no text chunk\n"
  end


  if mod_time = rpng.get_tIME
    print "set tIME chunk\n"
    wpng.set_tIME mod_time
  else
    print "no tIME chunk\n"
  end


  if trans = rpng.get_tRNS
    print "set tRNS chunk\n"
    wpng.set_tRNS trans
  else
    print "no tRNS chunk\n"
  end


  wpng.write_info

=begin
  $passes = -1
  status_fn = Proc.new{|row_number, pass|
    if pass != $passes
      print "Pass #{pass}:\n"
      $passes = pass
    end
  }
  rpng.set_read_status_fn status_fn
=end

=begin
#interlace reading / a single row at a time
  image = rpng.get_image_container
  pass = rpng.set_interlace_handling
  for i in 0...pass
    image.each{|row| rpng.read_row(row, nil)}
  end
=end

#=begin
#interlace reading / several row at a time
  image = rpng.get_image_container
  pass = rpng.set_interlace_handling
  number_of_rows = 10
  for i in 0...pass
    0.step(image.size, number_of_rows) do |row|
      rpng.read_rows(nil, image[row, number_of_rows])
    end
  end
#=end

#  image = rpng.read_image

  wpng.write_image image
  print "set IDAT chunks\n"

  rpng.read_end

  if texts = rpng.get_texts
    wpng.set_text texts
    print "set text chunk(s) at after IDAT\n"
  else
    print "no text chunk\n"
  end


  if mod_time = rpng.get_tIME
    print "set tIME chunk at after IDAT\n"
    wpng.set_tIME mod_time
  else
    print "no tIME chunk\n"
  end


  wpng.write_end

  print "OK, copying completed.\n"
end

print "Simple PNG library test.\n\n"

in_files = ARGV
if in_files.size == 0
  print "usage: pngtest.rb pngfiles ...\n\n"
  print "OK. Sample PNG image gonna copy.\n"
  in_files = ['es.png']
end

in_files.each do |read_png|
  write_png = File.basename(read_png, ".png")+".out.png"
  png_copy read_png, write_png
end
