/**
 * Graphics::PNG is PNG library
 *
 * splt.c include one class: 
 *  Graphics::PNG::SuggestedPaletteEntry.
 * This class is wrapper objects for libpng's png_sPLT_entry struct.
 * It's for the in-core representation of sPLT chunks.
 *
 * @author DATE Ken (as Itacchi) / ge6537@i.bekkoame.ne.jp
 * @code-name Aoi
 * @see http://www.isc.meiji.ac.jp/~ee77038/ruby/
 * $Id: splt.c,v 1.1 2000/09/27 17:15:17 date Exp date $
 */

#include "libpng.h"

VALUE cSuggestedPaletteEntry;


/*
 * ------------------------------------
 * Graphics::PNG::SuggestedPaletteEntry
 * ------------------------------------
 * is a wrapper object of the libpng's png_sPLT_entry struct.
 */
/*
=begin
= (({Graphics::PNG::SuggestedPaletteEntry}))
A wrapper object of the libpng's png_sPLT_entry struct.


=== class method

--- Graphics::PNG::SuggestedPaletteEntry.new
    Create PNG Suggested Palette Entry object.


=== instance method

--- Graphics::PNG::SuggestedPaletteEntry#alpha
    Get alpha value (in alpha channel images).
    Range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#alpha=(val)
    Set alpha value (in alpha channel images).
    Valid range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#blue
    Get blue color value (in RGB color images).
    Range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#blue=(val)
    Set blue color value (in RGB color images).
    Valid range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#frequency
    Get frequency.
    Range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#frequency=(val)
    Set frequency.
    Valid range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#green
    Get green color value (in RGB color images).
    Range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#green=(val)
    Set green color value (in RGB color images).
    Valid range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#red
    Get red color value (in RGB color images).
    Range of value is [0, 65535] (16bits).

--- Graphics::PNG::SuggestedPaletteEntry#red=(val)
    Set red color value (in RGB color images).
    Valid range of value is [0, 65535] (16bits).
=end
*/


#if defined(PNG_sPLT_SUPPORTED)
/*
 * --------------------------------------
 * utility function for
 *   Graphics::PNG::SuggestedPaletteEntry
 * --------------------------------------
 */
void
libpng_sPLT_entry_check_type(obj)
  VALUE obj;
{
  if (rb_class_of(obj) != cSuggestedPaletteEntry){
    rb_raise(rb_eTypeError,
             "wrong argument type %s (expected Graphics::PNG::SuggestedPaletteEntry)",
             rb_class2name(CLASS_OF(obj)));
  }
}




/*
 * --------------------------------------
 * class method of
 *   Graphics::PNG::SuggestedPaletteEntry
 * --------------------------------------
 */
static VALUE
libpng_sPLT_entry_new(klass)
  VALUE klass;
{
  VALUE new_obj;
  png_sPLT_entryp palette;

  new_obj = Data_Make_Struct(klass, png_sPLT_entry, NULL, free, palette);

  palette->red       = 0;
  palette->green     = 0;
  palette->blue      = 0;
  palette->alpha     = 0;
  palette->frequency = 0;

  return new_obj;
}



VALUE
libpng_sPLT_entry_new2(klass, entry)
  VALUE klass;
  png_sPLT_entryp entry;
{
  VALUE new_obj;
  png_sPLT_entryp palette;

  new_obj = Data_Make_Struct(klass, png_sPLT_entry, NULL, free, palette);

  palette->red       = entry->red;
  palette->green     = entry->green;
  palette->blue      = entry->blue;
  palette->alpha     = entry->alpha;
  palette->frequency = entry->frequency;

  return new_obj;
}




/*
 * --------------------------------------
 * instance method of
 *   Graphics::PNG::SuggestedPaletteEntry
 * --------------------------------------
 */
static VALUE
libpng_sPLT_initialize(obj)
  VALUE obj;
{
  return Qnil;
}



static VALUE
libpng_sPLT_entry_get_alpha(obj)
  VALUE obj;
{
  png_sPLT_entryp palette;

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  return INT2FIX(palette->alpha);
}



static VALUE
libpng_sPLT_entry_get_blue(obj)
  VALUE obj;
{
  png_sPLT_entryp palette;

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  return INT2FIX(palette->blue);
}



static VALUE
libpng_sPLT_entry_get_frequency(obj)
  VALUE obj;
{
  png_sPLT_entryp palette;

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  return INT2FIX(palette->frequency);
}



static VALUE
libpng_sPLT_entry_get_green(obj)
  VALUE obj;
{
  png_sPLT_entryp palette;

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  return INT2FIX(palette->green);
}



static VALUE
libpng_sPLT_entry_get_red(obj)
  VALUE obj;
{
  png_sPLT_entryp palette;

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  return INT2FIX(palette->red);
}



static VALUE
libpng_sPLT_entry_inspect(obj)
  VALUE obj;
{
  png_sPLT_entryp palette;
  char buf[256];
  VALUE str;

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  str = rb_str_new2("#<PNG::SuggestedPaletteEntry: ");

  sprintf(buf, "@red=%d, ", palette->red);
  rb_str_cat(str, buf, strlen(buf));

  sprintf(buf, "@green=%d, ", palette->green);
  rb_str_cat(str, buf, strlen(buf));

  sprintf(buf, "@blue=%d, ", palette->blue);
  rb_str_cat(str, buf, strlen(buf));

  sprintf(buf, "@frequency=%d", palette->frequency);
  rb_str_cat(str, buf, strlen(buf));

  rb_str_cat(str, ">", 1);

  return str;
}



static VALUE
libpng_sPLT_entry_set_alpha(obj, val)
  VALUE obj;
{
  png_sPLT_entryp palette;

  FIXNUM_P(val);

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  palette->alpha = FIX2INT(val);

  return Qnil;
}



static VALUE
libpng_sPLT_entry_set_blue(obj, val)
  VALUE obj;
{
  png_sPLT_entryp palette;

  FIXNUM_P(val);

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  palette->blue = FIX2INT(val);

  return Qnil;
}



static VALUE
libpng_sPLT_entry_set_frequency(obj, val)
  VALUE obj;
{
  png_sPLT_entryp palette;

  FIXNUM_P(val);

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  palette->frequency = FIX2INT(val);

  return Qnil;
}



static VALUE
libpng_sPLT_entry_set_green(obj, val)
  VALUE obj;
{
  png_sPLT_entryp palette;

  FIXNUM_P(val);

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  palette->green = FIX2INT(val);

  return Qnil;
}



static VALUE
libpng_sPLT_entry_set_red(obj, val)
  VALUE obj;
{
  png_sPLT_entryp palette;

  FIXNUM_P(val);

  Data_Get_Struct(obj, png_sPLT_entry, palette);

  palette->red = FIX2INT(val);

  return Qnil;
}
#endif /* PNG_sPLT_SUPPORTED */




void
Init_sPLT()
{
  /*
   * ------------------------------------
   * Graphics::PNG::SuggestedPaletteEntry
   * ------------------------------------
   */

#if defined(PNG_sPLT_SUPPORTED)
  cSuggestedPaletteEntry = rb_define_class_under(mPng, "SuggestedPaletteEntry", rb_cObject);


  rb_define_singleton_method(cSuggestedPaletteEntry, "new", libpng_sPLT_entry_new, 0);


  rb_define_method(cSuggestedPaletteEntry, "initialize", libpng_sPLT_initialize, -1);

  rb_define_method(cSuggestedPaletteEntry, "alpha",     libpng_sPLT_entry_get_alpha,     0);
  rb_define_method(cSuggestedPaletteEntry, "blue",      libpng_sPLT_entry_get_blue,      0);
  rb_define_method(cSuggestedPaletteEntry, "frequency", libpng_sPLT_entry_get_frequency, 0);
  rb_define_method(cSuggestedPaletteEntry, "green",     libpng_sPLT_entry_get_green,     0);
  rb_define_method(cSuggestedPaletteEntry, "red",       libpng_sPLT_entry_get_red,       0);

  rb_define_method(cSuggestedPaletteEntry, "inspect", libpng_sPLT_entry_inspect, 0);

  rb_define_method(cSuggestedPaletteEntry, "alpha=",     libpng_sPLT_entry_set_alpha,     1);
  rb_define_method(cSuggestedPaletteEntry, "blue=",      libpng_sPLT_entry_set_blue,      1);
  rb_define_method(cSuggestedPaletteEntry, "frequency=", libpng_sPLT_entry_set_frequency, 1);
  rb_define_method(cSuggestedPaletteEntry, "green=",     libpng_sPLT_entry_set_green,     1);
  rb_define_method(cSuggestedPaletteEntry, "red=",       libpng_sPLT_entry_set_red,       1);
#endif
}
