#!/usr/bin/env ruby
# 
# convert from panda circles.c
# 
# copy image file(input.tif, input2.tif, gnu-head.jpg, gnu-head.png, gnu_box.jpg)
# from Panda src directory into the current directory.

require "panda"

def drawcircle(mypage, xc, yc, len, lines)
  whichline = 0
  endpoints = []

  angle = 0
  while angle < 360
    xe = xc + Math.sin(angle * Math::PI / 180) * len
    ye = yc - Math.cos(angle * Math::PI / 180) * len

    mypage.setlinestart(xc, yc)
    mypage.addlinesegment(xe, ye)
    mypage.strokeline()
    mypage.endline()

    endpoints[whichline] = xe
    endpoints[whichline + 1] = ye
    whichline += 2
	angle += (360 / lines)
  end

  return endpoints
end


demo = Panda::PDF.new("circles.pdf", "w")

# Create a page
mypage = Panda::Page.new(demo, Panda::A4)

results = drawcircle(mypage, 200, 200, 100, 10)

count = 0
while count < 20
  printf "[%d, %d]\n", results[count], results[count + 1]

  drawcircle(mypage, results[count], results[count + 1], 10, 30)
  count += 2
end
