=begin
= Ruby/Panda
ext library for PDF Library Panda

== Module/Class Hierarchy

  Panda -+
           |
           +- Panda::PDF
           |
           +- Panda::Page

= Module Panda

== Constants

=== text drawing mode

--- Panda::NORMAL

--- Panda::OUTLINE

--- Panda::FILLEDOUTLINE

--- Panda::INVISIBLE

--- Panda::FILLEDCLIPPED

--- Panda::STROKEDCLIPPED

--- Panda::FILLEDSTROKEDCLIPPED

--- Panda::CLIPPED

=== line cap style

--- Panda::LINECAP_BUTT

--- Panda::LINECAP_ROUND

--- Panda::LINECAP_PROJECTEDSQUARE

=== line join style

--- Panda::LINEJOIN_MITER

--- Panda::LINEJOIN_ROUND

--- Panda::LINEJOIN_BEVEL

=== image type

--- Panda::TIFF

--- Panda::JPEG

--- Panda::PNG

=== Paper Size

--- Panda::A4

--- Panda::USLETTER

= Class Panda::PDF

== Class Methods

--- Panda::PDF.new(filename, mode)
      generate PDF Class.

== Methods

=== Document Attribute

--- Panda::PDF#setauthor(author)
      Set the author string for the PDF document.

--- Panda::PDF#setcreator(creator)
      Set the creator string for the PDF document.

--- Panda::PDF#settitle(title)
      Set the title string for the PDF document.

--- Panda::PDF#setsubject(subject)
      Set the subject string for the PDF document.

--- Panda::PDF#setkeywords(keywords)
      Set the keywords string for the PDF document.

=== Image

--- Panda::PDF#imagebox(page, top, left, bottom, right, filename, type)
      Insert an image into the PDF document at the specified location.
      This call is included for backward compatability withprevious releases of the API and it is recommened that new code call Panda::PDF#imageboxrot.
      It is unlikely that this call will be retired however.
      The image ((|type|))s accepted by this call are: Panda::TIFF, Panda::JPEG, Panda::PNG.

--- Panda::PDF#imageboxrot(page, top, left, bottom, right, angle, filename, type)
      Insert an image into the PDF document at the specified location.
      The image ((|type|))s accepted by this call are: Panda::TIFF, Panda::JPEG, Panda::PNG.

=== Font

--- Panda::PDF#setfont(fontname, type, encoding)
      Set the current font to be that specified.

--- Panda::PDF#setfontsize(size)
      Set the size of the font to be used next (in points).

--- Panda::PDF#setfontmode(mode)
      Set the current font mode.
      Valid ((|mode|))s are: 
      Panda::NORMAL, Panda::OUTLINE, Panda::FILLEDOUTLINE, Panda::INVISIBLE, Panda::FILLEDCLIPPED,
      Panda::STROKEDCLIPPED, Panda::FILLEDSTROKEDCLIPPED, Panda::CLIPPED.

--- Panda::PDF#setcharacterspacing(amount)
      Set the amount of additional space between characters in points.

--- Panda::PDF#setwordspacing(amount)
      Set the amount of additional space between words in points.

--- Panda::PDF#sethorizontalscaling(scaling)
      Set the horizontal scaling factor of the text in percent.

--- Panda::PDF#setleading(leading)
      Set the amount of space between lines of text in points.

=== Text

--- Panda::PDF#textbox(page, top, left, bottom, right, text)
      Display some ((|text|)) on the PDF ((|page|)) specified.

--- Panda::PDF#textboxrot(page, top, left, bottom, right, angle, text)
      Display some ((|text|)) at a jaunty ((|angle|)) on the PDF ((|page|)) specified.

=== Template

--- Panda::PDF#newtemplate(pageSize)
      Create a dummy page which they can make look nice and then use as a template all over the place.
      Templates are a bit different from pages in that the content stream is owned by the page as well.

--- Panda::PDF#applytemplate(page, template)
      Use the ((|template|)) on this ((|page|)).

= Class Panda::Page

== Class Methods

--- Panda::Page.new(PDF, pageSize)
      Create a new blank page at the end of the PDF with the specified size.
      Use the standard pagesize strings that are defined by Panda for most things.
      These are Panda::A4, and Panda::USLETTER.

== Methods

=== Graphics/Drawing

--- Panda::Page#setlinestart(x, y)
      Set the starting point for the sequence of curves and lines that it to be drawn on the current page.
      This call is compulsory for almost all of the line drawing functions. It is not required for the
      Panda::Page#rectangle call.

--- Panda::Page#addlinesegment(x, y)
      Add a point to the shape we are currently drawing with a straight line between the current cursor location and (x,y).

--- Panda::Page#addcubiccurvesegment(x, y, cx1, cy1, cx2, cy2)
      Add a point to the shape we are currently drawing with a cubic curve between the current cursor location and (x,y).
      There are two control points used to generate the cubic curve. They are (cx1, cy1) and (cx2, cy2).

--- Panda::Page#addquadraticcurvesegmentone(x, y, cx1, cy1)
      Add a curved segment to the line shape that we are drawing.
      The curved segment has a control point, namely (cx1, cy1).
      This call creates slightly different curves from Panda::Page#addquadraticcurvesegmenttwo

--- Panda::Page#addquadraticcurvesegmenttwo(x, y, cx1, cy1)
      Add a curved segment to the line shape that we are drawing.
      The curved segment has a control point, namely (cx1, cy1).
      This call creates slightly different curves from Panda::Page#addquadraticcurvesegmentone

--- Panda::Page#rectangle(top, left, bottom, right)
      Draw a rectangle on the PDF page.
      There is no need for the Panda::Page#setlinestart or Panda::Page#closeline calls.

=== Graphics/Path

--- Panda::Page#closeline()
      Close the line shape we are drawing by returning to the starting point as set by Panda::Page#setlinestart

--- Panda::Page#endline()
      Finalize the line shape we are drawing.
      Only one line shape may be drawn at any one time.
      There is no need for this call with the Panda::Page#rectangle call.

--- Panda::Page#strokeline()
      Stroke the line shape we have just drawn.
      This method must be called for the line shape that we have drawn to actually display on the PDF page.
      This process is known as 'stroking', and hence the name of this function call.

--- Panda::Page#fillline()
      Fill the shape we have just drawn with the previously defined fill.

=== Graphics/Attribute

--- Panda::Page#setlinewidth(width)
      Set the width of the line that is being drawn.
      You can use Panda::Page#setlinecap, Panda::Page#setlinejoin and Panda::Page#setlinedash to change other characteristics of the line.

--- Panda::Page#setlinecap(cap)
      Set the line cap for the lines we are drawing now.
      A line cap is used at the ends of lines that do not meet other lines.
      The different cap styles are: Panda::LINECAP_BUTT, Panda::LINECAP_ROUND, Panda::LINECAP_PROJECTEDSQUARE.

--- Panda::Page#setlinejoin(join)
      Set the line join style.
      A line join is used where the ends of two lines meet.
      The valid line joins and are: Panda::LINEJOIN_MITER, Panda::LINEJOIN_ROUND, Panda::LINEJOIN_BEVEL.

--- Panda::Page#setlinedash(on, off, phase)
      Define dashing pattern.
      This method allows the user to define a line dashing style, which is then applied to subsequent lines drawn on that page.
      The dashing style is defined as a on and off number, as well as a phase.

=== Graphics/Color

--- Panda::Page#setfillcolor(red, green, blue)
      Set the color to fill a close shape with.
      This method sets the color to fill a close shape with when the shape is closed.
      It is expressed as a combinartion of red, green, and blue.
      The maximum number for each value is 255 (a number greater than 255 is reduced to 255).

--- Panda::Page#setlinecolor(red, green, blue)
      Set the color of lines being drawn using a combination of red, green and blue.

=end
