#!/usr/bin/env ruby
# 
# convert from panda main.c
# 
# copy image file(input.tif, input2.tif, gnu-head.jpg, gnu-head.png, gnu_box.jpg)
# from Panda src directory into the current directory.

require "panda"

print "Welcome to the Ruby/Panda sample application...\n"

demo = Panda::PDF.new("output.pdf", "w")

# Create a page
currPage = Panda::Page.new(demo, Panda::A4)

# Put in the background images
demo.imagebox(currPage,
			  0, 0, currPage.height / 2, currPage.width,
			  "input.tif", Panda::TIFF)
demo.imagebox(currPage, currPage.height / 2, 0, currPage.height,
			  currPage.width, "input2.tif", Panda::TIFF)

demo.imagebox(currPage, 317, 317, 434, 434, "gnu_box.jpg",
			  Panda::JPEG)
demo.imagebox(currPage, 434, 434, 551, 551, "gnu_box.jpg",
			  Panda::JPEG)

# Do an panda_imageboxrot or two to test the code included by Ceasar Miquel
demo.imageboxrot(currPage, 600, 0, 717, 117, 15.0,
				 "gnu_box.jpg", Panda::JPEG)

demo.imageboxrot(currPage, 600, 200, 717, 317, 30.0,
				 "gnu_box.jpg", Panda::JPEG)
  
demo.imageboxrot(currPage, 600, 400, 717, 517, 42.0,
				 "gnu_box.jpg", Panda::JPEG)
  
demo.imageboxrot(currPage, 700, 0, 817, 117, 90.0,
				 "gnu_box.jpg", Panda::JPEG)

demo.imageboxrot(currPage, 700, 200, 817, 317, 132.0,
				 "gnu_box.jpg", Panda::JPEG)

# Insert a PNG to show that I can
demo.imageboxrot(currPage, 100, 200, 200, 300, 0.0,
				 "libpng.png", Panda::PNG)

demo.imageboxrot(currPage, 300, 200, 400, 300, 0.0,
				 "gnu.png", Panda::PNG)

demo.imageboxrot(currPage, 100, 420, 310, 620, 36.0,
				 "RedbrushAlpha.png", Panda::PNG)

# (c) statement
demo.setfont("Times-Roman", 1,"MacRomanEncoding")
demo.textbox(currPage, 600, 10, 700, 300,
			 "The background image on this page is Copyright 2000 Andrew Cagney")
demo.textbox(currPage, 620, 10, 720, 300,
			 "and is distributed under the terms of the GPL...")
demo.textbox(currPage, 310, 320, 330, 800,
			 "Flower (c) 1999 Pieter S. van der Meulen")

# ##### ##### ##### ##### ##### ##### ##### ##### ##### #####
# Text functionality (with a few images thrown in as well)
# ##### ##### ##### ##### ##### ##### ##### ##### ##### #####

currPage = Panda::Page.new(demo, Panda::A4)

# I am not drawing a multiline string here because I am not sure how to 
# represent this in the PDF at the moment

lineDepth = 0

tempString = sprintf("Hello %c5World! %cMy name %c5is Panda!\nAnd I am a PDF generator\nI handle multiple line text ok .once you have set a leading.", 4, 6, 5)
demo.textbox(currPage, lineDepth * 20 + 10, 10 + lineDepth, 100,
			 30, tempString)
  
demo.setfont("Symbol", 1, "MacRomanEncoding")
demo.textbox(currPage, lineDepth * 20 + 50, 10 + lineDepth, 100,
			 30, "Symbol")

demo.setfont("Helvetica-Bold", 1, "MacRomanEncoding")
demo.textbox(currPage, lineDepth * 20 + 70, 30 + lineDepth, 100,
			 30, "A line in Helvetica-Bold")
  
demo.imagebox(currPage, 100, 100, 150, 150, "gnu-head.jpg",
			  Panda::JPEG)
demo.textbox(currPage, 90, 110, 200, 200,
			 "INFRONTINFRONTINFRONT")
  
demo.textbox(currPage, 190, 210, 300, 300,
			 "BEHINDBEHINDBEHIND")
demo.imagebox(currPage, 200, 200, 317, 317, "gnu_box.jpg",
			  Panda::JPEG)
  
demo.textbox(currPage, 300, 10, 400, 50,
			 "A second textbox on the page")

# ##### ##### ##### ##### ##### ##### ##### ##### ##### #####
# Demonstrate the supported text modes
# ##### ##### ##### ##### ##### ##### ##### ##### ##### #####

currPage = Panda::Page.new(demo, Panda::A4)

demo.setleading(16.0)

for lineDepth in 0...8

  demo.setfontmode(Panda::NORMAL)

  case lineDepth
  when Panda::NORMAL
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "Normal")
  when Panda::OUTLINE
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "Outline")
  when Panda::FILLEDOUTLINE
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "FilledOutline")
  when Panda::INVISIBLE
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "Invisible")
  when Panda::FILLEDCLIPPED
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "FilledClipped")
  when Panda::STROKEDCLIPPED
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "Stroked Clipped")
  when Panda::FILLEDSTROKEDCLIPPED
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "Filled Stroked Clipped")
  when Panda::CLIPPED
	demo.textbox(currPage, 20 + (lineDepth * 20), 10,
				 40 + (lineDepth * 20), 400, "Clipped")
  end

  demo.setcharacterspacing(lineDepth)
  demo.setwordspacing(lineDepth * 10)
  demo.sethorizontalscaling(1 - (lineDepth.to_f * 0.1))

  demo.setfontmode(lineDepth)
  demo.textbox(currPage, 20 + (lineDepth * 20), 200,
			   40 + (lineDepth * 20), 400, "Demonstration of a text mode")
end

#  ///////////////////////////////////////////////////////////////////////////
#  // Demonstrate the supported lines and curve thingies -- note that no
#  // graphics state is held from the previous set of lines, so you'll need
#  // to rebuild it each time.
#  ///////////////////////////////////////////////////////////////////////////

# Create a page
currPage = Panda::Page.new(demo, Panda::A4)

demo.setfontmode(Panda::NORMAL)
demo.textbox(currPage, 40, 10, 55, 200,
			 "Please note that these shapes are lines, and there is no")
demo.textbox(currPage, 60, 10, 75, 200,
			 "requirement to have the shapes closed...")

# Straight lines of all types -- stroked
currPage.setlinestart(110, 110)
currPage.addlinesegment(160, 130)
currPage.addlinesegment(210, 186)
currPage.addlinesegment(96, 22)
currPage.closeline()
currPage.strokeline()
currPage.endline()

# Now some curves -- stroked
currPage.setlinestart(210, 210)
currPage.addcubiccurvesegment(310, 210, 225, 300, 275, 400)
currPage.addquadraticcurvesegmentone(160, 160, 200, 225)
currPage.addquadraticcurvesegmenttwo(210, 210, 250, 375)
currPage.closeline()
currPage.strokeline()
currPage.endline()

# Rectangles -- stroked
currPage.rectangle(210, 210, 310, 310)
currPage.strokeline()
currPage.endline()

# Straight lines of all types -- stroked and filled
currPage.setlinecolor(99, 33, 255)
currPage.setlinestart(110, 310)
currPage.setlinewidth(5)
currPage.addlinesegment(160, 330)
currPage.addlinesegment(210, 386)
currPage.addlinesegment(96, 222)
currPage.closeline()
currPage.strokeline()
currPage.fillline()
currPage.endline()

# Now some curves -- stroked and filled
currPage.setlinestart(210, 410)
currPage.setlinewidth(5)
currPage.addcubiccurvesegment(310, 410, 225, 500, 275, 600)
currPage.addquadraticcurvesegmentone(160, 360, 200, 425)
currPage.addquadraticcurvesegmenttwo(210, 410, 250, 575)
currPage.closeline()
currPage.strokeline()
currPage.fillline()
currPage.endline()

# Rectangles -- stroked filled
currPage.setlinewidth(5)
currPage.rectangle(410, 210, 510, 310)
currPage.strokeline()
currPage.fillline()
currPage.endline()

# Straight lines of all types -- stroked and capped
currPage.setlinewidth(10)
currPage.setlinestart(100, 600)
currPage.addlinesegment(200, 600)
currPage.strokeline()
currPage.endline()

currPage.setlinewidth(10)
currPage.setlinecap(Panda::LINECAP_BUTT)
currPage.setlinestart(100, 625)
currPage.addlinesegment(200, 625)
currPage.strokeline()
currPage.endline()

currPage.setlinewidth(10)
currPage.setlinecap(Panda::LINECAP_ROUND)
currPage.setlinestart(100, 650)
currPage.addlinesegment(200, 650)
currPage.strokeline()
currPage.endline()

currPage.setlinewidth(10)
currPage.setlinecap(Panda::LINECAP_PROJECTEDSQUARE)
currPage.setlinestart(100, 675)
currPage.addlinesegment(200, 675)
currPage.strokeline()
currPage.endline()

# Mitre joints
currPage.setlinewidth(10)
currPage.setlinecap(Panda::LINECAP_BUTT)
currPage.setlinestart(300, 600)
currPage.addlinesegment(350, 650)
currPage.addlinesegment(400, 600)
currPage.strokeline()
currPage.endline()

currPage.setlinewidth(10)
currPage.setlinejoin(Panda::LINEJOIN_MITER)
currPage.setlinestart(300, 625)
currPage.addlinesegment(350, 675)
currPage.addlinesegment(400, 625)
currPage.strokeline()
currPage.endline()

currPage.setlinewidth(10)
currPage.setlinejoin(Panda::LINEJOIN_ROUND)
currPage.setlinestart(300, 650)
currPage.addlinesegment(350, 700)
currPage.addlinesegment(400, 650)
currPage.strokeline()
currPage.endline()

currPage.setlinewidth(10)
currPage.setlinejoin(Panda::LINEJOIN_BEVEL)
currPage.setlinestart(300, 675)
currPage.addlinesegment(350, 725)
currPage.addlinesegment(400, 675)
currPage.strokeline()
currPage.endline()

# Do some work with line dashing
currPage.setlinedash(1, 0, 0)
currPage.setlinejoin(Panda::LINEJOIN_ROUND)

currPage.setlinestart(100, 800)
currPage.addlinesegment(100, 750)
currPage.addlinesegment(140, 800)
currPage.closeline()
currPage.strokeline()
currPage.endline()

currPage.setlinedash(3, 3, 0)
currPage.setlinestart(150, 800)
currPage.addlinesegment(150, 750)
currPage.addlinesegment(190, 800)
currPage.closeline()
currPage.strokeline()
currPage.endline()

currPage.setlinedash(2, 1, 1)
currPage.setlinestart(200, 800)
currPage.addlinesegment(200, 750)
currPage.addlinesegment(240, 800)
currPage.closeline()
currPage.strokeline()
currPage.endline()

#  ///////////////////////////////////////////////////////////////////////////
#  // We can also setup template pages to make life a little easier (and the
#  // document a little smaller)
#  ///////////////////////////////////////////////////////////////////////////

currPage = Panda::Page.new(demo, Panda::A4)
currPage.setlinestart(100, 800)

demo.close
