#!/usr/bin/env ruby
# 
# convert from panda morecircles.c
# 
# ./morecircles.rb 2 3 2

require "panda"

def drawcircle(mypage, xc, yc, len, lines)

  if len < $minlen
    return
  end

  angle = 0
  while angle < 360
    xe = xc + Math.sin(angle * Math::PI / 180) * len
    ye = yc - Math.cos(angle * Math::PI / 180) * len

    mypage.setlinestart(xc, yc)
    mypage.addlinesegment(xe, ye)
    mypage.strokeline()
    mypage.endline()

	drawcircle(mypage, xe, ye, len / $reduce, lines)

	angle += (360 / lines)
  end
end


demo = Panda::PDF.new("morecircles.pdf", "w")

# Create a page
mypage = Panda::Page.new(demo, Panda::A4)

$reduce = ARGV[0].to_i
$degree = ARGV[1].to_i
$minlen = ARGV[2].to_i

drawcircle(mypage, 200, 200, 100, $degree)
