/* panda.i */

%module panda

%{
/*#include <panda/objects.h>*/
#include <panda/constants.h>
#include <panda/functions.h>


// constants.h
// The text drawing modes (p 343 v 1.3)
enum {
  NORMAL = 0,
  OUTLINE,
  FILLEDOUTLINE,
  INVISIBLE,
  FILLEDCLIPPED,
  STROKEDCLIPPED,
  FILLEDSTROKEDCLIPPED,
  CLIPPED
};

// The line cap styles (p 139 v 1.3 II)
enum {
  LINECAP_BUTT = 0,
  LINECAP_ROUND,
  LINECAP_PROJECTEDSQUARE,
  LINECAP_MAX                              // Not in the spec!
};

// The line join styles (p 140 v 1.3 II)
enum {
  LINEJOIN_MITER = 0,
  LINEJOIN_ROUND,
  LINEJOIN_BEVEL,
  LINEJOIN_MAX                             // Not in the spec!
};

// The image types supported
enum {
  TIFF = 0,
  JPEG,
  PNG
};

typedef panda_pdf PDF;
typedef panda_page Page;

static panda_pdf *opened_pdf;
static int        opened_pdf_flag = 0;
%}


/*
 * constants.h
 */

#define  A4        "[0 0 594 841]"
#define  USLETTER  "[0 0 612 792]"

typedef enum {
  NORMAL = 0,
  OUTLINE,
  FILLEDOUTLINE,
  INVISIBLE,
  FILLEDCLIPPED,
  STROKEDCLIPPED,
  FILLEDSTROKEDCLIPPED,
  CLIPPED
} TEXTMODE;

enum {
  LINECAP_BUTT = 0,
  LINECAP_ROUND,
  LINECAP_PROJECTEDSQUARE,
  LINECAP_MAX                              // Not in the spec!
};

enum {
  LINEJOIN_MITER = 0,
  LINEJOIN_ROUND,
  LINEJOIN_BEVEL,
  LINEJOIN_MAX                             // Not in the spec!
};

typedef enum {
  TIFF = 0,
  JPEG,
  PNG
} IMAGE;


/*
 * objects.h
 * functions.h
 */

typedef struct {
  %readonly
  int height;
  int width;
  %addmethods {
	Page(PDF *output, char *pageSize) {
	  return panda_newpage(output, pageSize);
	}
	~Page() {
	}
	void setlinestart(int x, int y) {
	  panda_setlinestart(self, x, y);
	}
	void addlinesegment(int x, int y) {
	  panda_addlinesegment(self, x, y);
	}
	void addcubiccurvesegment(int x, int y, int cx1,
									int cy1, int cx2, int cy2) {
	  panda_addcubiccurvesegment(self, x, y, cx1, cy1, cx2, cy2);
	}
	void addquadraticcurvesegmentone(int x, int y, int cx1, int cy1) {
	  panda_addquadraticcurvesegmentone(self, x, y, cx1, cy1);
	}
	void addquadraticcurvesegmenttwo(int x, int y, int cx1, int cy1) {
	  panda_addquadraticcurvesegmenttwo(self, x, y, cx1, cy1);
	}
	void closeline() {
	  panda_closeline(self);
	}
	void rectangle(int top, int left, int bottom, int right) {
	  panda_rectangle(self, top, left, bottom, right);
	}
	void endline() {
	  panda_endline(self);
	}
	void strokeline() {
	  panda_strokeline(self);
	}
	void fillline() {
	  panda_fillline(self);
	}
	void setlinewidth(int width) {
	  panda_setlinewidth(self, width);
	}
	void setlinecap(int cap) {
	  panda_setlinecap(self, cap);
	}
	void setlinejoin(int join) {
	  panda_setlinejoin(self, join);
	}
	void setlinedash(int on, int off, int phase) {
	  panda_setlinedash(self, on, off, phase);
	}
	void setfillcolor(int red, int green, int blue) {
	  panda_setfillcolor(self, red, green, blue);
	}
	void setlinecolor(int red, int green, int blue) {
	  panda_setlinecolor(self, red, green, blue);
	}
  }
} Page;


typedef struct {
  unsigned long byteOffset, xrefOffset;
  
} PDF;

%addmethods PDF {
  PDF(char *filename, char *mode) {
    if (opened_pdf_flag == 1) {
	  panda_close (opened_pdf);
	}
	opened_pdf_flag = 1;
	return (opened_pdf = panda_open_actual (filename, mode, panda_false));
  }
  ~PDF() {
	if (self && opened_pdf_flag == 1 && opened_pdf == self) panda_close (self);
  }
  void close() {
	opened_pdf_flag = 0;
	panda_close (self);
  }
//  Page *page(char *pageSize) {
//	return panda_newpage(self, pageSize);
//  }
  // Images.c
  void imagebox (Page *target, int top, int left, int bottom, int right, char *filename, int type) {
	panda_imagebox (self, target, top, left, bottom, right, filename, type);
  }
  void imageboxrot (Page *target, int top, int left, int bottom, int right, double angle, char *filename, int type) {
	panda_imageboxrot (self, target, top, left, bottom, right, angle, filename, type);
  }

  // Info.c
  void setauthor (char *author) {
	panda_setauthor (self, author);
  }
  void setcreator (char *creator) {
	panda_setcreator (self, creator);
  }
  void settitle (char *title) {
	panda_settitle (self, title);
  }
  void setsubject (char *subject) {
	panda_setsubject (self, subject);
  }
  void setkeywords (char *keywords) {
	panda_setkeywords (self, keywords);
  }

  // Font.c
  //char *createfont (char *fontname, int type, char *encoding)
  //object *getfontobj (pdf *, char *);
  void setfont (char *fontname, int type, char *encoding) {
	char *tempPtr;

	tempPtr = panda_createfont (self, fontname, type, encoding);
	panda_setfont (self, tempPtr);
	free(tempPtr);
  }
  void setfontsize (int size) {
	panda_setfontsize (self, size);
  }
  void setfontmode (int mode) {
	panda_setfontmode (self, mode);
  }
  void setcharacterspacing (double amount) {
	panda_setcharacterspacing (self, amount);
  }
  void setwordspacing (double amount) {
	panda_setwordspacing (self, amount);
  }
  void sethorizontalscaling (double scaling) {
	panda_sethorizontalscaling (self, scaling);
  }
  void setleading (double leading) {
	panda_setleading (self, leading);
  }

  // Template.c
  Page *newtemplate(char *pageSize) {
	return panda_newtemplate (self, pageSize);
  }
  void applytemplate(Page *target, Page *template) {
	panda_applytemplate(self, target, template);
  }

  // Text.c
  void textbox (Page *thisPage, int top, int left, int bottom, int right, char *text) {
	panda_textbox (self, thisPage, top, left, bottom, right, text);
  }
  void textboxrot(Page * thisPage, int top, int left, int bottom, int right, double angle, char *text) {
	panda_textboxrot (self, thisPage, top, left, bottom, right, angle, text);
  }

}
