=begin
= SMF module

== Classes

* Sequence <format, division, tc=nil>

* Track

* Event <offset>
  * MIDIMessage
    * ChannelMessage <..., ch>
      * VoiceMessage
        * NoteOff <..., note, vel>
        * NoteOn <..., note, vel>
        * PolyphonicKeyPressure <..., note, val>
        * ControlChange <..., num, val>
        * ProgramChange <..., num>
        * ChannelPressure <..., val>
        * PitchBendChange <..., val>
      * ChannelModeMessage
        * AllSoundOff <..., ch>
	* ResetAllControllers <..., ch>
	* LocalControl <..., ch, val>
	* AllNotesOff <..., ch>
	* OmniOff <..., ch>
	* OmniOn <..., ch>
	* MonoMode <..., ch, val>
	* PolyMode <..., ch>

  * SystemMessage
    * ExclusiveMessage
      * ExclusiveF0 <..., data>
      * ExclusiveF7 <..., data>

  * Meta
    * SequenceNumber <..., num>
    * Text <..., text>
      * GeneralPurposeText (Text01)
      * CopyrightNotice (Text02)
      * TrackName (SequenceName, Text03)
      * InstrumentName (Text04)
      * Lyric (Display, Text05)
      * Marker (Text06)
      * CuePoint (Text07)
      * ProgramName (Text08)
      * DeviceName (Text09)
      * Text0A
      * Text0B
      * Text0C
      * Text0D
      * Text0E
      * Text0F
    * ChannelPrefix <..., ch>
    * MIDIPort <..., num> (not in RP-001)
    * EndOfTrack
    * SetTempo <..., tempo>
    * SMPTEOffset <..., hr, mn, se, fr, ff, tc>
    * TimeSignature <..., nn, dd, cc, bb>
    * KeySignature <..., sf, mi>
    * SequencerSpecific <..., data>

== Sequence

=== Super Class

Object

=== Included Modules

Enumerable

=== Class Methods

: decode(str)
: read(io)
: load(fn)

: new([format=1[, division=96[,tc=nil]]])

The three methods decode(), read() and load() replace NoteOn with NoteOff
when its velocity is zero.

=== Accessors

: format
: division
: tc

=== Methods

This nearly have all methods of array object.
In addition, this also have the following methods.

: ntrks
: self >> tr
: each{|tr| ...}
: join!
: encode
: write(io)
: save(fn)

The iterator each{} ignores all nil elements.

== Track

=== Super Class

Object

=== Included Modules

Enumerable

=== Class Methods

: new

=== Methods

This nearly have all methods of array object.
In addition, this also have the following methods.

: nevts
: self >> ev
: each{|ev| ...}

The iterator each{} ignores all nil elements and sorts events (stable).

== Event

=== Super Class

Object

=== Included Modules

Comparable

=== Accessors

: offset

=end
