# groove.rb: Written by Tadayoshi Funaba 2005,2006
# $Id: groove.rb,v 1.2 2006-06-24 18:50:22+09 tadf Exp $

require 'gsl'

module SMF

  class Groove

    def initialize(div, pat)
      @unit = pat[-1] * div * 4
      x = []; y = []
      pat.each_with_index do |p, i|
	x << @unit / (pat.size - 1) * i
	y << p * div * 4
      end
      @x = Vector.alloc(x)
      @y = Vector.alloc(y)
      @interp = Interp.alloc('linear', pat.size)
      self.amount = 0.5
    end

    def amount=(v) @amount = v end

    def groove(ev)
      q, r = ev.offset.divmod(@unit)
      r2 = @interp.eval(@x, @y, r)
      r3 = r + (r2 - r) * @amount
      ev.offset = (q * @unit + r3).round
    end

  end

end
