#! /usr/bin/env ruby

# mml.rb: Written by Tadayoshi Funaba 1999-2006
# $Id: mml.rb,v 1.4 2006-11-10 21:57:06+09 tadf Exp $

require 'smf/toy/macro/mml'
require 'gopt'
include SMF

def usage
  warn 'usage: mml [-o output] [-e command] [input]'
  exit 1
end

usage unless opt = Gopt.gopt('o:e:')
usage unless $*.size >= 0 && $*.size <= 1

ifile = $*.shift
ifile = nil if ifile == '-'

ofile = opt[:o] if opt[:o]
ofile ||= File.basename(ifile, '.mml') + '.mid' if ifile
ofile = nil if ofile == '-'

so = opt[:e] if opt[:e]
so ||= unless ifile then $stdin.read else IO.read(ifile) end
sq = Sequence.new(1, 480)
mm = MML.new(sq)
mm << so
begin
  mm.generate
rescue ParseError
  warn format('%s: %s', (opt[:e] && '-e') || ifile || '(stdin)', $!)
  exit 1
end
unless ofile then sq.write($stdout) else sq.save(ofile) end
